/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.FilterTagChildrenVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class ChangePluginConfiguration
extends Recipe {
    private static final XPathMatcher PLUGINS_MATCHER = new XPathMatcher("/project/build/plugins");
    @Option(displayName="Group", description="The first part of the coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION' of the plugin to modify.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION' of the plugin to modify.", example="rewrite-maven-plugin")
    private final String artifactId;
    @Option(displayName="Configuration", description="Plugin configuration provided as raw XML overriding any existing configuration. Configuration inside `<executions>` blocks will not be altered. Supplying `null` will remove any existing configuration.", example="<foo>bar</foo>", required=false)
    @Language(value="xml")
    private final @Nullable String configuration;
    private final String displayName = "Change Maven plugin configuration";
    private final String description = "Apply the specified configuration to a Maven plugin. Will not add the plugin if it does not already exist in the pom.";

    public String getInstanceNameSuffix() {
        return String.format("for `%s:%s`", this.groupId, this.artifactId);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional<Xml.Tag> maybePlugin;
                Xml.Tag plugins = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (PLUGINS_MATCHER.matches(this.getCursor()) && (maybePlugin = plugins.getChildren().stream().filter(plugin -> "plugin".equals(plugin.getName()) && ChangePluginConfiguration.this.groupId.equals(plugin.getChildValue("groupId").orElse(null)) && ChangePluginConfiguration.this.artifactId.equals(plugin.getChildValue("artifactId").orElse(null))).findAny()).isPresent()) {
                    Xml.Tag plugin2 = maybePlugin.get();
                    plugins = ChangePluginConfiguration.this.configuration == null ? FilterTagChildrenVisitor.filterChildren((Xml.Tag)plugins, (Xml.Tag)plugin2, child -> !(child instanceof Xml.Tag) || !"configuration".equals(((Xml.Tag)child).getName())) : AddOrUpdateChild.addOrUpdateChild((Xml.Tag)plugins, (Xml.Tag)plugin2, (Xml.Tag)Xml.Tag.build((String)("<configuration>\n" + ChangePluginConfiguration.this.configuration + "\n</configuration>")), (Cursor)this.getCursor().getParentOrThrow());
                }
                return plugins;
            }
        };
    }

    @Generated
    public ChangePluginConfiguration(String groupId, String artifactId, @Language(value="xml") @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.configuration = configuration;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Language(value="xml")
    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangePluginConfiguration(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", configuration=" + this.getConfiguration() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePluginConfiguration)) {
            return false;
        }
        ChangePluginConfiguration other = (ChangePluginConfiguration)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangePluginConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

