/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.marker.Markup;
import org.openrewrite.maven.ChangeDependencyScope;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.UpgradeDependencyVersion;
import org.openrewrite.maven.internal.InsertDependencyComparator;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.tree.Version;
import org.openrewrite.semver.ExactVersion;
import org.openrewrite.semver.LatestRelease;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class AddDependencyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private static final XPathMatcher DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencies");
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final @Nullable String versionPattern;
    private final @Nullable String scope;
    private final @Nullable Boolean releasesOnly;
    private final @Nullable String type;
    private final @Nullable String classifier;
    private final @Nullable Boolean optional;
    private final @Nullable Pattern familyRegex;
    private final @Nullable MavenMetadataFailures metadataFailures;
    private @Nullable VersionComparator versionComparator;
    private @Nullable String resolvedVersion;

    public AddDependencyVisitor(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, @Nullable Pattern familyRegex) {
        this(groupId, artifactId, version, versionPattern, scope, releasesOnly, type, classifier, optional, familyRegex, null);
    }

    @Override
    public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext executionContext) {
        if (this.isDependencyTag()) {
            ResolvedPom resolvedPom = this.getResolutionResult().getPom();
            String existingGroupId = resolvedPom.getValue(tag.getChildValue("groupId").orElse(null));
            String existingArtifactId = resolvedPom.getValue(tag.getChildValue("artifactId").orElse(null));
            if (this.groupId.equals(existingGroupId) && this.artifactId.equals(existingArtifactId)) {
                Scope requestedScope = Scope.fromName(this.scope);
                Scope existingScope = Scope.fromName(resolvedPom.getValue(tag.getChildValue("scope").orElse(null)));
                if (tag.getMarkers().getMarkers().stream().anyMatch(m -> m instanceof Markup.Warn && ((Markup.Warn)m).getDetail().startsWith("org.openrewrite.maven.MavenDownloadingException"))) {
                    this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "existingDependencyFailure", (Object)true);
                } else if (requestedScope != existingScope && (existingScope.isInClasspathOf(requestedScope) && Scope.maxPrecedence(existingScope, requestedScope) == existingScope || !existingScope.isInClasspathOf(requestedScope) && !requestedScope.isInClasspathOf(existingScope) && Scope.Test != requestedScope && Scope.maxPrecedence(Scope.Test, requestedScope) == Scope.Test)) {
                    this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "doNotAlterDependency", (Object)true);
                } else {
                    String versionToUse = null;
                    String managedVersion = this.getResolutionResult().getPom().getManagedVersion(this.groupId, this.artifactId, this.type, this.classifier);
                    if ((managedVersion == null || this.versionComparator != null && !this.versionComparator.isValid(this.version, managedVersion)) && (versionToUse = this.tryGetFamilyVersion()) == null) {
                        try {
                            versionToUse = this.findVersionToUse(executionContext);
                        }
                        catch (MavenDownloadingException e) {
                            return e.warn(tag);
                        }
                    }
                    if (versionToUse != null) {
                        this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "requestedVersionChange", (Object)true);
                        this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "newResolvedVersion", (Object)versionToUse);
                    }
                    if (requestedScope != existingScope) {
                        this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "requestedScopeChange", (Object)true);
                        this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "oldScope", (Object)existingScope);
                    }
                }
                return tag;
            }
        }
        return super.visitTag(tag, executionContext);
    }

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext executionContext) {
        Xml.Tag root;
        Validated versionValidation = Semver.validate((String)this.version, (String)this.versionPattern);
        if (versionValidation.isValid()) {
            this.versionComparator = (VersionComparator)versionValidation.getValue();
        }
        Xml.Document maven = super.visitDocument(document, executionContext);
        if (((Boolean)this.getCursor().getMessage("doNotAlterDependency", (Object)false)).booleanValue() || ((Boolean)this.getCursor().getMessage("existingDependencyFailure", (Object)false)).booleanValue()) {
            return document;
        }
        boolean requestedVersionChange = (Boolean)this.getCursor().getMessage("requestedVersionChange", (Object)false);
        Scope resolvedScope = Scope.fromName(this.scope);
        Map<Scope, List<ResolvedDependency>> dependencies = this.getResolutionResult().getDependencies();
        if (dependencies.containsKey((Object)resolvedScope)) {
            for (ResolvedDependency d : dependencies.get((Object)resolvedScope)) {
                if (!d.isDirect() || !this.groupId.equals(d.getGroupId()) || !this.artifactId.equals(d.getArtifactId())) continue;
                if (requestedVersionChange) {
                    this.checkVersionUpdate(d.getVersion());
                }
                return maven;
            }
        }
        if (!(root = maven.getRoot()).getChild("dependencies").isPresent()) {
            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(root, Xml.Tag.build((String)"<dependencies/>"), (Comparator)new MavenTagInsertionComparator(root.getContent() == null ? Collections.emptyList() : root.getContent())));
        }
        boolean isUpdating = false;
        if (((Boolean)this.getCursor().getMessage("requestedScopeChange", (Object)false)).booleanValue()) {
            isUpdating = true;
            Scope oldScope = (Scope)((Object)this.getCursor().getMessage("oldScope"));
            if (dependencies.containsKey((Object)oldScope)) {
                for (ResolvedDependency d : dependencies.get((Object)oldScope)) {
                    if (!d.isDirect() || !this.groupId.equals(d.getGroupId()) || !this.artifactId.equals(d.getArtifactId())) continue;
                    if (requestedVersionChange) {
                        this.checkVersionUpdate(d.getVersion());
                    }
                    this.doAfterVisit(new ChangeDependencyScope(this.groupId, this.artifactId, this.scope).getVisitor());
                    this.maybeUpdateModel();
                    break;
                }
            } else {
                ResolvedPom resolvedPom = this.getResolutionResult().getPom();
                for (Dependency d : resolvedPom.getRequestedDependencies()) {
                    if (!this.groupId.equals(resolvedPom.getValue(d.getGroupId())) || !this.artifactId.equals(resolvedPom.getValue(d.getArtifactId()))) continue;
                    this.doAfterVisit(new ChangeDependencyScope(this.groupId, this.artifactId, this.scope).getVisitor());
                    this.maybeUpdateModel();
                    if (!requestedVersionChange || d.getVersion() == null) break;
                    this.checkVersionUpdate(Objects.requireNonNull(resolvedPom.getValue(d.getVersion())));
                    this.maybeUpdateModel();
                    break;
                }
            }
        }
        if (!isUpdating) {
            this.doAfterVisit((TreeVisitor)new InsertDependencyInOrder(this.scope));
        }
        return maven;
    }

    private @Nullable String tryGetFamilyVersion() {
        if (this.familyRegex != null) {
            return this.findDependencies(d -> this.familyRegex.matcher(d.getGroupId()).matches()).stream().max(Comparator.comparing(d -> new Version(d.getVersion()))).map(d -> d.getRequested().getVersion()).orElse(null);
        }
        return null;
    }

    private void checkVersionUpdate(String existingVersion) {
        String newResolvedVersion = Objects.requireNonNull((String)this.getCursor().getMessage("newResolvedVersion"));
        if (!existingVersion.equals(this.getResolutionResult().getPom().getValue(newResolvedVersion))) {
            this.doAfterVisit(new UpgradeDependencyVersion(this.groupId, this.artifactId, newResolvedVersion, this.versionPattern, true, null).getVisitor());
        }
    }

    private String findVersionToUse(ExecutionContext ctx) throws MavenDownloadingException {
        if (this.resolvedVersion == null) {
            if (this.versionComparator == null || this.versionComparator instanceof ExactVersion) {
                this.resolvedVersion = this.version;
            } else {
                MavenMetadata mavenMetadata;
                MavenMetadata mavenMetadata2 = mavenMetadata = this.metadataFailures == null ? this.downloadMetadata(this.groupId, this.artifactId, ctx) : this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(this.groupId, this.artifactId, ctx));
                if ("LatestRelease".equals(this.versionComparator.getClass().getSimpleName()) && mavenMetadata.getVersioning().getRelease() != null) {
                    return mavenMetadata.getVersioning().getRelease();
                }
                LatestRelease latest = new LatestRelease(this.versionPattern);
                this.resolvedVersion = mavenMetadata.getVersioning().getVersions().stream().filter(v -> this.versionComparator.isValid(null, v)).filter(v -> !Boolean.TRUE.equals(this.releasesOnly) || latest.isValid(null, v)).max((v1, v2) -> this.versionComparator.compare(null, v1, v2)).orElse(this.version);
            }
        }
        return this.resolvedVersion;
    }

    @Generated
    public AddDependencyVisitor(String groupId, String artifactId, String version, @Nullable String versionPattern, @Nullable String scope, @Nullable Boolean releasesOnly, @Nullable String type, @Nullable String classifier, @Nullable Boolean optional, @Nullable Pattern familyRegex, @Nullable MavenMetadataFailures metadataFailures) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.scope = scope;
        this.releasesOnly = releasesOnly;
        this.type = type;
        this.classifier = classifier;
        this.optional = optional;
        this.familyRegex = familyRegex;
        this.metadataFailures = metadataFailures;
    }

    private class InsertDependencyInOrder
    extends MavenVisitor<ExecutionContext> {
        private final @Nullable String scope;

        public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (DEPENDENCIES_MATCHER.matches(this.getCursor())) {
                String versionToUse = null;
                String managedVersion = this.getResolutionResult().getPom().getManagedVersion(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId, AddDependencyVisitor.this.type, AddDependencyVisitor.this.classifier);
                boolean scheduleVersionUpgrade = false;
                if (managedVersion == null) {
                    versionToUse = AddDependencyVisitor.this.tryGetFamilyVersion();
                    if (versionToUse == null) {
                        try {
                            versionToUse = AddDependencyVisitor.this.findVersionToUse(ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (Xml)e.warn(tag);
                        }
                    }
                } else if (AddDependencyVisitor.this.versionComparator != null && !AddDependencyVisitor.this.versionComparator.isValid(AddDependencyVisitor.this.version, managedVersion)) {
                    scheduleVersionUpgrade = true;
                }
                Xml.Tag dependencyTag = Xml.Tag.build((String)("\n<dependency>\n<groupId>" + AddDependencyVisitor.this.groupId + "</groupId>\n<artifactId>" + AddDependencyVisitor.this.artifactId + "</artifactId>\n" + (versionToUse == null ? "" : "<version>" + versionToUse + "</version>\n") + (AddDependencyVisitor.this.classifier == null ? "" : "<classifier>" + AddDependencyVisitor.this.classifier + "</classifier>\n") + (AddDependencyVisitor.this.type == null || "jar".equals(AddDependencyVisitor.this.type) ? "" : "<type>" + AddDependencyVisitor.this.type + "</type>\n") + (this.scope == null || "compile".equals(this.scope) ? "" : "<scope>" + this.scope + "</scope>\n") + (Boolean.TRUE.equals(AddDependencyVisitor.this.optional) ? "<optional>true</optional>\n" : "") + "</dependency>"));
                this.doAfterVisit((TreeVisitor)new AddToTagVisitor(tag, dependencyTag, (Comparator)new InsertDependencyComparator(tag.getContent() == null ? Collections.emptyList() : tag.getContent(), dependencyTag)));
                this.maybeUpdateModel();
                if (scheduleVersionUpgrade) {
                    this.doAfterVisit(new UpgradeDependencyVersion(AddDependencyVisitor.this.groupId, AddDependencyVisitor.this.artifactId, AddDependencyVisitor.this.version, AddDependencyVisitor.this.versionPattern, true, null).getVisitor());
                }
                return tag;
            }
            return super.visitTag(tag, (Object)ctx);
        }

        @Generated
        public InsertDependencyInOrder(String scope) {
            this.scope = scope;
        }
    }
}

