/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class AddCommentToMavenDependency
extends Recipe {
    @Option(displayName="XPath", description="An XPath expression used to find matching tags.", example="/project/dependencies/dependency")
    private final String xPath;
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava")
    private final String artifactId;
    @Option(displayName="Comment text", description="The text to add as a comment..", example="This is excluded due to CVE <X> and will be removed when we upgrade the next version is available.")
    private final String commentText;
    private final String displayName = "Add a comment to a `Maven` dependency or plugin";
    private final String description = "Adds a comment as the first element in a `Maven` dependency or plugin.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final XPathMatcher matcher;
            {
                this.matcher = new XPathMatcher(AddCommentToMavenDependency.this.xPath);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                boolean containsComment;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.matcher.matches(this.getCursor()) && (this.isDependencyTag(AddCommentToMavenDependency.this.groupId, AddCommentToMavenDependency.this.artifactId) || this.isPluginTag(AddCommentToMavenDependency.this.groupId, AddCommentToMavenDependency.this.artifactId)) && tag.getContent() != null && !(containsComment = tag.getContent().stream().anyMatch(c -> c instanceof Xml.Comment && AddCommentToMavenDependency.this.commentText.equals(((Xml.Comment)c).getText())))) {
                    ArrayList<Xml.Comment> contents = new ArrayList<Xml.Comment>(tag.getContent());
                    Xml.Comment customComment = new Xml.Comment(Tree.randomId(), ((Content)contents.get(0)).getPrefix(), Markers.EMPTY, AddCommentToMavenDependency.this.commentText);
                    contents.add(0, customComment);
                    return t.withContent(contents);
                }
                return t;
            }
        };
    }

    @Generated
    public AddCommentToMavenDependency(String xPath, String groupId, String artifactId, String commentText) {
        this.xPath = xPath;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.commentText = commentText;
    }

    @Generated
    public String getXPath() {
        return this.xPath;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getCommentText() {
        return this.commentText;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddCommentToMavenDependency(xPath=" + this.getXPath() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", commentText=" + this.getCommentText() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCommentToMavenDependency)) {
            return false;
        }
        AddCommentToMavenDependency other = (AddCommentToMavenDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$xPath = this.getXPath();
        String other$xPath = other.getXPath();
        if (this$xPath == null ? other$xPath != null : !this$xPath.equals(other$xPath)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$commentText = this.getCommentText();
        String other$commentText = other.getCommentText();
        if (this$commentText == null ? other$commentText != null : !this$commentText.equals(other$commentText)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddCommentToMavenDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xPath = this.getXPath();
        result = result * 59 + ($xPath == null ? 43 : $xPath.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $commentText = this.getCommentText();
        result = result * 59 + ($commentText == null ? 43 : $commentText.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

