/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public class InsertDependencyComparator
implements Comparator<Content> {
    private final Map<Content, Float> positions = new LinkedHashMap<Content, Float>();
    private static final Comparator<Xml.Tag> dependencyComparator = (d1, d2) -> {
        String artifactId2;
        String groupId2;
        Scope scope2;
        Scope scope1 = Scope.fromName(d1.getChildValue("scope").orElse(null));
        if (scope1 != (scope2 = Scope.fromName(d2.getChildValue("scope").orElse(null)))) {
            return scope1.compareTo(scope2);
        }
        String groupId1 = d1.getChildValue("groupId").orElse("");
        if (!groupId1.equals(groupId2 = d2.getChildValue("groupId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(groupId1, groupId2);
        }
        String artifactId1 = d1.getChildValue("artifactId").orElse("");
        if (!artifactId1.equals(artifactId2 = d2.getChildValue("artifactId").orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(artifactId1, artifactId2);
        }
        String classifier1 = d1.getChildValue("classifier").orElse(null);
        String classifier2 = d2.getChildValue("classifier").orElse(null);
        if (classifier1 == null && classifier2 != null) {
            return -1;
        }
        if (classifier1 != null) {
            if (classifier2 == null) {
                return 1;
            }
            if (!classifier1.equals(classifier2)) {
                return classifier1.compareTo(classifier2);
            }
        }
        return d1.getChildValue("version").orElse("").compareTo(d2.getChildValue("version").orElse(""));
    };

    public InsertDependencyComparator(List<? extends Content> existingDependencies, Xml.Tag dependencyTag) {
        float f;
        int existingDependenciesSize = existingDependencies.size();
        for (int i = 0; i < existingDependenciesSize; ++i) {
            this.positions.put(existingDependencies.get(i), Float.valueOf(i));
        }
        List ideallySortedDependencies = existingDependencies.stream().filter(c -> c instanceof Xml.Tag).map(c -> (Xml.Tag)c).collect(Collectors.toList());
        ideallySortedDependencies.add(dependencyTag);
        ideallySortedDependencies.sort(dependencyComparator);
        Content afterDependency = null;
        for (int i = 0; i < ideallySortedDependencies.size(); ++i) {
            Content d = (Content)ideallySortedDependencies.get(i);
            if (dependencyTag != d) continue;
            if (i <= 0) break;
            afterDependency = (Content)ideallySortedDependencies.get(i - 1);
            break;
        }
        float insertPos = afterDependency == null ? -0.5f : 0.5f;
        ArrayList<Content> contents = new ArrayList<Content>(this.positions.keySet());
        float f2 = f = afterDependency == null ? 0.0f : this.positions.get(afterDependency).floatValue();
        while (f < (float)contents.size()) {
            if (contents.get((int)f) instanceof Xml.Tag) {
                this.positions.put((Content)dependencyTag, Float.valueOf(this.positions.get(contents.get((int)f)).floatValue() + insertPos));
                break;
            }
            f += 1.0f;
        }
    }

    @Override
    public int compare(Content o1, Content o2) {
        Float anotherFloat = this.positions.get(o2);
        return anotherFloat == null ? 0 : this.positions.get(o1).compareTo(anotherFloat);
    }

    private static int comparePartByPart(String d1, String d2) {
        String[] d1Parts = d1.split("[.-]");
        String[] d2Parts = d2.split("[.-]");
        for (int i = 0; i < Math.min(d1Parts.length, d2Parts.length); ++i) {
            if (d1Parts[i].equals(d2Parts[i])) continue;
            return d1Parts[i].compareTo(d2Parts[i]);
        }
        return d1Parts.length - d2Parts.length;
    }
}

