/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeManagedDependencyGroupIdAndArtifactId
extends Recipe {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    private static final Set<String> implicitlyDefinedVersionProperties = new HashSet<String>(Arrays.asList("${version}", "${project.version}", "${pom.version}", "${project.parent.version}"));
    @Option(displayName="Old groupId", description="The old groupId to replace. The groupId is the first part of a managed dependency coordinate `com.google.guava:guava:VERSION`.", example="org.openrewrite.recipe")
    private final String oldGroupId;
    @Option(displayName="Old artifactId", description="The old artifactId to replace. The artifactId is the second part of a managed dependency coordinate `com.google.guava:guava:VERSION`.", example="rewrite-testing-frameworks")
    private final String oldArtifactId;
    @Option(displayName="New groupId", description="The new groupId to use.", example="corp.internal.openrewrite.recipe")
    private final String newGroupId;
    @Option(displayName="New artifactId", description="The new artifactId to use.", example="rewrite-testing-frameworks")
    private final String newArtifactId;
    @Option(displayName="New version", description="The new version to use.", example="2.0.0", required=false)
    @Nullable
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public ChangeManagedDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId, @Nullable String newVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = null;
    }

    @JsonCreator
    public ChangeManagedDependencyGroupIdAndArtifactId(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId, @Nullable String newVersion, @Nullable String versionPattern) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        validated = validated.and(Validated.test((String)"coordinates", (String)"newGroupId OR newArtifactId must be different from before", (Object)((Object)this), r -> {
            boolean sameGroupId = StringUtils.isBlank((String)r.newGroupId) || Objects.equals(r.oldGroupId, r.newGroupId);
            boolean sameArtifactId = StringUtils.isBlank((String)r.newArtifactId) || Objects.equals(r.oldArtifactId, r.newArtifactId);
            return !sameGroupId || !sameArtifactId;
        }));
        return validated;
    }

    public String getDisplayName() {
        return "Change Maven managed dependency groupId, artifactId and optionally the version";
    }

    public String getDescription() {
        return "Change the groupId, artifactId and optionally the version of a specified Maven managed dependency.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            @Nullable
            final VersionComparator versionComparator;
            @Nullable
            private Collection<String> availableVersions;
            {
                this.versionComparator = ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion != null ? (VersionComparator)Semver.validate((String)ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion, (String)ChangeManagedDependencyGroupIdAndArtifactId.this.versionPattern).getValue() : null;
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isManagedDependencyTag(ChangeManagedDependencyGroupIdAndArtifactId.this.oldGroupId, ChangeManagedDependencyGroupIdAndArtifactId.this.oldArtifactId)) {
                    Optional artifactIdTag;
                    Optional groupIdTag = t.getChild("groupId");
                    boolean changed = false;
                    if (groupIdTag.isPresent() && !ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId.equals(((Xml.Tag)groupIdTag.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)groupIdTag.get(), ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId));
                        changed = true;
                    }
                    if ((artifactIdTag = t.getChild("artifactId")).isPresent() && !ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId.equals(((Xml.Tag)artifactIdTag.get()).getValue().orElse(null))) {
                        this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor((Xml.Tag)artifactIdTag.get(), ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId));
                        changed = true;
                    }
                    if (ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion != null) {
                        try {
                            Optional versionTag = t.getChild("version");
                            if (versionTag.isPresent()) {
                                String resolvedNewVersion = this.resolveSemverVersion(ctx, ChangeManagedDependencyGroupIdAndArtifactId.this.newGroupId, ChangeManagedDependencyGroupIdAndArtifactId.this.newArtifactId, ((Xml.Tag)versionTag.get()).getValue().orElse(null));
                                t = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)versionTag.get(), resolvedNewVersion).visitNonNull((Tree)t, (Object)0, this.getCursor().getParentOrThrow());
                            }
                            changed = true;
                        }
                        catch (MavenDownloadingException e) {
                            return e.warn(t);
                        }
                    }
                    if (changed) {
                        this.maybeUpdateModel();
                        this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, null, null).getVisitor());
                    }
                }
                return t;
            }

            private String resolveSemverVersion(ExecutionContext ctx, String groupId, String artifactId, @Nullable String currentVersion) throws MavenDownloadingException {
                String finalCurrentVersion;
                if (this.versionComparator == null) {
                    return ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion;
                }
                String string = finalCurrentVersion = currentVersion != null ? currentVersion : ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion;
                if (this.availableVersions == null) {
                    this.availableVersions = new ArrayList<String>();
                    MavenMetadata mavenMetadata = ChangeManagedDependencyGroupIdAndArtifactId.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    for (String v : mavenMetadata.getVersioning().getVersions()) {
                        if (!this.versionComparator.isValid(finalCurrentVersion, v)) continue;
                        this.availableVersions.add(v);
                    }
                }
                return this.availableVersions.isEmpty() ? ChangeManagedDependencyGroupIdAndArtifactId.this.newVersion : Collections.max(this.availableVersions, this.versionComparator);
            }
        };
    }

    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    public String getOldGroupId() {
        return this.oldGroupId;
    }

    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    public String getNewGroupId() {
        return this.newGroupId;
    }

    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Nullable
    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "ChangeManagedDependencyGroupIdAndArtifactId(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeManagedDependencyGroupIdAndArtifactId)) {
            return false;
        }
        ChangeManagedDependencyGroupIdAndArtifactId other = (ChangeManagedDependencyGroupIdAndArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeManagedDependencyGroupIdAndArtifactId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

