/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Objects;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class AddRepository
extends Recipe {
    private static final XPathMatcher REPOS_MATCHER = new XPathMatcher("/project/repositories");
    @Option(displayName="Repository ID", description="A unique name to describe the repository.")
    private final String id;
    @Option(displayName="Repository URL", description="The URL of the repository.")
    private final String url;
    @Option(required=false, displayName="Repository name", description="A display name for the repository.")
    @Nullable
    private final String repoName;
    @Option(required=false, displayName="Repository layout", description="The Maven layout of the repository.")
    @Nullable
    private final String layout;
    @Option(required=false, displayName="Enable snapshots", description="Snapshots from the repository are available.")
    @Nullable
    private final Boolean snapshotsEnabled;
    @Option(required=false, displayName="Snapshots checksum policy", description="Governs whether snapshots require checksums.")
    @Nullable
    private final String snapshotsChecksumPolicy;
    @Option(required=false, displayName="Snapshots update policy", description="The policy governing snapshot updating interval.")
    @Nullable
    private final String snapshotsUpdatePolicy;
    @Option(required=false, displayName="Releases enabled", description="Releases from the repository are available")
    @Nullable
    private final Boolean releasesEnabled;
    @Option(required=false, displayName="Releases checksum policy", description="Governs whether releases require checksums.")
    @Nullable
    private final String releasesChecksumPolicy;
    @Option(required=false, displayName="Releases update policy", description="The policy governing release updating interval.")
    @Nullable
    private final String releasesUpdatePolicy;

    public String getDisplayName() {
        return "Add repository";
    }

    public String getDescription() {
        return "Adds a new Maven Repository or updates a matching repository.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Tag root = document.getRoot();
                if (!root.getChild("repositories").isPresent()) {
                    document = (Xml.Document)new AddToTagVisitor(root, Xml.Tag.build((String)"<repositories/>")).visitNonNull((Tree)document, (Object)ctx, this.getCursor().getParentOrThrow());
                }
                return super.visitDocument(document, ctx);
            }

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag repositories = super.visitTag(tag, ctx);
                if (REPOS_MATCHER.matches(this.getCursor())) {
                    Optional<Xml.Tag> maybeRepo = repositories.getChildren().stream().filter(repo -> "repository".equals(repo.getName()) && (AddRepository.this.id.equals(repo.getChildValue("id").orElse(null)) || AddRepository.this.isReleasesEqual(repo) && AddRepository.this.isSnapshotsEqual(repo)) && AddRepository.this.url.equals(repo.getChildValue("url").orElse(null))).findAny();
                    if (maybeRepo.isPresent()) {
                        Xml.Tag repo2 = maybeRepo.get();
                        if (AddRepository.this.repoName != null && !Objects.equals(AddRepository.this.repoName, repo2.getChildValue("name").orElse(null))) {
                            repositories = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)repo2.getChild("name").get(), AddRepository.this.repoName).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                        }
                        if (AddRepository.this.repoName != null && AddRepository.this.layout != null && !Objects.equals(AddRepository.this.layout, repo2.getChildValue("layout").orElse(null))) {
                            repositories = (Xml.Tag)new ChangeTagValueVisitor((Xml.Tag)repo2.getChild("layout").get(), AddRepository.this.repoName).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                            this.maybeUpdateModel();
                        }
                        if (!AddRepository.this.isReleasesEqual(repo2)) {
                            Xml.Tag releases = repo2.getChild("releases").orElse(null);
                            if (releases == null) {
                                repositories = (Xml.Tag)new AddToTagVisitor(repo2, Xml.Tag.build((String)AddRepository.this.assembleReleases())).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                            } else {
                                repositories = (Xml.Tag)new RemoveContentVisitor((Content)releases, true).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                                if (!AddRepository.this.isNoSnapshots()) {
                                    repositories = (Xml.Tag)new AddToTagVisitor(repo2, Xml.Tag.build((String)AddRepository.this.assembleReleases())).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                                }
                            }
                            this.maybeUpdateModel();
                        }
                        if (!AddRepository.this.isSnapshotsEqual(repo2)) {
                            Xml.Tag snapshots = repo2.getChild("snapshots").orElse(null);
                            if (snapshots == null) {
                                repositories = (Xml.Tag)new AddToTagVisitor(repo2, Xml.Tag.build((String)AddRepository.this.assembleSnapshots())).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                            } else {
                                repositories = (Xml.Tag)new RemoveContentVisitor((Content)snapshots, true).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                                if (!AddRepository.this.isNoSnapshots()) {
                                    repositories = (Xml.Tag)new AddToTagVisitor(repo2, Xml.Tag.build((String)AddRepository.this.assembleSnapshots())).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                                }
                            }
                            this.maybeUpdateModel();
                        }
                    } else {
                        String sb = "<repository>\n" + AddRepository.this.assembleTagWithValue("id", AddRepository.this.id) + AddRepository.this.assembleTagWithValue("url", AddRepository.this.url) + AddRepository.this.assembleTagWithValue("name", AddRepository.this.repoName) + AddRepository.this.assembleTagWithValue("layout", AddRepository.this.layout) + AddRepository.this.assembleReleases() + AddRepository.this.assembleSnapshots() + "</repository>\n";
                        Xml.Tag repoTag = Xml.Tag.build((String)sb);
                        repositories = (Xml.Tag)new AddToTagVisitor(repositories, repoTag).visitNonNull((Tree)repositories, (Object)ctx, this.getCursor().getParentOrThrow());
                        this.maybeUpdateModel();
                    }
                }
                return repositories;
            }
        };
    }

    private String assembleTagWithValue(String tag, @Nullable String value) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            sb.append("<");
            sb.append(tag);
            sb.append(">");
            sb.append(value);
            sb.append("</");
            sb.append(tag);
            sb.append(">\n");
        }
        return sb.toString();
    }

    private String assembleReleases() {
        StringBuilder sb = new StringBuilder();
        if (this.releasesUpdatePolicy != null || this.releasesEnabled != null || this.releasesChecksumPolicy != null) {
            sb.append("<releases>");
            if (this.releasesEnabled != null) {
                sb.append(this.assembleTagWithValue("enabled", String.valueOf(this.releasesEnabled)));
            }
            if (this.releasesUpdatePolicy != null) {
                sb.append(this.assembleTagWithValue("updatePolicy", this.releasesUpdatePolicy));
            }
            if (this.releasesChecksumPolicy != null) {
                sb.append(this.assembleTagWithValue("checksumPolicy", this.releasesChecksumPolicy));
            }
            sb.append("</releases>\n");
        }
        return sb.toString();
    }

    private String assembleSnapshots() {
        StringBuilder sb = new StringBuilder();
        if (this.snapshotsEnabled != null || this.snapshotsChecksumPolicy != null || this.snapshotsUpdatePolicy != null) {
            sb.append("<snapshots>");
            if (this.snapshotsEnabled != null) {
                sb.append(this.assembleTagWithValue("enabled", String.valueOf(this.snapshotsEnabled)));
            }
            if (this.snapshotsUpdatePolicy != null) {
                sb.append(this.assembleTagWithValue("updatePolicy", this.snapshotsUpdatePolicy));
            }
            if (this.snapshotsChecksumPolicy != null) {
                sb.append(this.assembleTagWithValue("checksumPolicy", this.snapshotsChecksumPolicy));
            }
            sb.append("</snapshots>\n");
        }
        return sb.toString();
    }

    private boolean isReleasesEqual(Xml.Tag repo) {
        Xml.Tag releases = repo.getChild("releases").orElse(null);
        if (releases == null) {
            return this.isNoReleases();
        }
        return Objects.equals(this.releasesEnabled == null ? null : String.valueOf(this.releasesEnabled), releases.getChildValue("enabled").orElse(null)) && Objects.equals(this.releasesUpdatePolicy, releases.getChildValue("updatePolicy").orElse(null)) && Objects.equals(this.releasesChecksumPolicy, releases.getChildValue("checksumPolicy").orElse(null));
    }

    private boolean isNoReleases() {
        return this.releasesEnabled == null && this.releasesUpdatePolicy == null && this.releasesChecksumPolicy == null;
    }

    private boolean isSnapshotsEqual(Xml.Tag repo) {
        Xml.Tag snapshots = repo.getChild("snapshots").orElse(null);
        if (snapshots == null) {
            return this.isNoSnapshots();
        }
        return Objects.equals(this.snapshotsEnabled == null ? null : String.valueOf(this.snapshotsEnabled), snapshots.getChildValue("enabled").orElse(null)) && Objects.equals(this.snapshotsUpdatePolicy, snapshots.getChildValue("updatePolicy").orElse(null)) && Objects.equals(this.snapshotsChecksumPolicy, snapshots.getChildValue("checksumPolicy").orElse(null));
    }

    private boolean isNoSnapshots() {
        return this.snapshotsEnabled == null && this.snapshotsUpdatePolicy == null && this.snapshotsChecksumPolicy == null;
    }

    public AddRepository(String id, String url, @Nullable String repoName, @Nullable String layout, @Nullable Boolean snapshotsEnabled, @Nullable String snapshotsChecksumPolicy, @Nullable String snapshotsUpdatePolicy, @Nullable Boolean releasesEnabled, @Nullable String releasesChecksumPolicy, @Nullable String releasesUpdatePolicy) {
        this.id = id;
        this.url = url;
        this.repoName = repoName;
        this.layout = layout;
        this.snapshotsEnabled = snapshotsEnabled;
        this.snapshotsChecksumPolicy = snapshotsChecksumPolicy;
        this.snapshotsUpdatePolicy = snapshotsUpdatePolicy;
        this.releasesEnabled = releasesEnabled;
        this.releasesChecksumPolicy = releasesChecksumPolicy;
        this.releasesUpdatePolicy = releasesUpdatePolicy;
    }

    public String getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    @Nullable
    public String getRepoName() {
        return this.repoName;
    }

    @Nullable
    public String getLayout() {
        return this.layout;
    }

    @Nullable
    public Boolean getSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    @Nullable
    public String getSnapshotsChecksumPolicy() {
        return this.snapshotsChecksumPolicy;
    }

    @Nullable
    public String getSnapshotsUpdatePolicy() {
        return this.snapshotsUpdatePolicy;
    }

    @Nullable
    public Boolean getReleasesEnabled() {
        return this.releasesEnabled;
    }

    @Nullable
    public String getReleasesChecksumPolicy() {
        return this.releasesChecksumPolicy;
    }

    @Nullable
    public String getReleasesUpdatePolicy() {
        return this.releasesUpdatePolicy;
    }

    @NonNull
    public String toString() {
        return "AddRepository(id=" + this.getId() + ", url=" + this.getUrl() + ", repoName=" + this.getRepoName() + ", layout=" + this.getLayout() + ", snapshotsEnabled=" + this.getSnapshotsEnabled() + ", snapshotsChecksumPolicy=" + this.getSnapshotsChecksumPolicy() + ", snapshotsUpdatePolicy=" + this.getSnapshotsUpdatePolicy() + ", releasesEnabled=" + this.getReleasesEnabled() + ", releasesChecksumPolicy=" + this.getReleasesChecksumPolicy() + ", releasesUpdatePolicy=" + this.getReleasesUpdatePolicy() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddRepository)) {
            return false;
        }
        AddRepository other = (AddRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$snapshotsEnabled = this.getSnapshotsEnabled();
        Boolean other$snapshotsEnabled = other.getSnapshotsEnabled();
        if (this$snapshotsEnabled == null ? other$snapshotsEnabled != null : !((Object)this$snapshotsEnabled).equals(other$snapshotsEnabled)) {
            return false;
        }
        Boolean this$releasesEnabled = this.getReleasesEnabled();
        Boolean other$releasesEnabled = other.getReleasesEnabled();
        if (this$releasesEnabled == null ? other$releasesEnabled != null : !((Object)this$releasesEnabled).equals(other$releasesEnabled)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$repoName = this.getRepoName();
        String other$repoName = other.getRepoName();
        if (this$repoName == null ? other$repoName != null : !this$repoName.equals(other$repoName)) {
            return false;
        }
        String this$layout = this.getLayout();
        String other$layout = other.getLayout();
        if (this$layout == null ? other$layout != null : !this$layout.equals(other$layout)) {
            return false;
        }
        String this$snapshotsChecksumPolicy = this.getSnapshotsChecksumPolicy();
        String other$snapshotsChecksumPolicy = other.getSnapshotsChecksumPolicy();
        if (this$snapshotsChecksumPolicy == null ? other$snapshotsChecksumPolicy != null : !this$snapshotsChecksumPolicy.equals(other$snapshotsChecksumPolicy)) {
            return false;
        }
        String this$snapshotsUpdatePolicy = this.getSnapshotsUpdatePolicy();
        String other$snapshotsUpdatePolicy = other.getSnapshotsUpdatePolicy();
        if (this$snapshotsUpdatePolicy == null ? other$snapshotsUpdatePolicy != null : !this$snapshotsUpdatePolicy.equals(other$snapshotsUpdatePolicy)) {
            return false;
        }
        String this$releasesChecksumPolicy = this.getReleasesChecksumPolicy();
        String other$releasesChecksumPolicy = other.getReleasesChecksumPolicy();
        if (this$releasesChecksumPolicy == null ? other$releasesChecksumPolicy != null : !this$releasesChecksumPolicy.equals(other$releasesChecksumPolicy)) {
            return false;
        }
        String this$releasesUpdatePolicy = this.getReleasesUpdatePolicy();
        String other$releasesUpdatePolicy = other.getReleasesUpdatePolicy();
        return !(this$releasesUpdatePolicy == null ? other$releasesUpdatePolicy != null : !this$releasesUpdatePolicy.equals(other$releasesUpdatePolicy));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $snapshotsEnabled = this.getSnapshotsEnabled();
        result = result * 59 + ($snapshotsEnabled == null ? 43 : ((Object)$snapshotsEnabled).hashCode());
        Boolean $releasesEnabled = this.getReleasesEnabled();
        result = result * 59 + ($releasesEnabled == null ? 43 : ((Object)$releasesEnabled).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $repoName = this.getRepoName();
        result = result * 59 + ($repoName == null ? 43 : $repoName.hashCode());
        String $layout = this.getLayout();
        result = result * 59 + ($layout == null ? 43 : $layout.hashCode());
        String $snapshotsChecksumPolicy = this.getSnapshotsChecksumPolicy();
        result = result * 59 + ($snapshotsChecksumPolicy == null ? 43 : $snapshotsChecksumPolicy.hashCode());
        String $snapshotsUpdatePolicy = this.getSnapshotsUpdatePolicy();
        result = result * 59 + ($snapshotsUpdatePolicy == null ? 43 : $snapshotsUpdatePolicy.hashCode());
        String $releasesChecksumPolicy = this.getReleasesChecksumPolicy();
        result = result * 59 + ($releasesChecksumPolicy == null ? 43 : $releasesChecksumPolicy.hashCode());
        String $releasesUpdatePolicy = this.getReleasesUpdatePolicy();
        result = result * 59 + ($releasesUpdatePolicy == null ? 43 : $releasesUpdatePolicy.hashCode());
        return result;
    }
}

