/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.internal.KotlinPrinter;
import org.openrewrite.kotlin.marker.Semicolon;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.Marker;

public final class RemoveTrailingSemicolon
extends Recipe {
    private final String displayName = "Remove unnecessary trailing semicolon";
    private final String description = "Some Java programmers may mistakenly add semicolons at the end when writing Kotlin code, but in reality, they are not necessary.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinIsoVisitor<ExecutionContext>(){
            @Nullable Set<Marker> semiColonRemovable;

            @Override
            public K.CompilationUnit visitCompilationUnit(K.CompilationUnit cu, ExecutionContext ctx) {
                this.semiColonRemovable = CollectSemicolonRemovableElements.collect(cu);
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            @Override
            public <M extends Marker> @Nullable M visitMarker(Marker marker, ExecutionContext ctx) {
                return this.semiColonRemovable.remove(marker) ? null : (M)super.visitMarker(marker, ctx);
            }
        };
    }

    @Generated
    public RemoveTrailingSemicolon() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveTrailingSemicolon(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveTrailingSemicolon)) {
            return false;
        }
        RemoveTrailingSemicolon other = (RemoveTrailingSemicolon)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveTrailingSemicolon;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static final class CollectSemicolonRemovableElements
    extends KotlinPrinter<Set<Marker>> {
        private final Pattern WS = Pattern.compile("^\\s+");

        public static Set<Marker> collect(J j) {
            HashSet<Marker> removable = new HashSet<Marker>();
            new CollectSemicolonRemovableElements().visit((Tree)j, new PrintOutputCapture(removable));
            return removable;
        }

        @Override
        protected KotlinPrinter.KotlinJavaPrinter<Set<Marker>> delegate() {
            return new MyKotlinJavaPrinter(this);
        }

        @Generated
        public CollectSemicolonRemovableElements() {
        }

        @Generated
        public Pattern getWS() {
            return this.WS;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RemoveTrailingSemicolon.CollectSemicolonRemovableElements(WS=" + this.getWS() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CollectSemicolonRemovableElements)) {
                return false;
            }
            CollectSemicolonRemovableElements other = (CollectSemicolonRemovableElements)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            Pattern this$WS = this.getWS();
            Pattern other$WS = other.getWS();
            return !(this$WS == null ? other$WS != null : !this$WS.equals(other$WS));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof CollectSemicolonRemovableElements;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pattern $WS = this.getWS();
            result = result * 59 + ($WS == null ? 43 : $WS.hashCode());
            return result;
        }

        private class MyKotlinJavaPrinter
        extends KotlinPrinter.KotlinJavaPrinter<Set<Marker>> {
            private @Nullable Integer mark;
            private @Nullable Marker semicolonMarker;

            MyKotlinJavaPrinter(KotlinPrinter<Set<Marker>> kp) {
                super(kp);
            }

            @Override
            public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<Set<Marker>> p) {
                Object m = super.visitMarker(marker, p);
                if (marker instanceof Semicolon) {
                    this.mark(marker, p);
                }
                return m;
            }

            public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<Set<Marker>> p) {
                p.append(space.getWhitespace());
                this.checkMark(p);
                return space;
            }

            private void mark(Marker semicolonMarker, PrintOutputCapture<Set<Marker>> p) {
                this.mark = p.out.length();
                this.semicolonMarker = semicolonMarker;
            }

            private void checkMark(PrintOutputCapture<Set<Marker>> p) {
                if (this.mark != null) {
                    String substring = p.out.substring(this.mark);
                    Matcher matcher = CollectSemicolonRemovableElements.this.WS.matcher(substring);
                    if (matcher.find()) {
                        if (matcher.group().indexOf(10) != -1) {
                            ((Set)p.getContext()).add(this.semicolonMarker);
                        }
                        this.mark = null;
                    }
                }
            }
        }
    }
}

