/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.time.Duration;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinVisitor;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class RemoveLambdaArgumentParentheses
extends Recipe {
    final String displayName = "Remove method invocation parentheses around single lambda argument";
    final String description = "For example, convert `1.let({ it + 1 })` to `1.let { it + 1 }`.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation.Padding padding;
                JContainer arguments;
                Markers argumentsMarkers;
                if (method.getArguments().size() == 1 && method.getArguments().get(0) instanceof J.Lambda && !(argumentsMarkers = (arguments = (padding = method.getPadding()).getArguments()).getMarkers()).findFirst(OmitParentheses.class).isPresent()) {
                    return padding.withArguments(arguments.withMarkers(argumentsMarkers.add((Marker)new OmitParentheses(Tree.randomId()))).withBefore(Space.SINGLE_SPACE));
                }
                return method;
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }
}

