/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.tree.K;

public final class RenameTypeAlias
extends Recipe {
    @Option(displayName="Old alias name", description="Name of the alias type.", example="OldAlias")
    private final String aliasName;
    @Option(displayName="New alias name", description="Name of the alias type.", example="NewAlias")
    private final String newName;
    @Option(displayName="Target fully qualified type", description="Fully-qualified class name of the aliased type.", example="org.junit.Assume")
    private final String fullyQualifiedAliasedType;
    private final String displayName = "Rename type alias";
    private final String description = "Change the name of a given type alias.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinIsoVisitor<ExecutionContext>(){

            @Override
            public K.TypeAlias visitTypeAlias(K.TypeAlias typeAlias, ExecutionContext ctx) {
                if (!RenameTypeAlias.this.aliasName.equals(typeAlias.getSimpleName()) || !TypeUtils.isOfClassType((JavaType)typeAlias.getType(), (String)RenameTypeAlias.this.fullyQualifiedAliasedType)) {
                    return typeAlias;
                }
                return typeAlias.withName(typeAlias.getName().withSimpleName(RenameTypeAlias.this.newName));
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier i, ExecutionContext ctx) {
                if (!i.getSimpleName().equals(RenameTypeAlias.this.aliasName) || !TypeUtils.isOfClassType((JavaType)i.getType(), (String)RenameTypeAlias.this.fullyQualifiedAliasedType)) {
                    return i;
                }
                if (!RenameTypeAlias.this.isVariableName(this.getCursor().getParentTreeCursor(), i) || RenameTypeAlias.this.isAliasImport(this.getCursor().getParentTreeCursor(), i)) {
                    i = i.withSimpleName(RenameTypeAlias.this.newName);
                }
                return i;
            }
        };
    }

    private boolean isVariableName(Cursor cursor, J.Identifier ident) {
        Object value = cursor.getValue();
        if (value instanceof J.MethodInvocation) {
            J.MethodInvocation m = (J.MethodInvocation)value;
            return m.getName() != ident;
        }
        if (value instanceof J.NewClass) {
            J.NewClass m = (J.NewClass)value;
            return m.getClazz() != ident;
        }
        if (value instanceof J.NewArray) {
            J.NewArray a = (J.NewArray)value;
            return a.getTypeExpression() != ident;
        }
        if (value instanceof J.VariableDeclarations) {
            J.VariableDeclarations v = (J.VariableDeclarations)value;
            return ident != v.getTypeExpression();
        }
        if (value instanceof J.VariableDeclarations.NamedVariable) {
            Object maybeVd = cursor.getParentTreeCursor().getValue();
            if (maybeVd instanceof J.VariableDeclarations) {
                J.VariableDeclarations vd = (J.VariableDeclarations)maybeVd;
                return vd.getModifiers().stream().noneMatch(x -> x.getType() == J.Modifier.Type.LanguageExtension && "typealias".equals(x.getKeyword()));
            }
            return true;
        }
        return !(value instanceof J.ParameterizedType);
    }

    private boolean isAliasImport(Cursor cursor, J.Identifier id) {
        if (cursor.getValue() instanceof J.Import) {
            J.Import ji = (J.Import)cursor.getValue();
            return ji.getAlias() == id;
        }
        return false;
    }

    @Generated
    public RenameTypeAlias(String aliasName, String newName, String fullyQualifiedAliasedType) {
        this.aliasName = aliasName;
        this.newName = newName;
        this.fullyQualifiedAliasedType = fullyQualifiedAliasedType;
    }

    @Generated
    public String getAliasName() {
        return this.aliasName;
    }

    @Generated
    public String getNewName() {
        return this.newName;
    }

    @Generated
    public String getFullyQualifiedAliasedType() {
        return this.fullyQualifiedAliasedType;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RenameTypeAlias(aliasName=" + this.getAliasName() + ", newName=" + this.getNewName() + ", fullyQualifiedAliasedType=" + this.getFullyQualifiedAliasedType() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RenameTypeAlias)) {
            return false;
        }
        RenameTypeAlias other = (RenameTypeAlias)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$aliasName = this.getAliasName();
        String other$aliasName = other.getAliasName();
        if (this$aliasName == null ? other$aliasName != null : !this$aliasName.equals(other$aliasName)) {
            return false;
        }
        String this$newName = this.getNewName();
        String other$newName = other.getNewName();
        if (this$newName == null ? other$newName != null : !this$newName.equals(other$newName)) {
            return false;
        }
        String this$fullyQualifiedAliasedType = this.getFullyQualifiedAliasedType();
        String other$fullyQualifiedAliasedType = other.getFullyQualifiedAliasedType();
        if (this$fullyQualifiedAliasedType == null ? other$fullyQualifiedAliasedType != null : !this$fullyQualifiedAliasedType.equals(other$fullyQualifiedAliasedType)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RenameTypeAlias;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $aliasName = this.getAliasName();
        result = result * 59 + ($aliasName == null ? 43 : $aliasName.hashCode());
        String $newName = this.getNewName();
        result = result * 59 + ($newName == null ? 43 : $newName.hashCode());
        String $fullyQualifiedAliasedType = this.getFullyQualifiedAliasedType();
        result = result * 59 + ($fullyQualifiedAliasedType == null ? 43 : $fullyQualifiedAliasedType.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

