/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin;

import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.kotlin.KotlinIsoVisitor;
import org.openrewrite.kotlin.KotlinParser;
import org.openrewrite.kotlin.internal.KotlinParsingException;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

public final class Assertions {
    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
        if (ctx.getMessage("org.openrewrite.kotlin.skipSourceSetTypeGeneration") == null) {
            ctx.putMessage("org.openrewrite.kotlin.skipSourceSetTypeGeneration", (Object)true);
        }
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before) {
        return Assertions.kotlin(before, (SourceSpec<K.CompilationUnit> s) -> {});
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlin = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder(), before, SourceSpec.EachResult.noop, Assertions::customizeExecutionContext);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlin);
        return kotlin;
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, @Language(value="kotlin") String after) {
        return Assertions.kotlin(before, after, s -> {});
    }

    public static SourceSpecs kotlin(@Nullable @Language(value="kotlin") String before, @Language(value="kotlin") String after, Consumer<SourceSpec<K.CompilationUnit>> spec) {
        SourceSpec kotlin = new SourceSpec(K.CompilationUnit.class, null, (Parser.Builder)KotlinParser.builder(), before, SourceSpec.EachResult.noop, Assertions::customizeExecutionContext).after(s -> after);
        Assertions.acceptSpec(spec, (SourceSpec<K.CompilationUnit>)kotlin);
        return kotlin;
    }

    public static SourceSpecs srcMainKotlin(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... kotlinSources) {
        return SourceSpecs.dir((String)"src/main/kotlin", spec, (SourceSpecs[])kotlinSources);
    }

    public static SourceSpecs srcMainKotlin(SourceSpecs ... kotlinSources) {
        return Assertions.srcMainKotlin((SourceSpec<SourceFile> spec) -> org.openrewrite.java.Assertions.sourceSet((SourceSpec)spec, (String)"main"), kotlinSources);
    }

    public static SourceSpecs srcTestKotlin(Consumer<SourceSpec<SourceFile>> spec, SourceSpecs ... kotlinSources) {
        return SourceSpecs.dir((String)"src/test/kotlin", spec, (SourceSpecs[])kotlinSources);
    }

    public static SourceSpecs srcTestKotlin(SourceSpecs ... kotlinSources) {
        return Assertions.srcTestKotlin((SourceSpec<SourceFile> spec) -> org.openrewrite.java.Assertions.sourceSet((SourceSpec)spec, (String)"test"), kotlinSources);
    }

    private static void acceptSpec(Consumer<SourceSpec<K.CompilationUnit>> spec, SourceSpec<K.CompilationUnit> kotlin) {
        ThrowingConsumer userSuppliedAfterRecipe = kotlin.getAfterRecipe();
        kotlin.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        Assertions.isFullyParsed().andThen(spec).accept(kotlin);
    }

    public static Consumer<SourceSpec<K.CompilationUnit>> isFullyParsed() {
        return spec -> spec.afterRecipe(cu -> {
            new KotlinIsoVisitor<Integer>(){

                public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                    if (!space.getWhitespace().trim().isEmpty()) {
                        throw new KotlinParsingException("Parsing error detected, whitespace contains non-whitespace characters: " + space.getWhitespace(), new RuntimeException());
                    }
                    return super.visitSpace(space, loc, (Object)integer);
                }
            }.visit((Tree)cu, 0);
            new KotlinIsoVisitor<Integer>(){

                @Nullable
                public J preVisit(J tree, Integer integer) {
                    if (tree instanceof J.Unknown) {
                        throw new KotlinParsingException("Parsing error detected. J.UnknownElement with text: " + ((J.Unknown)tree).getSource().getText(), new RuntimeException());
                    }
                    return (J)super.preVisit((Tree)tree, (Object)integer);
                }
            }.visit((Tree)cu, 0);
        });
    }
}

