/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.search;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonKey;
import org.openrewrite.marker.SearchResult;

public final class FindKey
extends Recipe {
    @Option(displayName="Key path", description="A JsonPath expression used to find matching keys.", example="$.subjects.kind")
    private final String key;
    private final String displayName = "Find JSON object members";
    private final String description = "Find JSON object members by JsonPath expression.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.key);
        return new JsonIsoVisitor<ExecutionContext>(){

            @Override
            public Json.Member visitMember(Json.Member member, ExecutionContext ctx) {
                Json m = super.visitMember(member, ctx);
                if (matcher.matches(this.getCursor())) {
                    return ((Json.Member)m).withKey((JsonKey)SearchResult.found((Tree)((Json.Member)m).getKey()));
                }
                return m;
            }
        };
    }

    public static Set<JsonKey> find(Json j, String key) {
        final JsonPathMatcher matcher = new JsonPathMatcher(key);
        HashSet<JsonKey> ks = new HashSet<JsonKey>();
        new JsonIsoVisitor<Set<JsonKey>>(){

            @Override
            public Json.Member visitMember(Json.Member member, Set<JsonKey> ks) {
                Json m = super.visitMember(member, ks);
                if (matcher.matches(this.getCursor())) {
                    ks.add(((Json.Member)m).getKey());
                }
                return m;
            }
        }.visit(j, ks);
        return ks;
    }

    @Generated
    public FindKey(String key) {
        this.key = key;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindKey(key=" + this.getKey() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindKey)) {
            return false;
        }
        FindKey other = (FindKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

