/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.Space;

public final class DeleteKey
extends Recipe {
    @Option(displayName="Key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression to locate a JSON entry.", example="$.subjects.kind")
    private final String keyPath;
    private final String displayName = "Delete key";
    private final String description = "Delete a JSON mapping entry key.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.keyPath);
        return new JsonIsoVisitor<ExecutionContext>(){

            @Override
            public Json.JsonObject visitObject(Json.JsonObject obj, ExecutionContext ctx) {
                Json o = super.visitObject(obj, ctx);
                AtomicReference copyFirstPrefix = new AtomicReference();
                if (!((Json.JsonObject)(o = ((Json.JsonObject)o).withMembers(ListUtils.map(((Json.JsonObject)o).getMembers(), (i, e) -> {
                    if (matcher.matches(new Cursor(this.getCursor(), e))) {
                        if (i == 0 && this.getCursor().getParentOrThrow().getValue() instanceof Json.Array) {
                            copyFirstPrefix.set(e.getPrefix());
                        }
                        return null;
                    }
                    return e;
                })))).getMembers().isEmpty() && copyFirstPrefix.get() != null) {
                    o = ((Json.JsonObject)o).withMembers(ListUtils.mapFirst(((Json.JsonObject)o).getMembers(), e -> e.withPrefix((Space)copyFirstPrefix.get())));
                }
                return o;
            }
        };
    }

    @Generated
    public DeleteKey(String keyPath) {
        this.keyPath = keyPath;
    }

    @Generated
    public String getKeyPath() {
        return this.keyPath;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteKey(keyPath=" + this.getKeyPath() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteKey)) {
            return false;
        }
        DeleteKey other = (DeleteKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$keyPath = this.getKeyPath();
        String other$keyPath = other.getKeyPath();
        if (this$keyPath == null ? other$keyPath != null : !this$keyPath.equals(other$keyPath)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DeleteKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyPath = this.getKeyPath();
        result = result * 59 + ($keyPath == null ? 43 : $keyPath.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

