/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.json.JsonIsoVisitor;
import org.openrewrite.json.JsonPathMatcher;
import org.openrewrite.json.tree.Json;

public final class ChangeKey
extends Recipe {
    @Option(displayName="Old key path", description="A [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expression to locate a JSON entry.", example="$.subjects.kind")
    private final String oldKeyPath;
    @Option(displayName="New key", description="The new name for the key selected by oldKeyPath.", example="kind")
    private final String newKey;
    private final String displayName = "Change key";
    private final String description = "Change a JSON mapping entry key, while leaving the value intact.";

    public String getInstanceNameSuffix() {
        return String.format("`%s` to `%s`", this.oldKeyPath, this.newKey);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final JsonPathMatcher matcher = new JsonPathMatcher(this.oldKeyPath);
        return new JsonIsoVisitor<ExecutionContext>(){

            @Override
            public Json.Member visitMember(Json.Member member, ExecutionContext ctx) {
                Json m = super.visitMember(member, ctx);
                if (matcher.matches(this.getCursor())) {
                    String value = ChangeKey.this.newKey;
                    if (value.startsWith("'") || value.startsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    m = ((Json.Member)m).withKey(((Json.Member)m).getKey() instanceof Json.Literal ? ((Json.Literal)((Json.Member)m).getKey()).withSource(ChangeKey.this.newKey).withValue(value) : new Json.Literal(Tree.randomId(), ((Json.Member)m).getKey().getPrefix(), ((Json.Member)m).getKey().getMarkers(), ChangeKey.this.newKey, value));
                }
                return m;
            }
        };
    }

    @Generated
    public ChangeKey(String oldKeyPath, String newKey) {
        this.oldKeyPath = oldKeyPath;
        this.newKey = newKey;
    }

    @Generated
    public String getOldKeyPath() {
        return this.oldKeyPath;
    }

    @Generated
    public String getNewKey() {
        return this.newKey;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeKey(oldKeyPath=" + this.getOldKeyPath() + ", newKey=" + this.getNewKey() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeKey)) {
            return false;
        }
        ChangeKey other = (ChangeKey)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldKeyPath = this.getOldKeyPath();
        String other$oldKeyPath = other.getOldKeyPath();
        if (this$oldKeyPath == null ? other$oldKeyPath != null : !this$oldKeyPath.equals(other$oldKeyPath)) {
            return false;
        }
        String this$newKey = this.getNewKey();
        String other$newKey = other.getNewKey();
        if (this$newKey == null ? other$newKey != null : !this$newKey.equals(other$newKey)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldKeyPath = this.getOldKeyPath();
        result = result * 59 + ($oldKeyPath == null ? 43 : $oldKeyPath.hashCode());
        String $newKey = this.getNewKey();
        result = result * 59 + ($newKey == null ? 43 : $newKey.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

