/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.coding;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.tools.checkstyle.FileStatefulCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.api.FullIdent;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

@FileStatefulCheck
public class IllegalInstantiationCheck
extends AbstractCheck {
    public static final String MSG_KEY = "instantiation.avoid";
    private static final String JAVA_LANG = "java.lang.";
    private final Set<FullIdent> imports = new HashSet<FullIdent>();
    private final Set<String> classNames = new HashSet<String>();
    private final Set<DetailAST> instantiations = new HashSet<DetailAST>();
    private Set<String> classes = new HashSet<String>();
    private String pkgName;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 136, 16, 14};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{30, 136, 16};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.pkgName = null;
        this.imports.clear();
        this.instantiations.clear();
        this.classNames.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 136: {
                this.processLiteralNew(ast);
                break;
            }
            case 16: {
                this.processPackageDef(ast);
                break;
            }
            case 30: {
                this.processImport(ast);
                break;
            }
            case 14: {
                this.processClassDef(ast);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + ast);
            }
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        this.instantiations.forEach(this::postProcessLiteralNew);
    }

    private void processClassDef(DetailAST ast) {
        DetailAST identToken = ast.findFirstToken(58);
        String className = identToken.getText();
        this.classNames.add(className);
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        this.imports.add(name);
    }

    private void processPackageDef(DetailAST ast) {
        DetailAST packageNameAST = ast.getLastChild().getPreviousSibling();
        FullIdent packageIdent = FullIdent.createFullIdent(packageNameAST);
        this.pkgName = packageIdent.getText();
    }

    private void processLiteralNew(DetailAST ast) {
        if (ast.getParent().getType() != 180) {
            this.instantiations.add(ast);
        }
    }

    private void postProcessLiteralNew(DetailAST newTokenAst) {
        FullIdent typeIdent;
        String typeName;
        String fqClassName;
        DetailAST typeNameAst = newTokenAst.getFirstChild();
        DetailAST nameSibling = typeNameAst.getNextSibling();
        if (nameSibling.getType() != 17 && (fqClassName = this.getIllegalInstantiation(typeName = (typeIdent = FullIdent.createFullIdent(typeNameAst)).getText())) != null) {
            this.log(newTokenAst, MSG_KEY, fqClassName);
        }
    }

    private String getIllegalInstantiation(String className) {
        String fullClassName = null;
        if (this.classes.contains(className)) {
            fullClassName = className;
        } else {
            String illegal;
            int pkgNameLen = this.pkgName == null ? 0 : this.pkgName.length();
            Iterator<String> iterator = this.classes.iterator();
            while (iterator.hasNext() && (fullClassName = this.isSamePackage(className, pkgNameLen, illegal = iterator.next()) || this.isStandardClass(className, illegal) ? illegal : this.checkImportStatements(className)) == null) {
            }
        }
        return fullClassName;
    }

    private String checkImportStatements(String className) {
        String illegalType = null;
        for (FullIdent importLineText : this.imports) {
            String importArg = importLineText.getText();
            if (importArg.endsWith(".*")) {
                importArg = importArg.substring(0, importArg.length() - 1) + className;
            }
            if (!CommonUtil.baseClassName(importArg).equals(className) || !this.classes.contains(importArg)) continue;
            illegalType = importArg;
            break;
        }
        return illegalType;
    }

    private boolean isSamePackage(String className, int pkgNameLen, String illegal) {
        return this.pkgName != null && className.length() == illegal.length() - pkgNameLen - 1 && illegal.charAt(pkgNameLen) == '.' && illegal.endsWith(className) && illegal.startsWith(this.pkgName);
    }

    private boolean isStandardClass(String className, String illegal) {
        boolean isSameFile;
        boolean isStandardClass = false;
        if (illegal.length() - JAVA_LANG.length() == className.length() && illegal.endsWith(className) && illegal.startsWith(JAVA_LANG) && !(isSameFile = this.classNames.contains(className))) {
            isStandardClass = true;
        }
        return isStandardClass;
    }

    public void setClasses(String ... names) {
        this.classes = Arrays.stream(names).collect(Collectors.toSet());
    }
}

