/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.tools.checkstyle.checks.blocks;

import java.util.Locale;
import org.openrewrite.tools.checkstyle.StatelessCheck;
import org.openrewrite.tools.checkstyle.api.AbstractCheck;
import org.openrewrite.tools.checkstyle.api.DetailAST;
import org.openrewrite.tools.checkstyle.checks.blocks.BlockOption;
import org.openrewrite.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class EmptyBlockCheck
extends AbstractCheck {
    public static final String MSG_KEY_BLOCK_NO_STATEMENT = "block.noStatement";
    public static final String MSG_KEY_BLOCK_EMPTY = "block.empty";
    private BlockOption option = BlockOption.STATEMENT;

    public void setOption(String optionStr) {
        this.option = BlockOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{84, 95, 97, 85, 83, 92, 91, 11, 12, 89, 67};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{84, 95, 96, 97, 85, 83, 92, 91, 11, 12, 89, 67, 93, 94, 29};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST leftCurly = EmptyBlockCheck.findLeftCurly(ast);
        if (leftCurly != null) {
            if (this.option == BlockOption.STATEMENT) {
                boolean emptyBlock;
                if (leftCurly.getType() == 72) {
                    DetailAST nextSibling = leftCurly.getNextSibling();
                    emptyBlock = nextSibling.getType() != 33 && nextSibling.getType() != 208;
                } else {
                    boolean bl = emptyBlock = leftCurly.getChildCount() <= 1;
                }
                if (emptyBlock) {
                    this.log(leftCurly, MSG_KEY_BLOCK_NO_STATEMENT, ast.getText());
                }
            } else if (!this.hasText(leftCurly)) {
                this.log(leftCurly, MSG_KEY_BLOCK_EMPTY, ast.getText());
            }
        }
    }

    private boolean hasText(DetailAST slistAST) {
        DetailAST rightCurly = slistAST.findFirstToken(73);
        DetailAST rcurlyAST = rightCurly == null ? slistAST.getParent().findFirstToken(73) : rightCurly;
        int slistLineNo = slistAST.getLineNo();
        int slistColNo = slistAST.getColumnNo();
        int rcurlyLineNo = rcurlyAST.getLineNo();
        int rcurlyColNo = rcurlyAST.getColumnNo();
        String[] lines = this.getLines();
        boolean returnValue = false;
        if (slistLineNo == rcurlyLineNo) {
            String txt = lines[slistLineNo - 1].substring(slistColNo + 1, rcurlyColNo);
            if (!CommonUtil.isBlank(txt)) {
                returnValue = true;
            }
        } else {
            String firstLine = lines[slistLineNo - 1].substring(slistColNo + 1);
            String lastLine = lines[rcurlyLineNo - 1].substring(0, rcurlyColNo);
            returnValue = !CommonUtil.isBlank(firstLine) || !CommonUtil.isBlank(lastLine) || !EmptyBlockCheck.checkIsAllLinesAreWhitespace(lines, slistLineNo, rcurlyLineNo);
        }
        return returnValue;
    }

    private static boolean checkIsAllLinesAreWhitespace(String[] lines, int lineFrom, int lineTo) {
        boolean result = true;
        for (int i = lineFrom; i < lineTo - 1; ++i) {
            if (CommonUtil.isBlank(lines[i])) continue;
            result = false;
            break;
        }
        return result;
    }

    private static DetailAST findLeftCurly(DetailAST ast) {
        DetailAST slistAST = ast.findFirstToken(7);
        DetailAST leftCurly = (ast.getType() == 93 || ast.getType() == 94) && ast.getNextSibling() != null && ast.getNextSibling().getFirstChild() != null && ast.getNextSibling().getFirstChild().getType() == 7 ? ast.getNextSibling().getFirstChild() : (slistAST == null ? ast.findFirstToken(72) : slistAST);
        return leftCurly;
    }
}

