/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.TypeMappings;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypedTree;

public final class FindTypeMappings
extends ScanningRecipe<Map<TypeAssociation, Integer>> {
    private final transient TypeMappings typeMappingsPerSource = new TypeMappings((Recipe)this);
    private final String displayName = "Find type mappings";
    private final String description = "Study the frequency of `J` types and their `JavaType` type attribution.";

    public Map<TypeAssociation, Integer> getInitialValue(ExecutionContext ctx) {
        return new HashMap<TypeAssociation, Integer>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<TypeAssociation, Integer> acc) {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public @Nullable JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
                Cursor cursor = this.getCursor();
                acc.compute(new TypeAssociation(((JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class)).getClass(), cursor.getValue().getClass(), javaType == null ? null : javaType.getClass(), javaType == null ? (Class)cursor.getPathAsStream().filter(t -> t instanceof TypedTree && ((TypedTree)t).getType() != null).findFirst().map(Object::getClass).orElse(null) : null), (k, v) -> v == null ? 1 : v + 1);
                return javaType;
            }
        };
    }

    public Collection<? extends SourceFile> generate(Map<TypeAssociation, Integer> acc, ExecutionContext ctx) {
        acc.forEach((assoc, count) -> {
            String j = assoc.getJ().getName();
            Class<?> nearJ = assoc.getNearestNonNullJ();
            this.typeMappingsPerSource.insertRow(ctx, new TypeMappings.Row(assoc.getCompilationUnit().getEnclosingClass().getSimpleName(), j.substring(j.lastIndexOf(46) + 1), assoc.getJavaType() == null ? "null" : assoc.getJavaType().getSimpleName(), (Integer)count, nearJ == null ? null : nearJ.getName().substring(nearJ.getName().lastIndexOf(46) + 1)));
        });
        return Collections.emptyList();
    }

    @Generated
    public FindTypeMappings() {
    }

    @Generated
    public TypeMappings getTypeMappingsPerSource() {
        return this.typeMappingsPerSource;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindTypeMappings(typeMappingsPerSource=" + (Object)((Object)this.getTypeMappingsPerSource()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypeMappings)) {
            return false;
        }
        FindTypeMappings other = (FindTypeMappings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindTypeMappings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static final class TypeAssociation {
        private final Class<? extends JavaSourceFile> compilationUnit;
        private final Class<?> j;
        private final @Nullable Class<? extends JavaType> javaType;
        private final @Nullable Class<?> nearestNonNullJ;

        @Generated
        public TypeAssociation(Class<? extends JavaSourceFile> compilationUnit, Class<?> j, @Nullable Class<? extends JavaType> javaType, @Nullable Class<?> nearestNonNullJ) {
            this.compilationUnit = compilationUnit;
            this.j = j;
            this.javaType = javaType;
            this.nearestNonNullJ = nearestNonNullJ;
        }

        @Generated
        public Class<? extends JavaSourceFile> getCompilationUnit() {
            return this.compilationUnit;
        }

        @Generated
        public Class<?> getJ() {
            return this.j;
        }

        @Generated
        public @Nullable Class<? extends JavaType> getJavaType() {
            return this.javaType;
        }

        @Generated
        public @Nullable Class<?> getNearestNonNullJ() {
            return this.nearestNonNullJ;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeAssociation)) {
                return false;
            }
            TypeAssociation other = (TypeAssociation)o;
            Class<? extends JavaSourceFile> this$compilationUnit = this.getCompilationUnit();
            Class<? extends JavaSourceFile> other$compilationUnit = other.getCompilationUnit();
            if (this$compilationUnit == null ? other$compilationUnit != null : !this$compilationUnit.equals(other$compilationUnit)) {
                return false;
            }
            Class<?> this$j = this.getJ();
            Class<?> other$j = other.getJ();
            if (this$j == null ? other$j != null : !this$j.equals(other$j)) {
                return false;
            }
            Class<? extends JavaType> this$javaType = this.getJavaType();
            Class<? extends JavaType> other$javaType = other.getJavaType();
            if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
                return false;
            }
            Class<?> this$nearestNonNullJ = this.getNearestNonNullJ();
            Class<?> other$nearestNonNullJ = other.getNearestNonNullJ();
            return !(this$nearestNonNullJ == null ? other$nearestNonNullJ != null : !this$nearestNonNullJ.equals(other$nearestNonNullJ));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<? extends JavaSourceFile> $compilationUnit = this.getCompilationUnit();
            result = result * 59 + ($compilationUnit == null ? 43 : $compilationUnit.hashCode());
            Class<?> $j = this.getJ();
            result = result * 59 + ($j == null ? 43 : $j.hashCode());
            Class<? extends JavaType> $javaType = this.getJavaType();
            result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
            Class<?> $nearestNonNullJ = this.getNearestNonNullJ();
            result = result * 59 + ($nearestNonNullJ == null ? 43 : $nearestNonNullJ.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "FindTypeMappings.TypeAssociation(compilationUnit=" + this.getCompilationUnit() + ", j=" + this.getJ() + ", javaType=" + this.getJavaType() + ", nearestNonNullJ=" + this.getNearestNonNullJ() + ")";
        }
    }
}

