/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;

public class FindReferencedTypes {
    private FindReferencedTypes() {
    }

    public static Set<JavaType.FullyQualified> find(J j) {
        HashSet<JavaType.FullyQualified> fields = new HashSet<JavaType.FullyQualified>();
        new FindReferencedTypesVisitor().visit(j, fields);
        return fields;
    }

    private static class FindReferencedTypesVisitor
    extends JavaIsoVisitor<Set<JavaType.FullyQualified>> {
        private FindReferencedTypesVisitor() {
        }

        @Override
        public <N extends NameTree> N visitTypeName(N name, Set<JavaType.FullyQualified> ctx) {
            JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified(name.getType());
            if (fullyQualified != null) {
                ctx.add(fullyQualified);
            }
            return super.visitTypeName(name, ctx);
        }
    }
}

