/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.JavadocVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindMissingTypes
extends Recipe {
    @Option(displayName="Check documentation", description="When set to `true` any references in documentation (i.e. Javadoc for Java) will also be checked. Default is `false`.", required=false)
    private final boolean checkDocumentation;
    private final String displayName = "Find missing type information on Java LSTs";
    private final String description = "This is a diagnostic recipe to highlight where LSTs are missing type attribution information.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FindMissingTypesVisitor(this.checkDocumentation);
    }

    public static List<MissingTypeResult> findMissingTypes(J j, boolean checkDocumentation) {
        J j1 = (J)new FindMissingTypesVisitor(checkDocumentation).visit(j, new InMemoryExecutionContext());
        ArrayList<MissingTypeResult> results = new ArrayList<MissingTypeResult>();
        if (j1 != j) {
            new JavaIsoVisitor<List<MissingTypeResult>>(){

                public <M extends Marker> M visitMarker(Marker marker, List<MissingTypeResult> missingTypeResults) {
                    if (marker instanceof SearchResult) {
                        String message = ((SearchResult)marker).getDescription();
                        String path = this.getCursor().getPathAsStream(j -> j instanceof J || j instanceof Javadoc).map(t -> t.getClass().getSimpleName()).collect(Collectors.joining("->"));
                        J j2 = (J)this.getCursor().firstEnclosing(J.class);
                        if (j2 != null) {
                            String printedTree = this.getCursor().firstEnclosing(JavaSourceFile.class) != null ? j2.printTrimmed(new InMemoryExecutionContext(), this.getCursor().getParentOrThrow()) : String.valueOf(j2);
                            missingTypeResults.add(new MissingTypeResult(message, path, printedTree, j2));
                        }
                    }
                    return (M)super.visitMarker(marker, missingTypeResults);
                }
            }.visit(j1, results);
        }
        return results;
    }

    @Generated
    public FindMissingTypes(boolean checkDocumentation) {
        this.checkDocumentation = checkDocumentation;
    }

    @Generated
    public boolean isCheckDocumentation() {
        return this.checkDocumentation;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindMissingTypes(checkDocumentation=" + this.isCheckDocumentation() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindMissingTypes)) {
            return false;
        }
        FindMissingTypes other = (FindMissingTypes)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isCheckDocumentation() != other.isCheckDocumentation()) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindMissingTypes;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckDocumentation() ? 79 : 97);
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    static final class FindMissingTypesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final boolean checkDocumentation;
        private final Set<JavaType> seenTypes = new HashSet<JavaType>();

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            if (!TypeUtils.isWellFormedType(identifier.getType(), this.seenTypes) && !this.isAllowedToHaveNullType(identifier)) {
                identifier = (J.Identifier)SearchResult.found((Tree)identifier, (String)"Identifier type is missing or malformed");
            }
            if (identifier.getFieldType() != null && !identifier.getSimpleName().equals(identifier.getFieldType().getName())) {
                identifier = (J.Identifier)SearchResult.found((Tree)identifier, (String)("type information has a different variable name '" + identifier.getFieldType().getName() + "'"));
            }
            return identifier;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J v = super.visitVariable(variable, ctx);
            if (v == variable) {
                JavaType.Variable variableType = ((J.VariableDeclarations.NamedVariable)v).getVariableType();
                if (!TypeUtils.isWellFormedType(variableType, this.seenTypes) && !this.isAllowedToHaveUnknownType()) {
                    v = (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)v, (String)"Variable type is missing or malformed");
                } else if (variableType != null && !variableType.getName().equals(((J.VariableDeclarations.NamedVariable)v).getSimpleName())) {
                    v = (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)v, (String)("type information has a different variable name '" + variableType.getName() + "'"));
                }
            }
            return v;
        }

        private boolean isAllowedToHaveUnknownType() {
            Cursor parent;
            for (parent = this.getCursor().getParent(); parent != null && parent.getParent() != null && !(parent.getParentTreeCursor().getValue() instanceof J.ClassDeclaration); parent = parent.getParentTreeCursor()) {
            }
            return parent != null && parent.getValue() instanceof J.Block;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J mi = super.visitMethodInvocation(method, ctx);
            if (mi == method) {
                JavaType.Method type = ((J.MethodInvocation)mi).getMethodType();
                if (!TypeUtils.isWellFormedType(type, this.seenTypes)) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"MethodInvocation type is missing or malformed");
                } else if (!type.getName().equals(((J.MethodInvocation)mi).getSimpleName()) && !type.isConstructor()) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)("type information has a different method name '" + type.getName() + "'"));
                }
                if (((J.MethodInvocation)mi).getName().getType() != null && type != null && type != ((J.MethodInvocation)mi).getName().getType()) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"MethodInvocation#name#type is not the same instance as the MethodType of MethodInvocation.");
                }
                if (type != null) {
                    int minCount;
                    int argCount = 0;
                    for (Expression argument : ((J.MethodInvocation)mi).getArguments()) {
                        if (argument instanceof J.Empty) continue;
                        ++argCount;
                    }
                    int n = minCount = type.hasFlags(Flag.Varargs) ? type.getParameterTypes().size() - 1 : type.getParameterTypes().size();
                    if (argCount < minCount) {
                        mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)("argument count mismatch: " + argCount + " != " + type.getParameterTypes().size()));
                    }
                }
            }
            return mi;
        }

        @Override
        public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
            J mr = super.visitMemberReference(memberRef, ctx);
            if (((J.MemberReference)mr).getMethodType() != null) {
                JavaType.Method methodType = ((J.MemberReference)mr).getMethodType();
                if (!TypeUtils.isWellFormedType(methodType, this.seenTypes)) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)"MemberReference type is missing or malformed");
                } else if (!methodType.getName().equals(((J.MemberReference)mr).getReference().getSimpleName()) && !methodType.isConstructor()) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)("type information has a different method name '" + methodType.getName() + "'"));
                }
            } else if (((J.MemberReference)mr).getVariableType() != null) {
                JavaType.Variable variableType = ((J.MemberReference)mr).getVariableType();
                if (!TypeUtils.isWellFormedType(variableType, this.seenTypes)) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)"MemberReference type is missing or malformed");
                } else if (!variableType.getName().equals(((J.MemberReference)mr).getReference().getSimpleName())) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)("type information has a different variable name '" + variableType.getName() + "'"));
                }
            } else if (((J.MemberReference)mr).getType() != null) {
                JavaType type = ((J.MemberReference)mr).getType();
                if (type instanceof JavaType.Parameterized) {
                    JavaType.Parameterized parameterizedType = (JavaType.Parameterized)type;
                    for (JavaType t : parameterizedType.getTypeParameters()) {
                        if (TypeUtils.isWellFormedType(t, this.seenTypes)) continue;
                        mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)"MemberReference Parameterized type is missing or malformed");
                    }
                } else if (type instanceof JavaType.Unknown) {
                    mr = (J.MemberReference)SearchResult.found((Tree)mr, (String)"MemberReference type is missing or malformed");
                }
            }
            return mr;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration md = method;
            JavaType.Method type = md.getMethodType();
            if (!TypeUtils.isWellFormedType(type, this.seenTypes)) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)"MethodDeclaration type is missing or malformed");
            } else if (!md.getSimpleName().equals(type.getName()) && !type.isConstructor()) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)("type information has a different method name '" + type.getName() + "'"));
            }
            if (md.getName().getType() != null && type != null && type != md.getName().getType()) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)"MethodDeclaration#name#type is not the same instance as the MethodType of MethodDeclaration.");
            }
            return super.visitMethodDeclaration(md, ctx);
        }

        @Override
        public J.Package visitPackage(J.Package pkg, ExecutionContext ctx) {
            J.Package p = pkg.withAnnotations(ListUtils.map(pkg.getAnnotations(), a -> TypeUtils.isWellFormedType(a.getType(), this.seenTypes) ? a : (J.Annotation)SearchResult.found((Tree)a, (String)"Annotation type is missing or malformed")));
            return p == pkg ? super.visitPackage(pkg, ctx) : p;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.Package pkg;
            J.CompilationUnit jc;
            J cd = super.visitClassDeclaration(classDecl, ctx);
            JavaType.FullyQualified t = ((J.ClassDeclaration)cd).getType();
            if (!TypeUtils.isWellFormedType(t, this.seenTypes)) {
                return (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)"ClassDeclaration type is missing or malformed");
            }
            if (!((J.ClassDeclaration)cd).getKind().name().equals(t.getKind().name())) {
                cd = (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)(" J.ClassDeclaration kind " + (Object)((Object)((J.ClassDeclaration)cd).getKind()) + " does not match the kind in its type information " + (Object)((Object)t.getKind())));
            }
            if ((jc = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class)) != null && (pkg = jc.getPackageDeclaration()) != null && t.getPackageName().equals(pkg.printTrimmed(this.getCursor()))) {
                cd = (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)(" J.ClassDeclaration package " + pkg + " does not match the package in its type information " + pkg.printTrimmed(this.getCursor())));
            }
            return cd;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J n = super.visitNewClass(newClass, ctx);
            if (n == newClass && !TypeUtils.isWellFormedType(((J.NewClass)n).getType(), this.seenTypes)) {
                n = (J.NewClass)SearchResult.found((Tree)n, (String)"NewClass type is missing or malformed");
            }
            if (((J.NewClass)n).getClazz() instanceof J.Identifier && ((J.NewClass)n).getClazz().getType() != null && !(((J.NewClass)n).getClazz().getType() instanceof JavaType.Class) && !(((J.NewClass)n).getClazz().getType() instanceof JavaType.Unknown)) {
                n = (J.NewClass)SearchResult.found((Tree)n, (String)"NewClass#clazz is J.Identifier and the type is is not JavaType$Class.");
            }
            return n;
        }

        @Override
        public J.ParameterizedType visitParameterizedType(J.ParameterizedType type, ExecutionContext ctx) {
            J p = super.visitParameterizedType(type, ctx);
            if (((J.ParameterizedType)p).getClazz() instanceof J.Identifier && ((J.ParameterizedType)p).getClazz().getType() != null && !(((J.ParameterizedType)p).getClazz().getType() instanceof JavaType.Class) && !(((J.ParameterizedType)p).getClazz().getType() instanceof JavaType.Unknown)) {
                p = (J.ParameterizedType)SearchResult.found((Tree)p, (String)"ParameterizedType#clazz is J.Identifier and the type is is not JavaType$Class.");
            }
            return p;
        }

        @Override
        protected JavadocVisitor<ExecutionContext> getJavadocVisitor() {
            return new JavadocVisitor<ExecutionContext>((JavaVisitor)this){

                public @Nullable Javadoc visit(@Nullable Tree tree, ExecutionContext ctx) {
                    return checkDocumentation ? (Javadoc)super.visit(tree, (Object)ctx) : (Javadoc)tree;
                }
            };
        }

        private boolean isAllowedToHaveNullType(J.Identifier ident) {
            return this.inPackageDeclaration() || this.inImport() || this.isClassName() || this.isMethodName() || this.isMethodInvocationName() || this.isFieldAccess(ident) || this.isBeingDeclared(ident) || this.isParameterizedType(ident) || this.isNewClass(ident) || this.isTypeParameter() || this.isMemberReference(ident) || this.isCaseLabel() || this.isLabel() || this.isAnnotationField(ident) || this.isInJavaDoc(ident);
        }

        private boolean inPackageDeclaration() {
            return this.getCursor().firstEnclosing(J.Package.class) != null;
        }

        private boolean inImport() {
            return this.getCursor().firstEnclosing(J.Import.class) != null;
        }

        private boolean isClassName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.ClassDeclaration;
        }

        private boolean isMethodName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.MethodDeclaration;
        }

        private boolean isMethodInvocationName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.MethodInvocation;
        }

        private boolean isFieldAccess(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.FieldAccess && (ident == ((J.FieldAccess)value).getName() || ident == ((J.FieldAccess)value).getTarget() && !"class".equals(((J.FieldAccess)value).getSimpleName()));
        }

        private boolean isBeingDeclared(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.VariableDeclarations.NamedVariable && ident == ((J.VariableDeclarations.NamedVariable)value).getName();
        }

        private boolean isParameterizedType(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.ParameterizedType && ident == ((J.ParameterizedType)value).getClazz();
        }

        private boolean isNewClass(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.NewClass && ident == ((J.NewClass)value).getClazz();
        }

        private boolean isTypeParameter() {
            return this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.TypeParameter;
        }

        private boolean isMemberReference(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.MemberReference && ident == ((J.MemberReference)value).getReference();
        }

        private boolean isInJavaDoc(J.Identifier ident) {
            Tree value = (Tree)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof Javadoc.Reference && ident == ((Javadoc.Reference)value).getTree();
        }

        private boolean isCaseLabel() {
            return this.getCursor().getParentTreeCursor().getValue() instanceof J.Case;
        }

        private boolean isLabel() {
            return this.getCursor().firstEnclosing(J.Label.class) != null;
        }

        private boolean isAnnotationField(J.Identifier ident) {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.Assignment && ident == ((J.Assignment)parent.getValue()).getVariable() && this.getCursor().firstEnclosing(J.Annotation.class) != null;
        }

        @Generated
        public FindMissingTypesVisitor(boolean checkDocumentation) {
            this.checkDocumentation = checkDocumentation;
        }

        @Generated
        public boolean isCheckDocumentation() {
            return this.checkDocumentation;
        }

        @Generated
        public Set<JavaType> getSeenTypes() {
            return this.seenTypes;
        }

        @NonNull
        @Generated
        public String toString() {
            return "FindMissingTypes.FindMissingTypesVisitor(checkDocumentation=" + this.isCheckDocumentation() + ", seenTypes=" + this.getSeenTypes() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FindMissingTypesVisitor)) {
                return false;
            }
            FindMissingTypesVisitor other = (FindMissingTypesVisitor)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (this.isCheckDocumentation() != other.isCheckDocumentation()) {
                return false;
            }
            Set<JavaType> this$seenTypes = this.getSeenTypes();
            Set<JavaType> other$seenTypes = other.getSeenTypes();
            return !(this$seenTypes == null ? other$seenTypes != null : !((Object)this$seenTypes).equals(other$seenTypes));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof FindMissingTypesVisitor;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCheckDocumentation() ? 79 : 97);
            Set<JavaType> $seenTypes = this.getSeenTypes();
            result = result * 59 + ($seenTypes == null ? 43 : ((Object)$seenTypes).hashCode());
            return result;
        }
    }

    public static class MissingTypeResult {
        @Nullable String message;
        String path;
        String printedTree;
        J j;

        @Generated
        public @Nullable String getMessage() {
            return this.message;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public String getPrintedTree() {
            return this.printedTree;
        }

        @Generated
        public J getJ() {
            return this.j;
        }

        @Generated
        public MissingTypeResult(@Nullable String message, String path, String printedTree, J j) {
            this.message = message;
            this.path = path;
            this.printedTree = printedTree;
            this.j = j;
        }
    }
}

