/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public final class FindLiterals
extends Recipe {
    @Option(displayName="Pattern", description="A regular expression pattern to match literals against.", example="file://")
    private final String pattern;
    private final String displayName = "Find literals";
    private final String description = "Find literals matching a pattern.";

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"pattern", (String)"Must be a valid regular expression", (Object)this.pattern, p -> {
            try {
                Pattern.compile(p);
                return true;
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final Pattern compiledPattern = Pattern.compile(this.pattern);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                if (literal.getValueSource() != null) {
                    if (literal.getValue() != null && compiledPattern.matcher(literal.getValue().toString()).matches()) {
                        return (J.Literal)SearchResult.found((Tree)literal);
                    }
                    if (literal.getType() != JavaType.Primitive.String && compiledPattern.matcher(literal.getValueSource()).matches()) {
                        return (J.Literal)SearchResult.found((Tree)literal);
                    }
                }
                return literal;
            }
        };
    }

    @Generated
    public FindLiterals(String pattern) {
        this.pattern = pattern;
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindLiterals(pattern=" + this.getPattern() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindLiterals)) {
            return false;
        }
        FindLiterals other = (FindLiterals)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindLiterals;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

