/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindImplementations
extends Recipe {
    @Option(displayName="Type name", description="The fully qualified name to search for.", example="org.openrewrite.Recipe")
    private final String typeName;
    private final String displayName = "Find implementing classes";
    private final String description = "Find class declarations which implement the specified type. If the specified type is a class, its subclasses will be matched. If the specified type is an interface, classes which implement it will be matched.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                if (TypeUtils.isAssignableTo(FindImplementations.this.typeName, (JavaType)((J.ClassDeclaration)cd).getType()) && !TypeUtils.isOfClassType(((J.ClassDeclaration)cd).getType(), FindImplementations.this.typeName)) {
                    cd = (J.ClassDeclaration)SearchResult.found((Tree)cd);
                }
                return cd;
            }
        };
    }

    @Generated
    public FindImplementations(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindImplementations(typeName=" + this.getTypeName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindImplementations)) {
            return false;
        }
        FindImplementations other = (FindImplementations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindImplementations;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

