/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindEmptyMethods
extends Recipe {
    @Option(displayName="Match on overrides", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    private final @Nullable Boolean matchOverrides;
    private final String displayName = "Find methods with empty bodies";
    private final String description = "Find methods with empty bodies and single public no arg constructors.";
    private final Set<String> tags = Collections.singleton("RSPEC-S1186");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (classDecl.hasModifier(J.Modifier.Type.Abstract)) {
                    return classDecl;
                }
                if (this.hasSinglePublicNoArgsConstructor(classDecl.getBody().getStatements())) {
                    this.getCursor().putMessage("CHECK_CONSTRUCTOR", (Object)true);
                }
                return super.visitClassDeclaration(classDecl, ctx);
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                Boolean checkConstructor = null;
                if (method.isConstructor()) {
                    checkConstructor = this.getCursor().getNearestMessage("CHECK_CONSTRUCTOR") != null;
                }
                if (checkConstructor != null && checkConstructor.booleanValue() || this.isEmptyMethod(method)) {
                    method = (J.MethodDeclaration)SearchResult.found((Tree)method);
                }
                return super.visitMethodDeclaration(method, ctx);
            }

            private boolean isEmptyMethod(J.MethodDeclaration method) {
                return !method.isConstructor() && !this.isInterfaceMethod(method) && (FindEmptyMethods.this.matchOverrides == null || FindEmptyMethods.this.matchOverrides == false && !TypeUtils.isOverride(method.getMethodType()) || FindEmptyMethods.this.matchOverrides != false) && (method.getBody() == null || method.getBody().getStatements().isEmpty() && method.getBody().getEnd().getComments().isEmpty());
            }

            private boolean isInterfaceMethod(J.MethodDeclaration method) {
                return method.getMethodType() != null && method.getMethodType().getDeclaringType() != null && method.getMethodType().getDeclaringType().getKind() == JavaType.FullyQualified.Kind.Interface && !method.hasModifier(J.Modifier.Type.Default);
            }

            private boolean hasSinglePublicNoArgsConstructor(List<Statement> classStatements) {
                List constructors = classStatements.stream().filter(o -> o instanceof J.MethodDeclaration).map(o -> (J.MethodDeclaration)o).filter(J.MethodDeclaration::isConstructor).collect(Collectors.toList());
                return constructors.size() == 1 && ((J.MethodDeclaration)constructors.get(0)).hasModifier(J.Modifier.Type.Public) && ((J.MethodDeclaration)constructors.get(0)).getParameters().size() == 1 && ((J.MethodDeclaration)constructors.get(0)).getParameters().get(0) instanceof J.Empty;
            }
        };
    }

    @Generated
    public FindEmptyMethods(@Nullable Boolean matchOverrides) {
        this.matchOverrides = matchOverrides;
    }

    @Generated
    public @Nullable Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindEmptyMethods(matchOverrides=" + this.getMatchOverrides() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindEmptyMethods)) {
            return false;
        }
        FindEmptyMethods other = (FindEmptyMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindEmptyMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }
}

