/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Iterator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindDeprecatedClasses
extends Recipe {
    private static final AnnotationMatcher DEPRECATED_MATCHER = new AnnotationMatcher("@java.lang.Deprecated");
    @Option(displayName="Type pattern", description="A type pattern that is used to find matching classes.", example="org.springframework..*", required=false)
    private final @Nullable String typePattern;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    private final @Nullable Boolean matchInherited;
    @Option(displayName="Ignore deprecated scopes", description="When a deprecated type is used in a deprecated method or class, ignore it.", required=false)
    private final @Nullable Boolean ignoreDeprecatedScopes;
    private final String displayName = "Find uses of deprecated classes";
    private final String description = "Find uses of deprecated classes, optionally ignoring those classes that are inside deprecated scopes.";

    public String getInstanceNameSuffix() {
        if (this.typePattern != null) {
            return "matching `" + this.typePattern + "`";
        }
        return super.getInstanceNameSuffix();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final TypeMatcher typeMatcher = this.typePattern == null ? null : new TypeMatcher(this.typePattern, Boolean.TRUE.equals(this.matchInherited));
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                for (JavaType javaType : cu.getTypesInUse().getTypesInUse()) {
                    JavaType.FullyQualified fqn = TypeUtils.asFullyQualified(javaType);
                    if (fqn == null || typeMatcher != null && !typeMatcher.matches(fqn)) continue;
                    for (JavaType.FullyQualified annotation : fqn.getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        return (J.CompilationUnit)SearchResult.found((Tree)cu);
                    }
                }
                return cu;
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public <N extends NameTree> N visitTypeName(N nameTree, ExecutionContext ctx) {
                JavaType.FullyQualified fqn;
                if (this.getCursor().firstEnclosing(J.Import.class) == null && (fqn = TypeUtils.asFullyQualified(nameTree.getType())) != null && (typeMatcher == null || typeMatcher.matches(fqn))) {
                    for (JavaType.FullyQualified annotation : fqn.getAnnotations()) {
                        if (!TypeUtils.isOfClassType(annotation, "java.lang.Deprecated")) continue;
                        if (Boolean.TRUE.equals(FindDeprecatedClasses.this.ignoreDeprecatedScopes)) {
                            Iterator cursorPath = this.getCursor().getPathAsCursors();
                            while (cursorPath.hasNext()) {
                                Cursor ancestor = (Cursor)cursorPath.next();
                                if (ancestor.getValue() instanceof J.MethodDeclaration && this.isDeprecated(ancestor)) {
                                    return nameTree;
                                }
                                if (!(ancestor.getValue() instanceof J.ClassDeclaration) || !this.isDeprecated(ancestor)) continue;
                                return nameTree;
                            }
                        }
                        return (N)((NameTree)SearchResult.found(nameTree));
                    }
                }
                return nameTree;
            }

            private boolean isDeprecated(Cursor cursor) {
                return this.service(AnnotationService.class).matches(cursor, DEPRECATED_MATCHER);
            }
        });
    }

    @Generated
    public FindDeprecatedClasses(@Nullable String typePattern, @Nullable Boolean matchInherited, @Nullable Boolean ignoreDeprecatedScopes) {
        this.typePattern = typePattern;
        this.matchInherited = matchInherited;
        this.ignoreDeprecatedScopes = ignoreDeprecatedScopes;
    }

    @Generated
    public @Nullable String getTypePattern() {
        return this.typePattern;
    }

    @Generated
    public @Nullable Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @Generated
    public @Nullable Boolean getIgnoreDeprecatedScopes() {
        return this.ignoreDeprecatedScopes;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindDeprecatedClasses(typePattern=" + this.getTypePattern() + ", matchInherited=" + this.getMatchInherited() + ", ignoreDeprecatedScopes=" + this.getIgnoreDeprecatedScopes() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindDeprecatedClasses)) {
            return false;
        }
        FindDeprecatedClasses other = (FindDeprecatedClasses)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        Boolean this$ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        Boolean other$ignoreDeprecatedScopes = other.getIgnoreDeprecatedScopes();
        if (this$ignoreDeprecatedScopes == null ? other$ignoreDeprecatedScopes != null : !((Object)this$ignoreDeprecatedScopes).equals(other$ignoreDeprecatedScopes)) {
            return false;
        }
        String this$typePattern = this.getTypePattern();
        String other$typePattern = other.getTypePattern();
        if (this$typePattern == null ? other$typePattern != null : !this$typePattern.equals(other$typePattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindDeprecatedClasses;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        Boolean $ignoreDeprecatedScopes = this.getIgnoreDeprecatedScopes();
        result = result * 59 + ($ignoreDeprecatedScopes == null ? 43 : ((Object)$ignoreDeprecatedScopes).hashCode());
        String $typePattern = this.getTypePattern();
        result = result * 59 + ($typePattern == null ? 43 : $typePattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

