/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.ClassHierarchy;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class FindClassHierarchy
extends Recipe {
    private final transient ClassHierarchy classHierarchy = new ClassHierarchy(this);
    private final String displayName = "Find class hierarchy";
    private final String description = "Discovers all class declarations within a project, recording which files they appear in, their superclasses, and interfaces. That information is then recorded in a data table.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                JavaType.FullyQualified type = ((J.ClassDeclaration)cd).getType();
                if (type == null) {
                    return cd;
                }
                FindClassHierarchy.this.classHierarchy.insertRow(ctx, new ClassHierarchy.Row(((SourceFile)this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), type.getFullyQualifiedName(), type.getSupertype() == null ? null : type.getSupertype().getFullyQualifiedName(), type.getInterfaces().isEmpty() ? null : type.getInterfaces().stream().map(JavaType.FullyQualified::getFullyQualifiedName).collect(Collectors.joining(","))));
                return cd;
            }
        };
    }

    @Generated
    public FindClassHierarchy() {
    }

    @Generated
    public ClassHierarchy getClassHierarchy() {
        return this.classHierarchy;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindClassHierarchy(classHierarchy=" + (Object)((Object)this.getClassHierarchy()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindClassHierarchy)) {
            return false;
        }
        FindClassHierarchy other = (FindClassHierarchy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindClassHierarchy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

