/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class WrappingAndBraces
extends Recipe {
    final String displayName = "Wrapping and braces";
    final String description = "Format line wraps and braces in Java code.";
    final Set<String> tags = new LinkedHashSet<String>(Arrays.asList("RSPEC-S121", "RSPEC-S2681", "RSPEC-S3972", "RSPEC-S3973"));
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(10L);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new WrappingAndBracesCompilationUnitStyle();
    }

    public static <J2 extends J> J2 formatWrappingAndBraces(J j, Cursor cursor) {
        JavaSourceFile sourceFile = (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        return (J2)((J)new WrappingAndBracesVisitor(sourceFile, null).visitNonNull(j, 0, cursor));
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    private static class WrappingAndBracesCompilationUnitStyle
    extends JavaIsoVisitor<ExecutionContext> {
        private WrappingAndBracesCompilationUnitStyle() {
        }

        public J visit(@Nullable Tree tree, ExecutionContext ctx) {
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                return new WrappingAndBracesVisitor(cu, null).visit((Tree)cu, ctx);
            }
            return (J)tree;
        }
    }
}

