/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import lombok.Generated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.service.SourcePositionService;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.style.LineWrapSetting;

public final class WrapMethodDeclarationParameters<P>
extends JavaIsoVisitor<P> {
    private final WrappingAndBracesStyle style;

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P ctx) {
        J m = super.visitMethodDeclaration(method, (Object)ctx);
        try {
            if (this.style != null && this.style.getMethodDeclarationParameters() != null && this.style.getMethodDeclarationParameters().getWrap() != LineWrapSetting.DoNotWrap) {
                if (((J.MethodDeclaration)m).getParameters().size() <= 1) {
                    return m;
                }
                JavaSourceFile sourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                if (this.style.getMethodDeclarationParameters().getWrap() == LineWrapSetting.ChopIfTooLong) {
                    if (sourceFile == null) {
                        return m;
                    }
                    if (((SourcePositionService)sourceFile.service(SourcePositionService.class)).positionOf(this.getCursor(), method.getPadding().getParameters()).getMaxColumn() <= this.style.getHardWrapAt()) {
                        return m;
                    }
                }
                if (this.style.getMethodDeclarationParameters().getCloseNewLine().booleanValue()) {
                    m = ((J.MethodDeclaration)m).getPadding().withParameters(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().withElements(ListUtils.mapLast(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().getElements(), rightPaddedParam -> {
                        Space after = rightPaddedParam.getAfter();
                        if (after.getLastWhitespace().contains("\n")) {
                            return rightPaddedParam;
                        }
                        after = after.getComments().isEmpty() ? after.withWhitespace("\n") : after.withComments(ListUtils.mapLast(after.getComments(), comment -> comment.withSuffix("\n")));
                        return rightPaddedParam.withAfter(after);
                    })));
                }
                m = ((J.MethodDeclaration)m).withParameters(ListUtils.map(((J.MethodDeclaration)m).getParameters(), (paramIndex, param) -> {
                    if (param instanceof J.Empty) {
                        return param;
                    }
                    Space prefix = param.getPrefix();
                    if (prefix.getComments().isEmpty()) {
                        if ((paramIndex != 0 || this.style.getMethodDeclarationParameters().getOpenNewLine().booleanValue()) && !prefix.getWhitespace().contains("\n")) {
                            prefix = prefix.withWhitespace("\n");
                        }
                    } else {
                        int index = -1;
                        for (int i = prefix.getComments().size() - 1; i >= 0; --i) {
                            if (!prefix.getComments().get(i).getSuffix().contains("\n")) continue;
                            index = i;
                            break;
                        }
                        if (index == -1 && (paramIndex != 0 || this.style.getMethodDeclarationParameters().getOpenNewLine().booleanValue())) {
                            if (prefix.getComments().isEmpty()) {
                                if (!prefix.getWhitespace().contains("\n")) {
                                    prefix = prefix.withWhitespace("\n");
                                }
                            } else {
                                prefix = prefix.withComments(ListUtils.mapLast(prefix.getComments(), comment -> comment.withSuffix("\n")));
                            }
                        }
                    }
                    return (Statement)param.withPrefix(prefix);
                }));
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        return m;
    }

    @Generated
    public WrapMethodDeclarationParameters(WrappingAndBracesStyle style) {
        this.style = style;
    }

    @Generated
    public WrappingAndBracesStyle getStyle() {
        return this.style;
    }

    @NonNull
    @Generated
    public String toString() {
        return "WrapMethodDeclarationParameters(style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrapMethodDeclarationParameters)) {
            return false;
        }
        WrapMethodDeclarationParameters other = (WrapMethodDeclarationParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        WrappingAndBracesStyle this$style = this.getStyle();
        WrappingAndBracesStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof WrapMethodDeclarationParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WrappingAndBracesStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }
}

