/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.ai;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.TokenCount;
import org.openrewrite.java.tree.J;

public final class ClassDefinitionLength
extends Recipe {
    private final transient TokenCount tokens = new TokenCount(this);
    private final String displayName = "Calculate token length of classes";
    private final String description = "Locates class definitions and predicts the number of token in each.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration clazz, ExecutionContext ctx) {
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (cd == null) {
                    return cd;
                }
                int numberOfTokens = (int)((double)cd.printTrimmed(this.getCursor()).length() / 3.5);
                ClassDefinitionLength.this.tokens.insertRow(ctx, new TokenCount.Row(cd.getSimpleName(), numberOfTokens));
                return cd;
            }
        };
    }

    @Generated
    public ClassDefinitionLength() {
    }

    @Generated
    public TokenCount getTokens() {
        return this.tokens;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ClassDefinitionLength(tokens=" + (Object)((Object)this.getTokens()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDefinitionLength)) {
            return false;
        }
        ClassDefinitionLength other = (ClassDefinitionLength)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClassDefinitionLength;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

