/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class RemoveImplements
extends Recipe {
    private static final AnnotationMatcher OVERRIDE_MATCHER = new AnnotationMatcher("java.lang.Override");
    private final String displayName = "Remove interface implementations";
    private final String description = "Removes `implements` clauses from classes implementing the specified interface. Removes `@Overrides` annotations from methods which no longer override anything.";
    @Option(displayName="Interface type", description="The fully qualified name of the interface to remove.", example="java.io.Serializable")
    private final String interfaceType;
    @Option(displayName="Filter", description="Only apply the interface removal to classes with fully qualified names that begin with this filter. `null` or empty matches all classes.", example="com.yourorg.", required=false)
    private final @Nullable String filter;

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
                if (!(classDeclaration.getType() instanceof JavaType.Class) || classDeclaration.getImplements() == null) {
                    return super.visitClassDeclaration(classDeclaration, ctx);
                }
                JavaType.Class cdt = (JavaType.Class)classDeclaration.getType();
                if ((RemoveImplements.this.filter == null || cdt.getFullyQualifiedName().startsWith(RemoveImplements.this.filter)) && cdt.getInterfaces().stream().anyMatch(it -> TypeUtils.isOfClassType(it, RemoveImplements.this.interfaceType))) {
                    return (J.ClassDeclaration)SearchResult.found((Tree)classDeclaration, (String)"");
                }
                return super.visitClassDeclaration(classDeclaration, ctx);
            }
        }, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            @Nullable AnnotationService annotationService;

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
                if (this.annotationService == null) {
                    this.annotationService = this.service(AnnotationService.class);
                }
                if (!(cd.getType() instanceof JavaType.Class) || cd.getImplements() == null) {
                    return super.visitClassDeclaration(cd, ctx);
                }
                JavaType.Class cdt = (JavaType.Class)cd.getType();
                if ((RemoveImplements.this.filter == null || cdt.getFullyQualifiedName().startsWith(RemoveImplements.this.filter)) && cdt.getInterfaces().stream().anyMatch(it -> TypeUtils.isOfClassType(it, RemoveImplements.this.interfaceType))) {
                    cd = cd.withImplements(cd.getImplements().stream().filter(implement -> !TypeUtils.isOfClassType(implement.getType(), RemoveImplements.this.interfaceType)).collect(Collectors.toList()));
                    cdt = cdt.withInterfaces(cdt.getInterfaces().stream().filter(it -> !TypeUtils.isOfClassType(it, RemoveImplements.this.interfaceType)).collect(Collectors.toList()));
                    cd = cd.withType(cdt);
                    this.maybeRemoveImport(RemoveImplements.this.interfaceType);
                    this.getCursor().putMessage(cdt.getFullyQualifiedName(), (Object)cdt);
                }
                return super.visitClassDeclaration(cd, ctx);
            }

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext ctx) {
                if (md.getMethodType() == null) {
                    return super.visitMethodDeclaration(md, ctx);
                }
                Object maybeClassType = this.getCursor().getNearestMessage(md.getMethodType().getDeclaringType().getFullyQualifiedName());
                if (!(maybeClassType instanceof JavaType.Class)) {
                    return super.visitMethodDeclaration(md, ctx);
                }
                JavaType.Class cdt = (JavaType.Class)maybeClassType;
                JavaType.Method mt = md.getMethodType().withDeclaringType(cdt);
                if ((md = md.withMethodType(mt)).getName().getType() != null) {
                    md = md.withName(md.getName().withType(mt));
                }
                this.updateCursor(md);
                assert (this.annotationService != null);
                if (!this.annotationService.matches(this.getCursor(), OVERRIDE_MATCHER) || TypeUtils.isOverride(md.getMethodType())) {
                    return super.visitMethodDeclaration(md, ctx);
                }
                md = (J.MethodDeclaration)new RemoveAnnotation("@java.lang.Override").getVisitor().visitNonNull(md, ctx, this.getCursor().getParentOrThrow());
                return super.visitMethodDeclaration(md, ctx);
            }
        });
    }

    @Generated
    public RemoveImplements(String interfaceType, @Nullable String filter) {
        this.interfaceType = interfaceType;
        this.filter = filter;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getInterfaceType() {
        return this.interfaceType;
    }

    @Generated
    public @Nullable String getFilter() {
        return this.filter;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveImplements(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", interfaceType=" + this.getInterfaceType() + ", filter=" + this.getFilter() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveImplements)) {
            return false;
        }
        RemoveImplements other = (RemoveImplements)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$interfaceType = this.getInterfaceType();
        String other$interfaceType = other.getInterfaceType();
        if (this$interfaceType == null ? other$interfaceType != null : !this$interfaceType.equals(other$interfaceType)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveImplements;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $interfaceType = this.getInterfaceType();
        result = result * 59 + ($interfaceType == null ? 43 : $interfaceType.hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }
}

