/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.config.YamlResourceLoader;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.internal.FormatFirstClassPrefix;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Markers;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public final class OrderImports
extends Recipe {
    @Option(displayName="Remove unused", description="Remove unnecessary imports.", required=false)
    private final @Nullable Boolean removeUnused;
    @Option(displayName="Style YAML", description="An OpenRewrite [style](https://docs.openrewrite.org/concepts-and-explanations/styles) formatted in YAML.", example="type: specs.openrewrite.org/v1beta/style\nname: com.yourorg.CustomImportLayout\nstyleConfigs:\n  - org.openrewrite.java.style.ImportLayoutStyle:\n      classCountToUseStarImport: 999\n      nameCountToUseStarImport: 999\n      layout:\n        - 'import java.*'\n        - 'import javax.*'\n        - '<blank line>'\n        - 'import all other imports'\n        - '<blank line>'\n        - 'import static all other imports'\n      packagesToFold:\n        - 'import java.awt.*'\n        - 'import static org.junit.jupiter.api.Assertions.*", required=false)
    private final @Nullable String style;
    private final String displayName = "Order imports";
    private final String description = "Groups and orders import statements. If a [style has been defined](https://docs.openrewrite.org/concepts-and-explanations/styles), this recipe will order the imports according to that style. If no style is detected, this recipe will default to ordering imports in the same way that IntelliJ IDEA does.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final List<NamedStyles> namedStyles = this.styleFromYaml(this.style);
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                Optional sourceSet = ((J.CompilationUnit)cu).getMarkers().findFirst(JavaSourceSet.class);
                List<JavaType.FullyQualified> classpath = Collections.emptyList();
                if (sourceSet.isPresent()) {
                    classpath = ((JavaSourceSet)sourceSet.get()).getClasspath();
                }
                ImportLayoutStyle importLayoutStyle = OrderImports.this.importLayoutStyle(cu, namedStyles);
                List<JRightPadded<J.Import>> orderedImports = importLayoutStyle.orderImports(((J.CompilationUnit)cu).getPadding().getImports(), classpath);
                boolean changed = false;
                if (orderedImports.size() != ((J.CompilationUnit)cu).getImports().size()) {
                    cu = ((J.CompilationUnit)cu).getPadding().withImports((List)orderedImports);
                    changed = true;
                } else {
                    for (int i = 0; i < orderedImports.size(); ++i) {
                        if (orderedImports.get(i) == ((J.CompilationUnit)cu).getPadding().getImports().get(i)) continue;
                        cu = ((J.CompilationUnit)cu).getPadding().withImports((List)orderedImports);
                        changed = true;
                        break;
                    }
                }
                if (Boolean.TRUE.equals(OrderImports.this.removeUnused)) {
                    this.doAfterVisit(new RemoveUnusedImports().getVisitor());
                } else if (changed) {
                    this.doAfterVisit(new FormatFirstClassPrefix());
                }
                return (J.CompilationUnit)OrderImports.this.withStyles(cu, namedStyles);
            }
        };
    }

    private List<NamedStyles> styleFromYaml(@Nullable String style) {
        if (style == null) {
            return Collections.emptyList();
        }
        return new ArrayList<NamedStyles>(new YamlResourceLoader((InputStream)new ByteArrayInputStream(style.getBytes()), URI.create("OrderImports$style"), new Properties()).listStyles());
    }

    private ImportLayoutStyle importLayoutStyle(SourceFile cu, List<NamedStyles> parsedStyles) {
        if (parsedStyles.isEmpty()) {
            return Optional.ofNullable((ImportLayoutStyle)Style.from(ImportLayoutStyle.class, (SourceFile)cu)).orElse(IntelliJ.importLayout());
        }
        return Objects.requireNonNull((ImportLayoutStyle)NamedStyles.merge(ImportLayoutStyle.class, parsedStyles));
    }

    private <T extends SourceFile> T withStyles(T cu, List<NamedStyles> parsedStyles) {
        if (parsedStyles.isEmpty()) {
            return cu;
        }
        List existingStyles = cu.getMarkers().findAll(NamedStyles.class);
        boolean allPresent = parsedStyles.stream().allMatch(ns -> existingStyles.stream().anyMatch(es -> this.namedStylesEqual((NamedStyles)ns, (NamedStyles)es)));
        if (allPresent) {
            return cu;
        }
        List markers = cu.getMarkers().getMarkers();
        for (NamedStyles namedStyle : parsedStyles) {
            if (!existingStyles.stream().noneMatch(es -> this.namedStylesEqual(namedStyle, (NamedStyles)es))) continue;
            markers = ListUtils.concat((Object)namedStyle, (List)markers);
        }
        return (T)((SourceFile)cu.withMarkers(Markers.build((Collection)markers)));
    }

    private boolean namedStylesEqual(NamedStyles a, NamedStyles b) {
        return a.getName().equals(b.getName());
    }

    @Generated
    public OrderImports(@Nullable Boolean removeUnused, @Nullable String style) {
        this.removeUnused = removeUnused;
        this.style = style;
    }

    @Generated
    public @Nullable Boolean getRemoveUnused() {
        return this.removeUnused;
    }

    @Generated
    public @Nullable String getStyle() {
        return this.style;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "OrderImports(removeUnused=" + this.getRemoveUnused() + ", style=" + this.getStyle() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderImports)) {
            return false;
        }
        OrderImports other = (OrderImports)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$removeUnused = this.getRemoveUnused();
        Boolean other$removeUnused = other.getRemoveUnused();
        if (this$removeUnused == null ? other$removeUnused != null : !((Object)this$removeUnused).equals(other$removeUnused)) {
            return false;
        }
        String this$style = this.getStyle();
        String other$style = other.getStyle();
        if (this$style == null ? other$style != null : !this$style.equals(other$style)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof OrderImports;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $removeUnused = this.getRemoveUnused();
        result = result * 59 + ($removeUnused == null ? 43 : ((Object)$removeUnused).hashCode());
        String $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : $style.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

