/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.internal.grammar.TemplateParameterParser;
import org.openrewrite.java.internal.template.TemplateParameter;
import org.openrewrite.java.internal.template.TypeParameter;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;

class JavaTemplateSemanticallyEqual
extends SemanticallyEqual {
    JavaTemplateSemanticallyEqual() {
    }

    static TemplateMatchResult matchesTemplate(JavaTemplate template, Cursor input) {
        JavaCoordinates coordinates;
        if (input.getValue() instanceof Expression) {
            coordinates = ((Expression)input.getValue()).getCoordinates().replace();
        } else if (input.getValue() instanceof Statement) {
            coordinates = ((Statement)input.getValue()).getCoordinates().replace();
        } else {
            throw new IllegalArgumentException("Only expressions and statements can be matched against a template: " + input.getClass());
        }
        J[] parameters = JavaTemplateSemanticallyEqual.createTemplateParameters(template.getCode(), template.getGenericTypes());
        try {
            Object templateTree = template.apply(input, coordinates, (Object[])parameters);
            return JavaTemplateSemanticallyEqual.matchTemplate(templateTree, input);
        }
        catch (RuntimeException e) {
            return new TemplateMatchResult(false, Collections.emptyList());
        }
    }

    private static J[] createTemplateParameters(String code, Set<String> genericTypes) {
        String previous;
        PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("#{", "}", null);
        Map<String, JavaType.GenericTypeVariable> generics = TypeParameter.parseGenericTypes(genericTypes);
        ArrayList parameters = new ArrayList();
        String substituted = code;
        HashMap typedPatternByName = new HashMap();
        while (!(previous = substituted).equals(substituted = propertyPlaceholderHelper.replacePlaceholders(substituted, key -> {
            String s;
            if (!key.isEmpty()) {
                TemplateParameterParser.MatcherPatternContext ctx = TypeParameter.parser(key).matcherPattern();
                if (ctx.typedPattern() == null) {
                    String paramName = ctx.parameterName().Identifier().getText();
                    s = (String)typedPatternByName.get(paramName);
                    if (s == null) {
                        throw new IllegalArgumentException("The parameter " + paramName + " must be defined before it is referenced.");
                    }
                } else {
                    TemplateParameterParser.TypedPatternContext typedPattern = ctx.typedPattern();
                    JavaType type = JavaTemplateSemanticallyEqual.typedParameter(key, typedPattern, generics);
                    s = TypeUtils.toString(type);
                    String name = null;
                    if (typedPattern.parameterName() != null) {
                        name = typedPattern.parameterName().Identifier().getText();
                        typedPatternByName.put(name, s);
                    }
                    Markers markers = Markers.build(Collections.singleton(new TemplateParameter(Tree.randomId(), type, name)));
                    parameters.add(new J.Empty(Tree.randomId(), Space.EMPTY, markers));
                }
            } else {
                throw new IllegalArgumentException("Only typed placeholders are allowed.");
            }
            return s;
        }))) {
        }
        return parameters.toArray(new J[0]);
    }

    private static JavaType typedParameter(String key, TemplateParameterParser.TypedPatternContext typedPattern, Map<String, JavaType.GenericTypeVariable> generics) {
        String matcherName = typedPattern.patternType().matcherName().Identifier().getText();
        if ("any".equals(matcherName)) {
            return TypeParameter.toJavaType(typedPattern.patternType().type(), generics);
        }
        if ("anyArray".equals(matcherName)) {
            return new JavaType.Array(null, TypeParameter.toJavaType(typedPattern.patternType().type(), generics), null);
        }
        throw new IllegalArgumentException("Unsupported template matcher '" + key + "'");
    }

    private static TemplateMatchResult matchTemplate(J templateTree, Cursor cursor) {
        if (templateTree == cursor.getValue()) {
            return new TemplateMatchResult(false, Collections.emptyList());
        }
        JavaTemplateSemanticallyEqualVisitor semanticallyEqualVisitor = new JavaTemplateSemanticallyEqualVisitor();
        semanticallyEqualVisitor.visit(templateTree, (J)cursor.getValue(), cursor.getParentOrThrow());
        return new TemplateMatchResult(semanticallyEqualVisitor.isEqual(), new ArrayList<J>(semanticallyEqualVisitor.matchedParameters.keySet()));
    }

    static final class TemplateMatchResult {
        private final boolean match;
        private final List<J> matchedParameters;

        @Generated
        public TemplateMatchResult(boolean match, List<J> matchedParameters) {
            this.match = match;
            this.matchedParameters = matchedParameters;
        }

        @Generated
        public boolean isMatch() {
            return this.match;
        }

        @Generated
        public List<J> getMatchedParameters() {
            return this.matchedParameters;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TemplateMatchResult)) {
                return false;
            }
            TemplateMatchResult other = (TemplateMatchResult)o;
            if (this.isMatch() != other.isMatch()) {
                return false;
            }
            List<J> this$matchedParameters = this.getMatchedParameters();
            List<J> other$matchedParameters = other.getMatchedParameters();
            return !(this$matchedParameters == null ? other$matchedParameters != null : !((Object)this$matchedParameters).equals(other$matchedParameters));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isMatch() ? 79 : 97);
            List<J> $matchedParameters = this.getMatchedParameters();
            result = result * 59 + ($matchedParameters == null ? 43 : ((Object)$matchedParameters).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "JavaTemplateSemanticallyEqual.TemplateMatchResult(match=" + this.isMatch() + ", matchedParameters=" + this.getMatchedParameters() + ")";
        }
    }

    private static class JavaTemplateSemanticallyEqualVisitor
    extends SemanticallyEqual.SemanticallyEqualVisitor {
        final Map<J, String> matchedParameters = new LinkedHashMap<J, String>();

        public JavaTemplateSemanticallyEqualVisitor() {
            super(true);
        }

        private boolean matchTemplateParameterPlaceholder(J.Empty empty, J j) {
            if (j instanceof TypedTree) {
                if (j instanceof J.Primitive || j instanceof J.Identifier && ((J.Identifier)j).getFieldType() == null) {
                    return false;
                }
                TemplateParameter marker = (TemplateParameter)empty.getMarkers().getMarkers().get(0);
                if (marker.getName() != null) {
                    for (Map.Entry<J, String> matchedParameter : this.matchedParameters.entrySet()) {
                        if (!matchedParameter.getValue().equals(marker.getName())) continue;
                        return SemanticallyEqual.areEqual(matchedParameter.getKey(), j);
                    }
                }
                if (this.isAssignableTo(marker.getType(), ((TypedTree)j).getType())) {
                    this.matchedParameters.put(j, marker.getName());
                    return true;
                }
            }
            return false;
        }

        @Override
        public J.Empty visitEmpty(J.Empty empty, J j) {
            if (this.isEqual.get()) {
                if (JavaTemplateSemanticallyEqualVisitor.isTemplateParameterPlaceholder(empty)) {
                    this.isEqual.set(this.matchTemplateParameterPlaceholder(empty, j));
                    return empty;
                }
                if (!(j instanceof J.Empty)) {
                    this.isEqual.set(false);
                    return empty;
                }
                J.Empty compareTo = (J.Empty)j;
                if (this.nullMissMatch(empty.getType(), compareTo.getType())) {
                    this.isEqual.set(false);
                    return empty;
                }
            }
            return empty;
        }

        private static boolean isTemplateParameterPlaceholder(J.Empty empty) {
            Markers markers = empty.getMarkers();
            return markers.getMarkers().size() == 1 && markers.getMarkers().get(0) instanceof TemplateParameter;
        }

        @Override
        protected boolean isOfType(JavaType target, JavaType source) {
            return TypeUtils.isAssignableTo(target, source, TypeUtils.ComparisonContext.INFER);
        }

        @Override
        protected boolean isAssignableTo(JavaType to, JavaType from) {
            return TypeUtils.isAssignableTo(to, from, TypeUtils.ComparisonContext.INFER);
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation template, J j) {
            if (!this.isEqual.get()) {
                return template;
            }
            if (!(j instanceof J.MethodInvocation)) {
                this.isEqual.set(false);
                return template;
            }
            J.MethodInvocation actual = (J.MethodInvocation)j;
            JavaType.Method templateMethod = template.getMethodType();
            if (templateMethod != null && templateMethod.hasFlags(Flag.Varargs) && this.hasVarargsPlaceholder(template)) {
                this.isEqual.set(this.matchWithVarargs(template, actual));
                return template;
            }
            return super.visitMethodInvocation(template, j);
        }

        private boolean hasVarargsPlaceholder(J.MethodInvocation template) {
            List<JRightPadded<Expression>> args = template.getPadding().getArguments().getPadding().getElements();
            if (args.isEmpty()) {
                return false;
            }
            JRightPadded<Expression> lastArg = args.get(args.size() - 1);
            if (!(lastArg.getElement() instanceof J.Empty)) {
                return false;
            }
            J.Empty empty = (J.Empty)lastArg.getElement();
            if (!JavaTemplateSemanticallyEqualVisitor.isTemplateParameterPlaceholder(empty)) {
                return false;
            }
            TemplateParameter param = (TemplateParameter)empty.getMarkers().getMarkers().get(0);
            return param.getType() instanceof JavaType.Array;
        }

        private boolean matchWithVarargs(J.MethodInvocation template, J.MethodInvocation actual) {
            boolean actualHasNoArgs;
            boolean actualStatic;
            JavaType.Method templateMethod = template.getMethodType();
            JavaType.Method actualMethod = actual.getMethodType();
            if (!template.getSimpleName().equals(actual.getSimpleName())) {
                return false;
            }
            if (templateMethod == null || actualMethod == null) {
                return false;
            }
            if (!this.isAssignableTo(templateMethod.getReturnType(), actualMethod.getReturnType())) {
                return false;
            }
            boolean templateStatic = templateMethod.hasFlags(Flag.Static);
            if (templateStatic != (actualStatic = actualMethod.hasFlags(Flag.Static))) {
                return false;
            }
            if (templateStatic) {
                JavaType.FullyQualified actualDeclaringType;
                JavaType.FullyQualified templateDeclaringType = templateMethod.getDeclaringType();
                if (!this.isAssignableTo(templateDeclaringType instanceof JavaType.Parameterized ? ((JavaType.Parameterized)templateDeclaringType).getType() : templateDeclaringType, (actualDeclaringType = actualMethod.getDeclaringType()) instanceof JavaType.Parameterized ? ((JavaType.Parameterized)actualDeclaringType).getType() : actualDeclaringType)) {
                    return false;
                }
            } else {
                if (this.nullMissMatch(template.getSelect(), actual.getSelect())) {
                    return false;
                }
                if (template.getSelect() != null && actual.getSelect() != null) {
                    this.visit((Tree)template.getSelect(), actual.getSelect());
                    if (!this.isEqual.get()) {
                        return false;
                    }
                }
            }
            List<JRightPadded<Expression>> templateArgs = template.getPadding().getArguments().getPadding().getElements();
            List<JRightPadded<Expression>> actualArgs = actual.getPadding().getArguments().getPadding().getElements();
            boolean bl = actualHasNoArgs = actualArgs.isEmpty() || actualArgs.size() == 1 && actualArgs.get(0).getElement() instanceof J.Empty && !JavaTemplateSemanticallyEqualVisitor.isTemplateParameterPlaceholder((J.Empty)actualArgs.get(0).getElement());
            if (actualHasNoArgs) {
                actualArgs = Collections.emptyList();
            }
            int fixedArgCount = templateArgs.size() - 1;
            if (actualArgs.size() < fixedArgCount) {
                return false;
            }
            for (int i = 0; i < fixedArgCount; ++i) {
                this.visit((Tree)templateArgs.get(i).getElement(), actualArgs.get(i).getElement());
                if (this.isEqual.get()) continue;
                return false;
            }
            J.Empty varargsPlaceholder = (J.Empty)templateArgs.get(fixedArgCount).getElement();
            TemplateParameter param = (TemplateParameter)varargsPlaceholder.getMarkers().getMarkers().get(0);
            JavaType.Array arrayType = (JavaType.Array)param.getType();
            JavaType elementType = arrayType.getElemType();
            ArrayList<Expression> varargsElements = new ArrayList<Expression>();
            for (int i = fixedArgCount; i < actualArgs.size(); ++i) {
                JavaType actualArgType;
                Expression actualArg = actualArgs.get(i).getElement();
                if (i == fixedArgCount && actualArgs.size() == fixedArgCount + 1 && (actualArgType = actualArg.getType()) instanceof JavaType.Array && this.isAssignableTo(arrayType, actualArgType)) {
                    varargsElements.add(actualArg);
                    break;
                }
                if (actualArg instanceof TypedTree) {
                    actualArgType = ((TypedTree)((Object)actualArg)).getType();
                    if (!this.isAssignableTo(elementType, actualArgType)) {
                        return false;
                    }
                } else {
                    return false;
                }
                varargsElements.add(actualArg);
            }
            J.NewArray currentVarargs = this.buildVarargsArray(varargsElements, arrayType);
            if (param.getName() != null) {
                for (Map.Entry<J, String> entry : this.matchedParameters.entrySet()) {
                    if (!param.getName().equals(entry.getValue())) continue;
                    return SemanticallyEqual.areEqual(entry.getKey(), currentVarargs);
                }
            }
            this.matchedParameters.put(currentVarargs, param.getName());
            return true;
        }

        private J.NewArray buildVarargsArray(List<Expression> elements, JavaType.Array arrayType) {
            JContainer initializer = null;
            if (!elements.isEmpty()) {
                ArrayList paddedElements = new ArrayList(elements.size());
                for (Expression element : elements) {
                    paddedElements.add(JRightPadded.build(element));
                }
                initializer = JContainer.build(paddedElements);
            }
            return new J.NewArray(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null, Collections.emptyList(), initializer, arrayType);
        }
    }
}

