/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

@Incubating(since="8.63.0")
public final class InlineMethodCalls
extends Recipe {
    private static final Pattern TEMPLATE_IDENTIFIER = Pattern.compile("#\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*):any\\(.*?\\)}");
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="com.google.common.base.Preconditions checkNotNull(..)")
    private final String methodPattern;
    @Option(displayName="Replacement template", description="The replacement template for the method invocation. Parameters can be referenced using their names from the original method.", example="java.util.Objects.requireNonNull(#{p0})")
    private final String replacement;
    @Option(displayName="Imports", description="List of regular imports to add when the replacement is made.", required=false, example="[\"java.util.Objects\"]")
    private final @Nullable Set<String> imports;
    @Option(displayName="Static imports", description="List of static imports to add when the replacement is made.", required=false, example="[\"java.util.Collections.emptyList\"]")
    private final @Nullable Set<String> staticImports;
    @Option(displayName="Classpath from resources", description="List of paths to JAR files on the classpath for parsing the replacement template.", required=false, example="[\"guava-33.4.8-jre\"]")
    private final @Nullable Set<String> classpathFromResources;
    private final String displayName = "Inline method calls";
    private final String description = "Inline method calls using a template replacement pattern. Supports both method invocations and constructor calls, with optional imports.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher matcher = new MethodMatcher(this.methodPattern, true);
        return Preconditions.check(new UsesMethod(this.methodPattern), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (matcher.matches(method)) {
                    return this.replaceMethodCall(method, ctx);
                }
                return super.visitMethodInvocation(method, ctx);
            }

            @Override
            public J visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
                if (matcher.matches(newClass)) {
                    return this.replaceMethodCall(newClass, ctx);
                }
                return super.visitNewClass(newClass, ctx);
            }

            private J replaceMethodCall(MethodCall methodCall, ExecutionContext ctx) {
                Set importsSet = InlineMethodCalls.this.imports != null ? InlineMethodCalls.this.imports : Collections.emptySet();
                Set staticImportsSet = InlineMethodCalls.this.staticImports != null ? InlineMethodCalls.this.staticImports : Collections.emptySet();
                this.removeAndAddImports(methodCall, importsSet, staticImportsSet);
                J applied = this.applyJavaTemplate(methodCall, this.getCursor(), importsSet, staticImportsSet, ctx);
                return this.avoidMethodSelfReferences(methodCall, applied);
            }

            private void removeAndAddImports(MethodCall method, Set<String> templateImports, Set<String> templateStaticImports) {
                Set<String> originalImports = this.findOriginalImports(method);
                for (String originalImport : originalImports) {
                    if (templateImports.contains(originalImport) || templateStaticImports.contains(originalImport)) continue;
                    this.maybeRemoveImport(originalImport);
                }
                for (String importStr : templateImports) {
                    if (originalImports.contains(importStr)) continue;
                    this.maybeAddImport(importStr);
                }
                for (String staticImport : templateStaticImports) {
                    int lastDot;
                    if (originalImports.contains(staticImport) || 0 >= (lastDot = staticImport.lastIndexOf(46))) continue;
                    this.maybeAddImport(staticImport.substring(0, lastDot), staticImport.substring(lastDot + 1));
                }
            }

            private Set<String> findOriginalImports(MethodCall method) {
                return (Set)new JavaVisitor<Set<String>>(){

                    @Override
                    public @Nullable JavaType visitType(@Nullable JavaType javaType, Set<String> imports) {
                        JavaType jt = super.visitType(javaType, imports);
                        if (jt instanceof JavaType.FullyQualified) {
                            imports.add(((JavaType.FullyQualified)jt).getFullyQualifiedName());
                        }
                        return jt;
                    }

                    @Override
                    public J visitMethodInvocation(J.MethodInvocation methodInvocation, Set<String> staticImports) {
                        J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(methodInvocation, staticImports);
                        JavaType.Method methodType = mi.getMethodType();
                        if (mi.getSelect() == null && methodType != null && methodType.hasFlags(Flag.Static)) {
                            staticImports.add(String.format("%s.%s", methodType.getDeclaringType().getFullyQualifiedName(), methodType.getName()));
                        }
                        return mi;
                    }

                    @Override
                    public J visitIdentifier(J.Identifier identifier, Set<String> staticImports) {
                        J.Identifier id = (J.Identifier)super.visitIdentifier(identifier, staticImports);
                        JavaType.Variable fieldType = id.getFieldType();
                        if (fieldType != null && fieldType.hasFlags(Flag.Static) && fieldType.getOwner() instanceof JavaType.FullyQualified) {
                            staticImports.add(String.format("%s.%s", ((JavaType.FullyQualified)fieldType.getOwner()).getFullyQualifiedName(), fieldType.getName()));
                        }
                        return id;
                    }
                }.reduce(method, new HashSet());
            }

            J applyJavaTemplate(MethodCall methodCall, Cursor cursor, Set<String> importsSet, Set<String> staticImportsSet, ExecutionContext ctx) {
                JavaType.Method methodType = Objects.requireNonNull(methodCall.getMethodType());
                String string = this.createTemplateString(methodCall, methodType);
                Object[] parameters = this.createParameters(string, methodCall);
                JavaTemplate.Builder templateBuilder = JavaTemplate.builder(string).contextSensitive().imports(importsSet.toArray(new String[0])).staticImports(staticImportsSet.toArray(new String[0]));
                if (InlineMethodCalls.this.classpathFromResources != null && !InlineMethodCalls.this.classpathFromResources.isEmpty()) {
                    templateBuilder.javaParser((JavaParser.Builder<?, ?>)((Object)JavaParser.fromJavaVersion().classpathFromResources(ctx, InlineMethodCalls.this.classpathFromResources.toArray(new String[0]))));
                }
                return templateBuilder.build().apply(cursor, methodCall.getCoordinates().replace(), parameters);
            }

            private String createTemplateString(MethodCall original, JavaType.Method methodType) {
                String templateString = original instanceof J.NewClass && InlineMethodCalls.this.replacement.startsWith("this(") ? "new " + methodType.getDeclaringType().getClassName() + InlineMethodCalls.this.replacement.substring(4) : (original instanceof J.MethodInvocation && ((J.MethodInvocation)original).getSelect() == null && InlineMethodCalls.this.replacement.startsWith("this.") ? InlineMethodCalls.this.replacement.substring(5) : InlineMethodCalls.this.replacement.replaceAll("\\bthis\\b", "#{this:any()}"));
                List<String> originalParameterNames = methodType.getParameterNames();
                for (String parameterName : originalParameterNames) {
                    templateString = templateString.replaceFirst(String.format("\\b%s\\b", parameterName), String.format("#{%s:any()}", parameterName)).replaceAll(String.format("(?<!\\{)\\b%s\\b", parameterName), String.format("#{%s}", parameterName));
                }
                return templateString;
            }

            private Object[] createParameters(String templateString, MethodCall original) {
                Expression select;
                HashMap<String, Expression> lookup = new HashMap<String, Expression>();
                if (original instanceof J.MethodInvocation && (select = ((J.MethodInvocation)original).getSelect()) != null) {
                    lookup.put("this", select);
                }
                List<String> originalParameterNames = Objects.requireNonNull(original.getMethodType()).getParameterNames();
                for (int i = 0; i < originalParameterNames.size(); ++i) {
                    String originalName = originalParameterNames.get(i);
                    Expression originalValue = original.getArguments().get(i);
                    lookup.put(originalName, originalValue);
                }
                ArrayList<Expression> parameters = new ArrayList<Expression>();
                Matcher matcher2 = TEMPLATE_IDENTIFIER.matcher(templateString);
                while (matcher2.find()) {
                    Expression o = (Expression)lookup.get(matcher2.group(1));
                    if (o == null) continue;
                    parameters.add(o);
                }
                return parameters.toArray();
            }

            private J avoidMethodSelfReferences(MethodCall original, J replacement) {
                JavaType.Method replacementMethodType;
                JavaType.Method method = replacementMethodType = replacement instanceof MethodCall ? ((MethodCall)replacement).getMethodType() : null;
                if (replacementMethodType == null) {
                    return replacement;
                }
                Cursor cursor = this.getCursor();
                while ((cursor = cursor.getParent()) != null) {
                    JavaType.Method cursorMethodType;
                    Object value = cursor.getValue();
                    if (value instanceof MethodCall) {
                        cursorMethodType = ((MethodCall)value).getMethodType();
                    } else {
                        if (!(value instanceof J.MethodDeclaration)) continue;
                        cursorMethodType = ((J.MethodDeclaration)value).getMethodType();
                    }
                    if (!TypeUtils.isOfType(replacementMethodType, cursorMethodType)) continue;
                    return original;
                }
                return replacement;
            }
        });
    }

    @Generated
    public InlineMethodCalls(String methodPattern, String replacement, @Nullable Set<String> imports, @Nullable Set<String> staticImports, @Nullable Set<String> classpathFromResources) {
        this.methodPattern = methodPattern;
        this.replacement = replacement;
        this.imports = imports;
        this.staticImports = staticImports;
        this.classpathFromResources = classpathFromResources;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public String getReplacement() {
        return this.replacement;
    }

    @Generated
    public @Nullable Set<String> getImports() {
        return this.imports;
    }

    @Generated
    public @Nullable Set<String> getStaticImports() {
        return this.staticImports;
    }

    @Generated
    public @Nullable Set<String> getClasspathFromResources() {
        return this.classpathFromResources;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "InlineMethodCalls(methodPattern=" + this.getMethodPattern() + ", replacement=" + this.getReplacement() + ", imports=" + this.getImports() + ", staticImports=" + this.getStaticImports() + ", classpathFromResources=" + this.getClasspathFromResources() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineMethodCalls)) {
            return false;
        }
        InlineMethodCalls other = (InlineMethodCalls)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$replacement = this.getReplacement();
        String other$replacement = other.getReplacement();
        if (this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement)) {
            return false;
        }
        Set<String> this$imports = this.getImports();
        Set<String> other$imports = other.getImports();
        if (this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports)) {
            return false;
        }
        Set<String> this$staticImports = this.getStaticImports();
        Set<String> other$staticImports = other.getStaticImports();
        if (this$staticImports == null ? other$staticImports != null : !((Object)this$staticImports).equals(other$staticImports)) {
            return false;
        }
        Set<String> this$classpathFromResources = this.getClasspathFromResources();
        Set<String> other$classpathFromResources = other.getClasspathFromResources();
        if (this$classpathFromResources == null ? other$classpathFromResources != null : !((Object)this$classpathFromResources).equals(other$classpathFromResources)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof InlineMethodCalls;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $replacement = this.getReplacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        Set<String> $imports = this.getImports();
        result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
        Set<String> $staticImports = this.getStaticImports();
        result = result * 59 + ($staticImports == null ? 43 : ((Object)$staticImports).hashCode());
        Set<String> $classpathFromResources = this.getClasspathFromResources();
        result = result * 59 + ($classpathFromResources == null ? 43 : ((Object)$classpathFromResources).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

