/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class DeleteMethodArgument
extends Recipe {
    @Option(displayName="Method pattern", description="A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="com.yourorg.A foo(int, int)")
    private final String methodPattern;
    @Option(displayName="Argument index", description="A zero-based index that indicates which argument will be removed from the method invocation.", example="0")
    private final int argumentIndex;
    private final String displayName = "Delete method argument";
    private final String description = "Delete an argument from method invocations.";

    public String getInstanceNameSuffix() {
        return String.format("%d in methods `%s`", this.argumentIndex, this.methodPattern);
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern);
        return Preconditions.check(new UsesMethod(methodMatcher), (TreeVisitor)new DeleteMethodArgumentVisitor(methodMatcher));
    }

    @Generated
    public DeleteMethodArgument(String methodPattern, int argumentIndex) {
        this.methodPattern = methodPattern;
        this.argumentIndex = argumentIndex;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DeleteMethodArgument(methodPattern=" + this.getMethodPattern() + ", argumentIndex=" + this.getArgumentIndex() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteMethodArgument)) {
            return false;
        }
        DeleteMethodArgument other = (DeleteMethodArgument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getArgumentIndex() != other.getArgumentIndex()) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DeleteMethodArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getArgumentIndex();
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private class DeleteMethodArgumentVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            return (J.MethodInvocation)this.visitMethodCall((MethodCall)m);
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J n = super.visitNewClass(newClass, ctx);
            return (J.NewClass)this.visitMethodCall((MethodCall)n);
        }

        private MethodCall visitMethodCall(MethodCall methodCall) {
            MethodCall m = methodCall;
            List<Expression> originalArgs = m.getArguments();
            if (this.methodMatcher.matches(m) && originalArgs.stream().filter(a -> !(a instanceof J.Empty)).count() >= (long)(DeleteMethodArgument.this.argumentIndex + 1)) {
                List<Expression> args = new ArrayList<Expression>(originalArgs);
                Expression removed = (Expression)args.remove(DeleteMethodArgument.this.argumentIndex);
                if (args.isEmpty()) {
                    args = Collections.singletonList(new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY));
                } else if (DeleteMethodArgument.this.argumentIndex == 0) {
                    args.set(0, (Expression)((Expression)args.get(0)).withPrefix(removed.getPrefix()));
                }
                m = m.withArguments(args);
                ((Set)new JavaIsoVisitor<Set<String>>(){

                    @Override
                    public @Nullable JavaType visitType(@Nullable JavaType javaType, Set<String> types) {
                        JavaType.Variable variable;
                        if (javaType instanceof JavaType.Class) {
                            JavaType.Class type = (JavaType.Class)javaType;
                            if (!"java.lang".equals(type.getPackageName())) {
                                types.add(type.getFullyQualifiedName());
                            }
                        } else if (javaType instanceof JavaType.Variable && (variable = (JavaType.Variable)javaType).hasFlags(Flag.Static) && variable.getOwner() instanceof JavaType.Class) {
                            JavaType.Class owner = (JavaType.Class)variable.getOwner();
                            types.add(owner.getFullyQualifiedName() + "." + variable.getName());
                        }
                        return super.visitType(javaType, types);
                    }

                    @Override
                    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, Set<String> strings) {
                        if (mi.getMethodType() != null && mi.getMethodType().hasFlags(Flag.Static) && mi.getSelect() == null) {
                            JavaType.FullyQualified receiverType = mi.getMethodType().getDeclaringType();
                            strings.add(receiverType.getFullyQualifiedName() + "." + mi.getSimpleName());
                        }
                        return super.visitMethodInvocation(mi, strings);
                    }
                }.reduce(removed, new HashSet())).forEach(this::maybeRemoveImport);
                JavaType.Method methodType = m.getMethodType();
                if (methodType != null) {
                    ArrayList<String> parameterNames = new ArrayList<String>(methodType.getParameterNames());
                    parameterNames.remove(DeleteMethodArgument.this.argumentIndex);
                    ArrayList<JavaType> parameterTypes = new ArrayList<JavaType>(methodType.getParameterTypes());
                    parameterTypes.remove(DeleteMethodArgument.this.argumentIndex);
                    m = m.withMethodType(methodType.withParameterNames(parameterNames).withParameterTypes(parameterTypes));
                    if (m instanceof J.MethodInvocation && ((J.MethodInvocation)m).getName().getType() != null) {
                        m = ((J.MethodInvocation)m).withName(((J.MethodInvocation)m).getName().withType(m.getMethodType()));
                    }
                }
            }
            return m;
        }

        @Generated
        public DeleteMethodArgumentVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }
    }
}

