/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.CreateFileVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

public final class CreateEmptyJavaClass
extends ScanningRecipe<AtomicBoolean> {
    @JsonIgnore
    private static final String NEW_CLASS_TEMPLATE = "package %s;\n\n%sclass %s {\n}";
    @Option(displayName="Source root", description="The source root of the new class file.", example="src/main/java")
    private final String sourceRoot;
    @Option(displayName="Package name", description="The package of the new class.", example="org.openrewrite.example")
    private final String packageName;
    @Option(displayName="Modifier", description="The class modifier.", valid={"public", "private", "protected", "package-private"}, example="public")
    private final String modifier;
    @Option(displayName="Class name", description="File path of new file.", example="ExampleClass")
    private final String className;
    @Option(displayName="Overwrite existing file", description="If there is an existing file, should it be overwritten.", required=false)
    private final @Nullable Boolean overwriteExisting;
    @Option(displayName="Relative directory path", description="Directory path of new class.", required=false, example="foo/bar")
    private final @Nullable String relativePath;
    private final String displayName = "Create Java class";
    private final String description = "Create a new, empty Java class.";

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(true);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(AtomicBoolean shouldCreate) {
        return new CreateFileVisitor(this.getSourcePath(), shouldCreate);
    }

    public Collection<SourceFile> generate(AtomicBoolean shouldCreate, ExecutionContext ctx) {
        if (shouldCreate.get()) {
            return this.createEmptyClass().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final AtomicBoolean created) {
        final Path path = this.getSourcePath();
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                Optional sourceFile;
                if ((created.get() || Boolean.TRUE.equals(CreateEmptyJavaClass.this.overwriteExisting)) && path.equals(cu.getSourcePath()) && (sourceFile = CreateEmptyJavaClass.this.createEmptyClass().findFirst()).isPresent() && sourceFile.get() instanceof J.CompilationUnit) {
                    J.CompilationUnit newCu = (J.CompilationUnit)sourceFile.get();
                    return ((J.CompilationUnit)cu.withClasses((List)newCu.getClasses())).withSourcePath(path);
                }
                return cu;
            }
        };
    }

    private Stream<SourceFile> createEmptyClass() {
        String packageModifier = "package-private".equals(this.modifier) ? "" : this.modifier + " ";
        return JavaParser.fromJavaVersion().build().parse(String.format(NEW_CLASS_TEMPLATE, this.packageName, packageModifier, this.className)).map(brandNewFile -> brandNewFile.withSourcePath(this.getSourcePath()));
    }

    private Path getSourcePath() {
        String path = this.relativePath;
        if (path == null) {
            path = "";
        }
        if (!path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        return Paths.get(String.format("%s%s/%s/%s.java", path, this.sourceRoot, this.packageName.replace('.', '/'), this.className), new String[0]);
    }

    @Generated
    public CreateEmptyJavaClass(String sourceRoot, String packageName, String modifier, String className, @Nullable Boolean overwriteExisting, @Nullable String relativePath) {
        this.sourceRoot = sourceRoot;
        this.packageName = packageName;
        this.modifier = modifier;
        this.className = className;
        this.overwriteExisting = overwriteExisting;
        this.relativePath = relativePath;
    }

    @Generated
    public String getSourceRoot() {
        return this.sourceRoot;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getModifier() {
        return this.modifier;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public @Nullable Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    @Generated
    public @Nullable String getRelativePath() {
        return this.relativePath;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "CreateEmptyJavaClass(sourceRoot=" + this.getSourceRoot() + ", packageName=" + this.getPackageName() + ", modifier=" + this.getModifier() + ", className=" + this.getClassName() + ", overwriteExisting=" + this.getOverwriteExisting() + ", relativePath=" + this.getRelativePath() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateEmptyJavaClass)) {
            return false;
        }
        CreateEmptyJavaClass other = (CreateEmptyJavaClass)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overwriteExisting = this.getOverwriteExisting();
        Boolean other$overwriteExisting = other.getOverwriteExisting();
        if (this$overwriteExisting == null ? other$overwriteExisting != null : !((Object)this$overwriteExisting).equals(other$overwriteExisting)) {
            return false;
        }
        String this$sourceRoot = this.getSourceRoot();
        String other$sourceRoot = other.getSourceRoot();
        if (this$sourceRoot == null ? other$sourceRoot != null : !this$sourceRoot.equals(other$sourceRoot)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$relativePath = this.getRelativePath();
        String other$relativePath = other.getRelativePath();
        if (this$relativePath == null ? other$relativePath != null : !this$relativePath.equals(other$relativePath)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof CreateEmptyJavaClass;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overwriteExisting = this.getOverwriteExisting();
        result = result * 59 + ($overwriteExisting == null ? 43 : ((Object)$overwriteExisting).hashCode());
        String $sourceRoot = this.getSourceRoot();
        result = result * 59 + ($sourceRoot == null ? 43 : $sourceRoot.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $relativePath = this.getRelativePath();
        result = result * 59 + ($relativePath == null ? 43 : $relativePath.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

