/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesField;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public final class ChangeStaticFieldToMethod
extends Recipe {
    @Option(displayName="Old class name", description="The fully qualified name of the class containing the field to replace.", example="java.util.Collections")
    private final String oldClassName;
    @Option(displayName="Old field name", description="The simple name of the static field to replace.", example="EMPTY_LIST")
    private final String oldFieldName;
    @Option(displayName="New class name", description="The fully qualified name of the class containing the method to use. Leave empty to keep the same class.", example="java.util.List", required=false)
    private final @Nullable String newClassName;
    @Option(displayName="New field target", description="An optional method target that can be used to specify a static field within the new class.", example="OK_RESPONSE", required=false)
    private final @Nullable String newTarget;
    @Option(displayName="New method name", description="The simple name of the method to use. The method must be static and have no arguments.", example="of")
    private final String newMethodName;
    private final String displayName = "Change static field access to static method access";
    private final String description = "Migrate accesses to a static field to invocations of a static method.";

    public String getInstanceNameSuffix() {
        String shortType = this.oldClassName.substring(this.oldClassName.lastIndexOf(46) + 1);
        return String.format("`%s#%s` to `%s`", shortType, this.oldFieldName, this.newMethodName);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesField(this.oldClassName, this.oldFieldName), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            @Override
            public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (TypeUtils.isOfClassType(classDecl.getType(), ChangeStaticFieldToMethod.this.oldClassName)) {
                    return classDecl;
                }
                return super.visitClassDeclaration(classDecl, ctx);
            }

            @Override
            public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                if (this.getCursor().firstEnclosing(J.Import.class) == null && TypeUtils.isOfClassType(fieldAccess.getTarget().getType(), ChangeStaticFieldToMethod.this.oldClassName) && fieldAccess.getSimpleName().equals(ChangeStaticFieldToMethod.this.oldFieldName)) {
                    return this.useNewMethod(fieldAccess, fieldAccess.getCoordinates().replace());
                }
                return super.visitFieldAccess(fieldAccess, ctx);
            }

            @Override
            public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
                JavaType.Variable varType = ident.getFieldType();
                if (varType != null && TypeUtils.isOfClassType(varType.getOwner(), ChangeStaticFieldToMethod.this.oldClassName) && varType.getName().equals(ChangeStaticFieldToMethod.this.oldFieldName)) {
                    return this.useNewMethod(ident, ident.getCoordinates().replace());
                }
                return ident;
            }

            private J useNewMethod(TypeTree tree, JavaCoordinates coordinates) {
                String newClass = ChangeStaticFieldToMethod.this.newClassName == null ? ChangeStaticFieldToMethod.this.oldClassName : ChangeStaticFieldToMethod.this.newClassName;
                this.maybeRemoveImport(ChangeStaticFieldToMethod.this.oldClassName);
                this.maybeAddImport(newClass);
                return this.makeNewMethod(newClass).apply(this.getCursor(), coordinates, new Object[0]);
            }

            private JavaTemplate makeNewMethod(String newClass) {
                int lastIndexOfDot = newClass.lastIndexOf(46);
                String packageName = newClass.substring(0, lastIndexOfDot);
                String simpleClassName = newClass.substring(lastIndexOfDot + 1);
                String methodInvocationTemplate = simpleClassName + (ChangeStaticFieldToMethod.this.newTarget != null ? "." + ChangeStaticFieldToMethod.this.newTarget + "." : ".") + ChangeStaticFieldToMethod.this.newMethodName + "()";
                String methodStub = ChangeStaticFieldToMethod.this.newTarget == null ? "package " + packageName + "; public class " + simpleClassName + " { public static void " + ChangeStaticFieldToMethod.this.newMethodName + "() { return null; } }" : "package " + packageName + "; public class Target { public static void " + ChangeStaticFieldToMethod.this.newMethodName + "() { return null; } } public class " + simpleClassName + " {public static Target " + ChangeStaticFieldToMethod.this.newTarget + ";}";
                return JavaTemplate.builder(methodInvocationTemplate).contextSensitive().javaParser((JavaParser.Builder<?, ?>)((Object)JavaParser.fromJavaVersion().dependsOn(methodStub))).imports(newClass).build();
            }
        });
    }

    @Generated
    public ChangeStaticFieldToMethod(String oldClassName, String oldFieldName, @Nullable String newClassName, @Nullable String newTarget, String newMethodName) {
        this.oldClassName = oldClassName;
        this.oldFieldName = oldFieldName;
        this.newClassName = newClassName;
        this.newTarget = newTarget;
        this.newMethodName = newMethodName;
    }

    @Generated
    public String getOldClassName() {
        return this.oldClassName;
    }

    @Generated
    public String getOldFieldName() {
        return this.oldFieldName;
    }

    @Generated
    public @Nullable String getNewClassName() {
        return this.newClassName;
    }

    @Generated
    public @Nullable String getNewTarget() {
        return this.newTarget;
    }

    @Generated
    public String getNewMethodName() {
        return this.newMethodName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeStaticFieldToMethod(oldClassName=" + this.getOldClassName() + ", oldFieldName=" + this.getOldFieldName() + ", newClassName=" + this.getNewClassName() + ", newTarget=" + this.getNewTarget() + ", newMethodName=" + this.getNewMethodName() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeStaticFieldToMethod)) {
            return false;
        }
        ChangeStaticFieldToMethod other = (ChangeStaticFieldToMethod)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldClassName = this.getOldClassName();
        String other$oldClassName = other.getOldClassName();
        if (this$oldClassName == null ? other$oldClassName != null : !this$oldClassName.equals(other$oldClassName)) {
            return false;
        }
        String this$oldFieldName = this.getOldFieldName();
        String other$oldFieldName = other.getOldFieldName();
        if (this$oldFieldName == null ? other$oldFieldName != null : !this$oldFieldName.equals(other$oldFieldName)) {
            return false;
        }
        String this$newClassName = this.getNewClassName();
        String other$newClassName = other.getNewClassName();
        if (this$newClassName == null ? other$newClassName != null : !this$newClassName.equals(other$newClassName)) {
            return false;
        }
        String this$newTarget = this.getNewTarget();
        String other$newTarget = other.getNewTarget();
        if (this$newTarget == null ? other$newTarget != null : !this$newTarget.equals(other$newTarget)) {
            return false;
        }
        String this$newMethodName = this.getNewMethodName();
        String other$newMethodName = other.getNewMethodName();
        if (this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeStaticFieldToMethod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldClassName = this.getOldClassName();
        result = result * 59 + ($oldClassName == null ? 43 : $oldClassName.hashCode());
        String $oldFieldName = this.getOldFieldName();
        result = result * 59 + ($oldFieldName == null ? 43 : $oldFieldName.hashCode());
        String $newClassName = this.getNewClassName();
        result = result * 59 + ($newClassName == null ? 43 : $newClassName.hashCode());
        String $newTarget = this.getNewTarget();
        result = result * 59 + ($newTarget == null ? 43 : $newTarget.hashCode());
        String $newMethodName = this.getNewMethodName();
        result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

