/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.MinimumViableSpacingVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.service.SourcePositionService;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.style.LineWrapSetting;

public final class WrapMethodDeclarationParameters<P>
extends JavaIsoVisitor<P> {
    private final SpacesStyle spacesStyle;
    private final WrappingAndBracesStyle style;

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P ctx) {
        J m = super.visitMethodDeclaration(method, (Object)ctx);
        try {
            if (this.style != null && this.style.getMethodDeclarationParameters() != null && this.style.getMethodDeclarationParameters().getWrap() != LineWrapSetting.DoNotWrap) {
                if (((J.MethodDeclaration)m).getParameters().size() <= 1) {
                    return m;
                }
                JavaSourceFile sourceFile = (JavaSourceFile)this.getCursor().firstEnclosing(JavaSourceFile.class);
                if (this.style.getMethodDeclarationParameters().getWrap() == LineWrapSetting.ChopIfTooLong) {
                    if (sourceFile == null) {
                        return m;
                    }
                    Cursor minimized = this.minimize(this.getCursor(), ctx);
                    if (((SourcePositionService)sourceFile.service(SourcePositionService.class)).positionOf(minimized, ((J.MethodDeclaration)minimized.getValue()).getPadding().getParameters()).getMaxColumn() <= this.style.getHardWrapAt()) {
                        return m;
                    }
                }
                if (this.style.getMethodDeclarationParameters().getCloseNewLine().booleanValue()) {
                    m = ((J.MethodDeclaration)m).getPadding().withParameters(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().withElements(ListUtils.mapLast(((J.MethodDeclaration)m).getPadding().getParameters().getPadding().getElements(), rightPaddedParam -> {
                        Space after = rightPaddedParam.getAfter();
                        if (after.getWhitespace().contains("\n")) {
                            return rightPaddedParam;
                        }
                        after = after.getComments().isEmpty() ? after.withWhitespace("\n") : after.withComments(ListUtils.mapLast(after.getComments(), comment -> comment.withSuffix("\n")));
                        return rightPaddedParam.withAfter(after);
                    })));
                }
                m = ((J.MethodDeclaration)m).withParameters(ListUtils.map(((J.MethodDeclaration)m).getParameters(), (paramIndex, param) -> {
                    if (param instanceof J.Empty) {
                        return param;
                    }
                    Space prefix = param.getPrefix();
                    if (prefix.getComments().isEmpty()) {
                        if ((paramIndex != 0 || this.style.getMethodDeclarationParameters().getOpenNewLine().booleanValue()) && !prefix.getWhitespace().contains("\n")) {
                            prefix = prefix.withWhitespace("\n");
                        }
                    } else {
                        int index = -1;
                        for (int i = prefix.getComments().size() - 1; i >= 0; --i) {
                            if (!prefix.getComments().get(i).getSuffix().contains("\n")) continue;
                            index = i;
                            break;
                        }
                        if (index == -1 && (paramIndex != 0 || this.style.getMethodDeclarationParameters().getOpenNewLine().booleanValue()) && !prefix.getWhitespace().contains("\n")) {
                            prefix = prefix.withWhitespace("\n");
                        }
                    }
                    return (Statement)param.withPrefix(prefix);
                }));
            }
        }
        catch (NoSuchFieldError | NoSuchMethodError incompatibleClassChangeError) {
            // empty catch block
        }
        return m;
    }

    public Cursor minimize(Cursor cursor, P ctx) {
        if (cursor.getValue() instanceof J) {
            final J cursorValue = (J)cursor.getValue();
            J j = (J)new JavaIsoVisitor<P>(){

                @Override
                public <T> @Nullable JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, JRightPadded.Location loc, P ctx) {
                    switch (loc) {
                        case METHOD_DECLARATION_PARAMETER: 
                        case RECORD_STATE_VECTOR: {
                            if (right == null || !(right.getElement() instanceof J)) break;
                            right = right.withAfter(this.minimized(right.getAfter())).withElement(((J)right.getElement()).withPrefix(this.minimized(((J)right.getElement()).getPrefix())));
                        }
                    }
                    return super.visitRightPadded(right, loc, ctx);
                }

                @Override
                public Space visitSpace(@Nullable Space space, Space.Location loc, P ctx) {
                    if (space == null) {
                        return super.visitSpace(space, loc, ctx);
                    }
                    if (space == cursorValue.getPrefix()) {
                        return space;
                    }
                    switch (loc) {
                        case BLOCK_PREFIX: 
                        case MODIFIER_PREFIX: 
                        case METHOD_DECLARATION_PARAMETER_SUFFIX: 
                        case METHOD_DECLARATION_PARAMETERS: 
                        case METHOD_SELECT_SUFFIX: 
                        case METHOD_INVOCATION_ARGUMENTS: 
                        case METHOD_INVOCATION_ARGUMENT_SUFFIX: 
                        case METHOD_INVOCATION_NAME: 
                        case RECORD_STATE_VECTOR_SUFFIX: {
                            space = this.minimized(space);
                        }
                    }
                    return super.visitSpace(space, loc, ctx);
                }

                private Space minimized(Space space) {
                    if (space.getComments().isEmpty()) {
                        return space.getWhitespace().isEmpty() ? space : Space.EMPTY;
                    }
                    return space;
                }
            }.visit(cursorValue, ctx);
            if (j != cursor.getValue()) {
                j = new MinimumViableSpacingVisitor(null).visit((Tree)j, (Object)ctx);
                j = new SpacesVisitor(this.spacesStyle, null, null).visit((Tree)j, (Object)ctx);
            }
            return new Cursor(cursor.getParent(), (Object)Objects.requireNonNull(j));
        }
        throw new IllegalArgumentException("Can only minimize J elements.");
    }

    @Generated
    public WrapMethodDeclarationParameters(SpacesStyle spacesStyle, WrappingAndBracesStyle style) {
        this.spacesStyle = spacesStyle;
        this.style = style;
    }

    @Generated
    public SpacesStyle getSpacesStyle() {
        return this.spacesStyle;
    }

    @Generated
    public WrappingAndBracesStyle getStyle() {
        return this.style;
    }

    @NonNull
    @Generated
    public String toString() {
        return "WrapMethodDeclarationParameters(spacesStyle=" + this.getSpacesStyle() + ", style=" + this.getStyle() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrapMethodDeclarationParameters)) {
            return false;
        }
        WrapMethodDeclarationParameters other = (WrapMethodDeclarationParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        SpacesStyle this$spacesStyle = this.getSpacesStyle();
        SpacesStyle other$spacesStyle = other.getSpacesStyle();
        if (this$spacesStyle == null ? other$spacesStyle != null : !((Object)this$spacesStyle).equals(other$spacesStyle)) {
            return false;
        }
        WrappingAndBracesStyle this$style = this.getStyle();
        WrappingAndBracesStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)this$style).equals(other$style));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof WrapMethodDeclarationParameters;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpacesStyle $spacesStyle = this.getSpacesStyle();
        result = result * 59 + ($spacesStyle == null ? 43 : ((Object)$spacesStyle).hashCode());
        WrappingAndBracesStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        return result;
    }
}

