/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.java.JavaTypeMapping;
import org.openrewrite.java.internal.JavaReflectionTypeSignatureBuilder;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.JavaType;

public class JavaReflectionTypeMapping
implements JavaTypeMapping<Type> {
    private static final int KIND_BITMASK_INTERFACE = 512;
    private static final int KIND_BITMASK_ANNOTATION = 8192;
    private static final int KIND_BITMASK_ENUM = 16384;
    private final JavaReflectionTypeSignatureBuilder signatureBuilder = new JavaReflectionTypeSignatureBuilder();
    private final JavaTypeCache typeCache;

    @Override
    public JavaType type(@Nullable Type type) {
        if (type == null) {
            return JavaType.Unknown.getInstance();
        }
        String signature = this.signatureBuilder.signature(type);
        JavaType existing = (JavaType)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return this.array(clazz, signature);
            }
            if (clazz.isPrimitive()) {
                return JavaType.Primitive.fromKeyword(clazz.getName());
            }
            return this.classType((Class)type, signature);
        }
        if (type instanceof GenericArrayType) {
            return this.array((GenericArrayType)type, signature);
        }
        if (type instanceof TypeVariable) {
            return this.generic((TypeVariable)type, signature);
        }
        if (type instanceof WildcardType) {
            return this.generic((WildcardType)type, signature);
        }
        if (type instanceof ParameterizedType) {
            return this.parameterized((ParameterizedType)type, signature);
        }
        throw new UnsupportedOperationException("Unknown type " + type.getClass().getName());
    }

    private JavaType.Array array(Class<?> clazz, String signature) {
        JavaType.Array arr = new JavaType.Array(null, null, null);
        this.typeCache.put(signature, arr);
        arr.unsafeSet(this.type(clazz.getComponentType()), null);
        return arr;
    }

    private JavaType.Array array(GenericArrayType type, String signature) {
        JavaType.Array arr = new JavaType.Array(null, null, null);
        this.typeCache.put(signature, arr);
        arr.unsafeSet(this.type(type.getGenericComponentType()), null);
        return arr;
    }

    private JavaType classType(Class<?> clazz, String signature) {
        JavaType.FullyQualified mappedClazz = this.classTypeWithoutParameters(clazz);
        if (clazz.getTypeParameters().length > 0) {
            JavaType existing = (JavaType)this.typeCache.get(signature);
            if (existing != null) {
                return existing;
            }
            JavaType.Parameterized pt = new JavaType.Parameterized(null, null, null);
            this.typeCache.put(signature, pt);
            ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(clazz.getTypeParameters().length);
            for (TypeVariable<Class<?>> typeParameter : clazz.getTypeParameters()) {
                typeParameters.add(this.type(typeParameter));
            }
            pt.unsafeSet(mappedClazz, typeParameters);
            return pt;
        }
        return mappedClazz;
    }

    private JavaType.FullyQualified classTypeWithoutParameters(Class<?> clazz) {
        String className = clazz.getName();
        JavaType.Class mappedClazz = (JavaType.Class)this.typeCache.get(className);
        if (mappedClazz == null) {
            JavaType.FullyQualified.Kind kind = (clazz.getModifiers() & 0x4000) != 0 ? JavaType.FullyQualified.Kind.Enum : ((clazz.getModifiers() & 0x2000) != 0 ? JavaType.FullyQualified.Kind.Annotation : ((clazz.getModifiers() & 0x200) != 0 ? JavaType.FullyQualified.Kind.Interface : JavaType.FullyQualified.Kind.Class));
            mappedClazz = new JavaType.Class(null, (long)clazz.getModifiers(), className, kind, null, null, null, null, null, null, null);
            this.typeCache.put(className, mappedClazz);
            JavaType.FullyQualified supertype = (JavaType.FullyQualified)("java.lang.Object".equals(clazz.getName()) ? null : (clazz.getSuperclass() == null ? this.type((Type)((Object)Object.class)) : this.type(clazz.getSuperclass())));
            JavaType.FullyQualified owner = "java.lang.Object".equals(clazz.getName()) ? null : (clazz.getDeclaringClass() == null ? null : (JavaType.FullyQualified)this.type(clazz.getDeclaringClass()));
            ArrayList<JavaType.FullyQualified> annotations = null;
            if (clazz.getDeclaredAnnotations().length > 0) {
                annotations = new ArrayList<JavaType.FullyQualified>(clazz.getDeclaredAnnotations().length);
                for (Annotation a : clazz.getDeclaredAnnotations()) {
                    JavaType.FullyQualified type = (JavaType.FullyQualified)this.type(a.annotationType());
                    annotations.add(type);
                }
            }
            ArrayList<JavaType.FullyQualified> interfaces = null;
            if (clazz.getInterfaces().length > 0) {
                interfaces = new ArrayList<JavaType.FullyQualified>(clazz.getInterfaces().length);
                for (Class<?> i : clazz.getInterfaces()) {
                    JavaType.FullyQualified type = (JavaType.FullyQualified)this.type(i);
                    interfaces.add(type);
                }
            }
            ArrayList<JavaType.Variable> members = null;
            if (clazz.getDeclaredFields().length > 0) {
                members = new ArrayList<JavaType.Variable>(clazz.getDeclaredFields().length);
                for (Field f : clazz.getDeclaredFields()) {
                    if (f.isSynthetic() || "java.lang.String".equals(clazz.getName()) && "serialPersistentFields".equals(f.getName())) continue;
                    JavaType.Variable field = this.field(f);
                    members.add(field);
                }
            }
            ArrayList<JavaType.Method> methods = null;
            if (clazz.getDeclaredMethods().length > 0) {
                methods = new ArrayList<JavaType.Method>(clazz.getDeclaredMethods().length + clazz.getDeclaredConstructors().length);
                for (Method method : clazz.getDeclaredMethods()) {
                    if (method.isBridge() || method.isSynthetic()) continue;
                    methods.add(this.method(method, (JavaType.FullyQualified)mappedClazz));
                }
            }
            if (clazz.getDeclaredConstructors().length > 0) {
                if (methods == null) {
                    methods = new ArrayList(clazz.getDeclaredConstructors().length);
                }
                for (Constructor<?> ctor : clazz.getDeclaredConstructors()) {
                    if (ctor.isSynthetic()) continue;
                    methods.add(this.method(ctor, (JavaType.FullyQualified)mappedClazz));
                }
            }
            ArrayList<JavaType> typeParameters = null;
            if (clazz.getTypeParameters().length > 0) {
                typeParameters = new ArrayList<JavaType>(clazz.getTypeParameters().length);
                for (TypeVariable<Class<?>> tParam : clazz.getTypeParameters()) {
                    typeParameters.add(this.type(tParam));
                }
            }
            mappedClazz.unsafeSet(typeParameters, supertype, owner, annotations, interfaces, members, methods);
        }
        return mappedClazz;
    }

    private JavaType generic(TypeVariable<?> typeParameter, String signature) {
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, typeParameter.getName(), JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, gtv);
        List<JavaType> bounds = this.genericBounds(typeParameter.getBounds());
        gtv.unsafeSet(gtv.getName(), bounds == null ? JavaType.GenericTypeVariable.Variance.INVARIANT : JavaType.GenericTypeVariable.Variance.COVARIANT, bounds);
        return gtv;
    }

    private JavaType.GenericTypeVariable generic(WildcardType wildcard, String signature) {
        JavaType.GenericTypeVariable gtv = new JavaType.GenericTypeVariable(null, "?", JavaType.GenericTypeVariable.Variance.INVARIANT, null);
        this.typeCache.put(signature, gtv);
        JavaType.GenericTypeVariable.Variance variance = JavaType.GenericTypeVariable.Variance.INVARIANT;
        List<JavaType> bounds = null;
        if (wildcard.getLowerBounds().length > 0) {
            bounds = this.genericBounds(wildcard.getLowerBounds());
            if (bounds != null) {
                variance = JavaType.GenericTypeVariable.Variance.CONTRAVARIANT;
            }
        } else if (wildcard.getUpperBounds().length > 0 && (bounds = this.genericBounds(wildcard.getUpperBounds())) != null) {
            variance = JavaType.GenericTypeVariable.Variance.COVARIANT;
        }
        gtv.unsafeSet(gtv.getName(), variance, bounds);
        return gtv;
    }

    private @Nullable List<JavaType> genericBounds(Type[] bounds) {
        ArrayList<JavaType> mappedBounds = null;
        for (Type bound : bounds) {
            JavaType mappedBound = this.type(bound);
            if (mappedBound instanceof JavaType.FullyQualified && "java.lang.Object".equals(((JavaType.FullyQualified)mappedBound).getFullyQualifiedName())) continue;
            if (mappedBounds == null) {
                mappedBounds = new ArrayList<JavaType>(bounds.length);
            }
            mappedBounds.add(mappedBound);
        }
        return mappedBounds;
    }

    private JavaType parameterized(ParameterizedType type, String signature) {
        JavaType.Parameterized pt = new JavaType.Parameterized(null, null, null);
        this.typeCache.put(signature, pt);
        ArrayList<JavaType> typeParameters = new ArrayList<JavaType>(type.getActualTypeArguments().length);
        for (Type actualTypeArgument : type.getActualTypeArguments()) {
            typeParameters.add(this.type(actualTypeArgument));
        }
        JavaType.FullyQualified baseType = this.classTypeWithoutParameters((Class)type.getRawType());
        pt.unsafeSet(baseType, typeParameters);
        return pt;
    }

    private JavaType.Variable field(Field field) {
        String signature = this.signatureBuilder.variableSignature(field);
        JavaType.Variable existing = (JavaType.Variable)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        JavaType.Variable mappedVariable = new JavaType.Variable(null, (long)field.getModifiers(), field.getName(), null, null, null);
        this.typeCache.put(signature, mappedVariable);
        ArrayList<JavaType.FullyQualified> annotations = null;
        if (field.getDeclaredAnnotations().length > 0) {
            annotations = new ArrayList<JavaType.FullyQualified>(field.getDeclaredAnnotations().length);
            for (Annotation a : field.getDeclaredAnnotations()) {
                JavaType.FullyQualified type = (JavaType.FullyQualified)this.type(a.annotationType());
                annotations.add(type);
            }
        }
        mappedVariable.unsafeSet(this.type(field.getDeclaringClass()), this.type(field.getGenericType()), annotations);
        return mappedVariable;
    }

    public JavaType.Method method(Method method) {
        JavaType.FullyQualified type = (JavaType.FullyQualified)this.type(method.getDeclaringClass());
        if (type instanceof JavaType.Parameterized) {
            type = ((JavaType.Parameterized)type).getType();
        }
        return this.method(method, type);
    }

    private JavaType.Method method(Constructor<?> method, JavaType.FullyQualified declaringType) {
        String signature = this.signatureBuilder.methodSignature(method, declaringType.getFullyQualifiedName());
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        String[] paramNames = null;
        if (method.getParameters().length > 0) {
            paramNames = new String[method.getParameters().length];
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Class<?>[] p = parameters[i];
                if (p.isSynthetic()) continue;
                paramNames[i] = p.getName();
            }
        }
        JavaType.Method mappedMethod = new JavaType.Method(null, (long)method.getModifiers(), null, "<constructor>", null, paramNames, null, null, null, null, null);
        this.typeCache.put(signature, mappedMethod);
        ArrayList<JavaType> thrownExceptions = null;
        if (method.getExceptionTypes().length > 0) {
            thrownExceptions = new ArrayList<JavaType>(method.getExceptionTypes().length);
            for (Class<?> e : method.getExceptionTypes()) {
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)this.type(e);
                thrownExceptions.add(fullyQualified);
            }
        }
        ArrayList<JavaType.FullyQualified> annotations = new ArrayList<JavaType.FullyQualified>();
        if (method.getDeclaredAnnotations().length > 0) {
            annotations = new ArrayList(method.getDeclaredAnnotations().length);
            for (Annotation a : method.getDeclaredAnnotations()) {
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)this.type(a.annotationType());
                annotations.add(fullyQualified);
            }
        }
        List<JavaType> parameterTypes = Collections.emptyList();
        if (method.getParameters().length > 0) {
            parameterTypes = new ArrayList(method.getParameters().length);
            for (Parameter parameter : method.getParameters()) {
                if (parameter.isSynthetic()) continue;
                Class<?> parameterizedType = parameter.getParameterizedType();
                parameterTypes.add(this.type(parameterizedType == null ? parameter.getType() : parameterizedType));
            }
        }
        mappedMethod.unsafeSet(declaringType, (JavaType)declaringType, parameterTypes, thrownExceptions, annotations);
        return mappedMethod;
    }

    private JavaType.Method method(Method method, JavaType.FullyQualified declaringType) {
        String signature = this.signatureBuilder.methodSignature(method, declaringType.getFullyQualifiedName());
        JavaType.Method existing = (JavaType.Method)this.typeCache.get(signature);
        if (existing != null) {
            return existing;
        }
        String[] paramNames = null;
        if (method.getParameters().length > 0) {
            paramNames = new String[method.getParameters().length];
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                Parameter parameter = parameters[i];
                paramNames[i] = parameter.getName();
            }
        }
        ArrayList<String> defaultValues = null;
        if (method.getDefaultValue() != null) {
            Class<?> valueClass = method.getDefaultValue().getClass();
            if (valueClass.isArray()) {
                int n;
                int n2;
                Object[] objectArray;
                defaultValues = new ArrayList();
                Class<?> clazz = valueClass.getComponentType();
                if (clazz == Integer.TYPE) {
                    objectArray = (int[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        int v = objectArray[n];
                        defaultValues.add(String.valueOf(v));
                    }
                } else if (clazz == Long.TYPE) {
                    objectArray = (long[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        int v = objectArray[n];
                        defaultValues.add(String.valueOf((long)v));
                    }
                } else if (clazz == Byte.TYPE) {
                    objectArray = (byte[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        int v = objectArray[n];
                        defaultValues.add(String.valueOf(v));
                    }
                } else if (clazz == Boolean.TYPE) {
                    objectArray = (boolean[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        boolean v = objectArray[n];
                        defaultValues.add(String.valueOf(v));
                    }
                } else if (clazz == Short.TYPE) {
                    objectArray = (short[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        int v = objectArray[n];
                        defaultValues.add(String.valueOf(v));
                    }
                } else if (clazz == Double.TYPE) {
                    objectArray = (double[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        int v = objectArray[n];
                        defaultValues.add(String.valueOf((double)v));
                    }
                } else if (clazz == Float.TYPE) {
                    objectArray = (float[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        int v = objectArray[n];
                        defaultValues.add(String.valueOf((float)v));
                    }
                } else {
                    objectArray = (Object[])method.getDefaultValue();
                    n2 = objectArray.length;
                    for (n = 0; n < n2; ++n) {
                        int v = objectArray[n];
                        defaultValues.add(String.valueOf((Object)v));
                    }
                }
            } else {
                defaultValues = Collections.singletonList(method.getDefaultValue().toString());
            }
        }
        ArrayList<String> declaredFormalTypeNames = null;
        for (TypeVariable<Method> typeVariable : method.getTypeParameters()) {
            if (typeVariable.getGenericDeclaration() != method) continue;
            if (declaredFormalTypeNames == null) {
                declaredFormalTypeNames = new ArrayList<String>();
            }
            declaredFormalTypeNames.add(typeVariable.getName());
        }
        JavaType.Method method2 = new JavaType.Method(null, (long)method.getModifiers(), null, method.getName(), null, paramNames, null, null, null, defaultValues, declaredFormalTypeNames == null ? null : declaredFormalTypeNames.toArray(new String[0]));
        this.typeCache.put(signature, method2);
        ArrayList<JavaType> thrownExceptions = null;
        if (method.getExceptionTypes().length > 0) {
            thrownExceptions = new ArrayList<JavaType>(method.getExceptionTypes().length);
            for (Type e : method.getGenericExceptionTypes()) {
                thrownExceptions.add(this.type(e));
            }
        }
        ArrayList<JavaType.FullyQualified> annotations = new ArrayList<JavaType.FullyQualified>();
        if (method.getDeclaredAnnotations().length > 0) {
            annotations = new ArrayList(method.getDeclaredAnnotations().length);
            for (Annotation a : method.getDeclaredAnnotations()) {
                JavaType.FullyQualified fullyQualified = (JavaType.FullyQualified)this.type(a.annotationType());
                annotations.add(fullyQualified);
            }
        }
        List<JavaType> parameterTypes = Collections.emptyList();
        if (method.getParameters().length > 0) {
            parameterTypes = new ArrayList(method.getParameters().length);
            for (Type parameter : method.getGenericParameterTypes()) {
                parameterTypes.add(this.type(parameter));
            }
        }
        JavaType returnType = this.type(method.getGenericReturnType());
        method2.unsafeSet(declaringType, returnType, parameterTypes, thrownExceptions, annotations);
        return method2;
    }

    @Generated
    public JavaReflectionTypeMapping(JavaTypeCache typeCache) {
        this.typeCache = typeCache;
    }
}

