/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.function.UnaryOperator;
import org.openrewrite.java.JavaTypeVisitor;
import org.openrewrite.java.tree.JavaType;

public class UnsafeJavaTypeVisitor<P>
extends JavaTypeVisitor<P> {
    @Override
    public JavaType visitClass(JavaType.Class aClass, P p) {
        return aClass.unsafeSet(UnsafeJavaTypeVisitor.mapInPlace((JavaType[])aClass.getTypeParameters().toArray(JavaType.EMPTY_JAVA_TYPE_ARRAY), t -> this.visit((JavaType)t, p)), (JavaType.FullyQualified)this.visit(aClass.getSupertype(), p), (JavaType.FullyQualified)this.visit(aClass.getOwningClass(), p), (JavaType.FullyQualified[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])aClass.getAnnotations().toArray(JavaType.EMPTY_FULLY_QUALIFIED_ARRAY), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)), (JavaType.FullyQualified[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])aClass.getInterfaces().toArray(JavaType.EMPTY_FULLY_QUALIFIED_ARRAY), i -> (JavaType.FullyQualified)this.visit((JavaType)i, p)), (JavaType.Variable[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])aClass.getMembers().toArray(JavaType.EMPTY_VARIABLE_ARRAY), m -> (JavaType.Variable)this.visit((JavaType)m, p)), (JavaType.Method[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])aClass.getMethods().toArray(JavaType.EMPTY_METHOD_ARRAY), m -> (JavaType.Method)this.visit((JavaType)m, p)));
    }

    @Override
    public JavaType visitArray(JavaType.Array array, P p) {
        return array.unsafeSet(this.visit(array.getElemType(), p), (JavaType.FullyQualified[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])array.getAnnotations().toArray(JavaType.EMPTY_FULLY_QUALIFIED_ARRAY), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
    }

    @Override
    public JavaType visitParameterized(JavaType.Parameterized parameterized, P p) {
        return parameterized.unsafeSet((JavaType.FullyQualified)this.visit(parameterized.getType(), p), UnsafeJavaTypeVisitor.mapInPlace((JavaType[])parameterized.getTypeParameters().toArray(JavaType.EMPTY_JAVA_TYPE_ARRAY), t -> this.visit((JavaType)t, p)));
    }

    @Override
    public JavaType visitGenericTypeVariable(JavaType.GenericTypeVariable generic, P p) {
        return generic.unsafeSet(generic.getName(), generic.getVariance(), UnsafeJavaTypeVisitor.mapInPlace((JavaType[])generic.getBounds().toArray(JavaType.EMPTY_JAVA_TYPE_ARRAY), b -> this.visit((JavaType)b, p)));
    }

    @Override
    public JavaType visitIntersection(JavaType.Intersection intersection, P p) {
        return intersection.unsafeSet(UnsafeJavaTypeVisitor.mapInPlace((JavaType[])intersection.getBounds().toArray(JavaType.EMPTY_JAVA_TYPE_ARRAY), t -> this.visit((JavaType)t, p)));
    }

    @Override
    public JavaType visitMethod(JavaType.Method method, P p) {
        return method.unsafeSet((JavaType.FullyQualified)this.visit(method.getDeclaringType(), p), this.visit(method.getReturnType(), p), UnsafeJavaTypeVisitor.mapInPlace((JavaType[])method.getParameterTypes().toArray(JavaType.EMPTY_JAVA_TYPE_ARRAY), pt -> this.visit((JavaType)pt, p)), (JavaType.FullyQualified[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])method.getThrownExceptions().toArray(JavaType.EMPTY_FULLY_QUALIFIED_ARRAY), t -> (JavaType.FullyQualified)this.visit((JavaType)t, p)), (JavaType.FullyQualified[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])method.getAnnotations().toArray(JavaType.EMPTY_FULLY_QUALIFIED_ARRAY), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
    }

    @Override
    public JavaType visitMultiCatch(JavaType.MultiCatch multiCatch, P p) {
        return multiCatch.unsafeSet(UnsafeJavaTypeVisitor.mapInPlace((JavaType[])multiCatch.getThrowableTypes().toArray(JavaType.EMPTY_JAVA_TYPE_ARRAY), t -> this.visit((JavaType)t, p)));
    }

    @Override
    public JavaType visitVariable(JavaType.Variable variable, P p) {
        return variable.unsafeSet(this.visit(variable.getOwner(), p), this.visit(variable.getType(), p), (JavaType.FullyQualified[])UnsafeJavaTypeVisitor.mapInPlace((JavaType[])variable.getAnnotations().toArray(JavaType.EMPTY_FULLY_QUALIFIED_ARRAY), a -> (JavaType.FullyQualified)this.visit((JavaType)a, p)));
    }

    private static <T extends JavaType> T[] mapInPlace(T[] ls, UnaryOperator<T> map) {
        for (int i = 0; i < ls.length; ++i) {
            ls[i] = (JavaType)map.apply(ls[i]);
        }
        return ls;
    }
}

