/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public final class FindComments
extends Recipe {
    @Option(displayName="Text patterns", description="A list of regular expressions to search for.", example="-----BEGIN RSA PRIVATE KEY-----")
    private final List<String> patterns;

    public String getDisplayName() {
        return "Find within comments and literals";
    }

    public String getDescription() {
        return "Find regular expression matches within comments and literals. \"Literals\" includes string literals, character literals, and numeric literals.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"patterns", (String)"Patterns must be compilable regular expressions", this.patterns, ps -> {
            for (String p : ps) {
                try {
                    Pattern.compile(p);
                }
                catch (PatternSyntaxException e) {
                    return false;
                }
            }
            return true;
        }));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final List compiledPatterns = this.patterns.stream().map(Pattern::compile).collect(Collectors.toList());
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, ExecutionContext context) {
                return space.withComments(ListUtils.map(space.getComments(), comment -> {
                    if (comment instanceof TextComment) {
                        for (Pattern p : compiledPatterns) {
                            if (!p.matcher(((TextComment)comment).getText()).find()) continue;
                            return comment.withMarkers(comment.getMarkers().computeByType((Marker)new SearchResult(Tree.randomId(), null), (s1, s2) -> s1 == null ? s2 : s1));
                        }
                    }
                    return comment;
                }));
            }

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext context) {
                if (literal.getType() == JavaType.Primitive.Null) {
                    return literal;
                }
                assert (literal.getValue() != null);
                if (compiledPatterns.stream().anyMatch(p -> p.matcher(literal.getValue().toString()).find())) {
                    return (J.Literal)SearchResult.found((Tree)literal);
                }
                return literal;
            }
        };
    }

    public FindComments(List<String> patterns) {
        this.patterns = patterns;
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    @NonNull
    public String toString() {
        return "FindComments(patterns=" + this.getPatterns() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindComments)) {
            return false;
        }
        FindComments other = (FindComments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$patterns = this.getPatterns();
        List<String> other$patterns = other.getPatterns();
        return !(this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindComments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        return result;
    }
}

