/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.format;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.tree.J;

public class GStringCurlyBraces
extends Recipe {
    final String displayName = "Groovy GString curly braces";
    final String description = "In Groovy [GStrings](https://docs.groovy-lang.org/latest/html/api/groovy/lang/GString.html), curly braces are optional for single variable expressions. This recipe adds them, so that the expression is always surrounded by curly braces.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){

            @Override
            public J visitGStringValue(G.GString.Value value, ExecutionContext ctx) {
                return value.withEnclosedInBraces(true);
            }
        };
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

