/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.groovy.format;

import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;

public class MinimumViableSpacingVisitor<P>
extends GroovyIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, P p) {
        J.MethodInvocation m = super.visitMethodInvocation(method, p);
        return m.withArguments(ListUtils.mapFirst((List)m.getArguments(), first -> {
            if (first.getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                return first.getPrefix().getWhitespace().isEmpty() ? (Expression)first.withPrefix(first.getPrefix().withWhitespace(" ")) : first;
            }
            return first;
        }));
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }

    @Nullable
    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        return (J)super.visit(tree, p);
    }

    public MinimumViableSpacingVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }
}

