/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.trait;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.gradle.DependencyVersionSelector;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleTraitMatcher;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.DependencyNotation;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.semver.DependencyMatcher;
import org.openrewrite.trait.Trait;

public final class SpringDependencyManagementPluginEntry
implements Trait<J.MethodInvocation> {
    private static final String GROUP = "group";
    private static final String ARTIFACT = "name";
    private static final String VERSION = "version";
    private final Cursor cursor;
    private final String group;
    private final Set<String> artifacts;
    private final String version;

    public SpringDependencyManagementPluginEntry withGroupArtifactVersion(DependencyMatcher matcher, @Nullable String newGroup, @Nullable String newArtifact, @Nullable String newVersion, @Nullable String versionPattern, MavenMetadataFailures metadataFailures, ExecutionContext ctx) {
        GradleProject gradleProject = this.getGradleProject();
        if (gradleProject == null) {
            return this;
        }
        ChangeDependencyManagementVisitor changeDependencyManagementVisitor = new ChangeDependencyManagementVisitor(gradleProject, matcher, metadataFailures, this, newGroup, newArtifact, newVersion, versionPattern);
        Cursor newCursor = new Cursor(this.cursor.getParent(), (Object)Objects.requireNonNull((J)changeDependencyManagementVisitor.visit(this.getTree(), ctx)));
        return new SpringDependencyManagementPluginEntry(newCursor, newGroup == null ? this.group : newGroup, this.artifacts, this.version);
    }

    private @Nullable GradleProject getGradleProject() {
        SourceFile sourceFile = (SourceFile)this.cursor.firstEnclosing(SourceFile.class);
        if (sourceFile == null) {
            return null;
        }
        Optional maybeGp = sourceFile.getMarkers().findFirst(GradleProject.class);
        return maybeGp.orElse(null);
    }

    public @Nullable String getVersionVariable() {
        J.MethodInvocation m = (J.MethodInvocation)this.cursor.getValue();
        if (m.getArguments().isEmpty()) {
            return null;
        }
        return SpringDependencyManagementPluginEntry.extractVersionVariable((Expression)m.getArguments().get(0));
    }

    private static @Nullable String extractVersionVariable(Expression arg) {
        J versionTree;
        List strings;
        if (arg instanceof G.GString && (strings = ((G.GString)arg).getStrings()).size() == 2 && strings.get(0) instanceof J.Literal && strings.get(1) instanceof G.GString.Value) {
            versionTree = ((G.GString.Value)strings.get(1)).getTree();
            if (versionTree instanceof J.Identifier) {
                return ((J.Identifier)versionTree).getSimpleName();
            }
            if (versionTree instanceof J.FieldAccess) {
                return ((J.FieldAccess)versionTree).getSimpleName();
            }
            if (versionTree instanceof J.MethodInvocation) {
                return SpringDependencyManagementPluginEntry.extractPropertyNameFromMethodInvocation((J.MethodInvocation)versionTree);
            }
            if (versionTree instanceof G.Binary) {
                return SpringDependencyManagementPluginEntry.extractPropertyNameFromGBinary((G.Binary)versionTree);
            }
        }
        if (arg instanceof K.StringTemplate && (strings = ((K.StringTemplate)arg).getStrings()).size() == 2 && strings.get(0) instanceof J.Literal && strings.get(1) instanceof K.StringTemplate.Expression && (versionTree = ((K.StringTemplate.Expression)strings.get(1)).getTree()) instanceof J.Identifier) {
            return ((J.Identifier)versionTree).getSimpleName();
        }
        return null;
    }

    private static @Nullable String extractPropertyNameFromMethodInvocation(J.MethodInvocation mi) {
        J.Literal literal;
        String methodName = mi.getSimpleName();
        if (("property".equals(methodName) || "findProperty".equals(methodName)) && !mi.getArguments().isEmpty() && mi.getArguments().get(0) instanceof J.Literal && (literal = (J.Literal)mi.getArguments().get(0)).getValue() instanceof String) {
            return (String)literal.getValue();
        }
        return null;
    }

    private static @Nullable String extractPropertyNameFromGBinary(G.Binary binary) {
        J.Literal right;
        if (binary.getOperator() == G.Binary.Type.Access && binary.getRight() instanceof J.Literal && (right = (J.Literal)binary.getRight()).getValue() instanceof String) {
            return (String)right.getValue();
        }
        return null;
    }

    private static GavMap getGAVMapEntriesForMapOfInvocation(J.MethodInvocation mapOf) {
        if (!"mapOf".equals(mapOf.getSimpleName())) {
            return new GavMap();
        }
        return SpringDependencyManagementPluginEntry.getGAVMapEntries(mapOf.getArguments(), J.MethodInvocation.class, J.MethodInvocation::getSelect, invocation -> (Expression)invocation.getArguments().get(0), e -> !"to".equals(e.getSimpleName()), e -> !(e.getSelect() instanceof J.Literal), e -> e.getArguments().size() != 1, e -> !(e.getArguments().get(0) instanceof J.Literal));
    }

    private static GavMap getGAVMapEntriesForGMapEntries(List<? extends Expression> mapEntries) {
        return SpringDependencyManagementPluginEntry.getGAVMapEntries(mapEntries, G.MapEntry.class, G.MapEntry::getKey, G.MapEntry::getValue, e -> !(e.getKey() instanceof J.Literal), e -> !(e.getValue() instanceof J.Literal));
    }

    private static GavMap getGAVMapEntriesForAssignments(List<? extends Expression> assignments) {
        return SpringDependencyManagementPluginEntry.getGAVMapEntries(assignments, J.Assignment.class, J.Assignment::getVariable, J.Assignment::getAssignment, a -> !(a.getVariable() instanceof J.Identifier), a -> !(a.getAssignment() instanceof J.Literal));
    }

    @SafeVarargs
    private static <T extends Expression> GavMap getGAVMapEntries(List<? extends Expression> elements, Class<T> type, Function<T, @Nullable Expression> keyExtractor, Function<T, @Nullable Expression> valueExtractor, Predicate<T> ... ignore) {
        GavMap map = new GavMap();
        for (Expression expression : elements) {
            if (!type.isInstance(expression)) continue;
            Expression element = (Expression)type.cast(expression);
            if (Arrays.stream(ignore).anyMatch(predicate -> predicate.test(element))) continue;
            Expression keyExpression = keyExtractor.apply(element);
            Expression valueExpression = valueExtractor.apply(element);
            if (keyExpression == null || valueExpression == null) continue;
            String key = SpringDependencyManagementPluginEntry.literalOrIdentifierToString(keyExpression);
            String value = SpringDependencyManagementPluginEntry.literalOrIdentifierToString(valueExpression);
            map.put(key, new GavMapEntry<Expression>(element, value));
        }
        return map;
    }

    private static String literalOrIdentifierToString(Expression expr) {
        if (expr instanceof J.Literal) {
            Object value = ((J.Literal)expr).getValue();
            return value == null ? "" : value.toString();
        }
        if (expr instanceof J.Identifier) {
            return ((J.Identifier)expr).getSimpleName();
        }
        throw new IllegalArgumentException("Expression must be a J.Literal or J.Identifier");
    }

    @Generated
    public SpringDependencyManagementPluginEntry(Cursor cursor, String group, Set<String> artifacts, String version) {
        this.cursor = cursor;
        this.group = group;
        this.artifacts = artifacts;
        this.version = version;
    }

    @Generated
    public Cursor getCursor() {
        return this.cursor;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public Set<String> getArtifacts() {
        return this.artifacts;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpringDependencyManagementPluginEntry)) {
            return false;
        }
        SpringDependencyManagementPluginEntry other = (SpringDependencyManagementPluginEntry)o;
        Cursor this$cursor = this.getCursor();
        Cursor other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        Set<String> this$artifacts = this.getArtifacts();
        Set<String> other$artifacts = other.getArtifacts();
        if (this$artifacts == null ? other$artifacts != null : !((Object)this$artifacts).equals(other$artifacts)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Cursor $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        Set<String> $artifacts = this.getArtifacts();
        result = result * 59 + ($artifacts == null ? 43 : ((Object)$artifacts).hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "SpringDependencyManagementPluginEntry(cursor=" + this.getCursor() + ", group=" + this.getGroup() + ", artifacts=" + this.getArtifacts() + ", version=" + this.getVersion() + ")";
    }

    private static class GavMap {
        Map<String, GavMapEntry<? extends Expression>> entries = new HashMap<String, GavMapEntry<? extends Expression>>();

        private GavMap() {
        }

        void put(String key, GavMapEntry<? extends Expression> entry) {
            this.entries.put(key, entry);
        }

        @Nullable GavMapEntry<? extends Expression> get(String key) {
            return this.entries.get(key);
        }

        @Nullable GroupArtifactVersion asGav() {
            return this.asGav(null);
        }

        @Nullable GroupArtifactVersion asGav(@Nullable String artifactName) {
            GavMapEntry<? extends Expression> group = this.entries.get(SpringDependencyManagementPluginEntry.GROUP);
            GavMapEntry<? extends Expression> artifact = this.entries.get(SpringDependencyManagementPluginEntry.ARTIFACT);
            GavMapEntry<? extends Expression> version = this.entries.get(SpringDependencyManagementPluginEntry.VERSION);
            if (!(group == null || artifact == null && StringUtils.isBlank((String)artifactName))) {
                return new GroupArtifactVersion(group.getValue(), !StringUtils.isBlank((String)artifactName) ? artifactName : Objects.requireNonNull(artifact).getValue(), version == null ? null : version.getValue());
            }
            return null;
        }

        private boolean isValid() {
            return this.entries.containsKey(SpringDependencyManagementPluginEntry.GROUP);
        }
    }

    private static class ChangeDependencyManagementVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final GradleProject gradleProject;
        private final DependencyMatcher depMatcher;
        private final MavenMetadataFailures metadataFailures;
        private final SpringDependencyManagementPluginEntry dependencyManagement;
        private final @Nullable String newGroup;
        private final @Nullable String newArtifact;
        private final @Nullable String newVersion;
        private final @Nullable String versionPattern;

        public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
            return sourceFile instanceof G.CompilationUnit || sourceFile instanceof K.CompilationUnit;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if ("dependency".equals(method.getSimpleName()) || "mavenBom".equals(method.getSimpleName())) {
                return this.updateDependency(m, ctx, this.gradleProject);
            }
            if ("dependencySet".equals(method.getSimpleName())) {
                return this.updateDependencySet(m, ctx);
            }
            return m;
        }

        private J.MethodInvocation updateDependencySet(J.MethodInvocation m, ExecutionContext ctx) {
            if (this.dependencyManagement.getArtifacts().stream().allMatch(artifact -> this.depMatcher.matches(this.dependencyManagement.getGroup(), artifact))) {
                for (String managedArtifact : this.dependencyManagement.getArtifacts()) {
                    GroupArtifactVersion original;
                    GroupArtifactVersion updated = original = new GroupArtifactVersion(this.dependencyManagement.getGroup(), managedArtifact, this.dependencyManagement.getVersion());
                    if (!StringUtils.isBlank((String)this.newGroup) && !this.newGroup.equals(updated.getGroupId())) {
                        updated = updated.withGroupId(this.newGroup);
                    }
                    if (!StringUtils.isBlank((String)this.newArtifact) && !updated.getArtifactId().equals(this.newArtifact)) {
                        updated = updated.withArtifactId(this.newArtifact);
                    }
                    if (!StringUtils.isBlank((String)this.newVersion) && updated.getGroupId() != null) {
                        String resolvedVersion;
                        try {
                            resolvedVersion = new DependencyVersionSelector(this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updated.getGroupId(), updated.getArtifactId()), m.getSimpleName(), this.newVersion, this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (resolvedVersion != null && !resolvedVersion.equals(updated.getVersion())) {
                            updated = updated.withVersion(resolvedVersion);
                        }
                    }
                    if (original == updated) continue;
                    m = this.updateDependencySet(m, ctx, original, updated);
                }
            }
            return m;
        }

        private J.MethodInvocation updateDependencySet(J.MethodInvocation m, ExecutionContext ctx, final GroupArtifactVersion oldGav, final GroupArtifactVersion newGav) {
            return (J.MethodInvocation)Objects.requireNonNull((J)new JavaIsoVisitor<ExecutionContext>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                    J.MethodInvocation visited = super.visitMethodInvocation(method, (Object)ctx);
                    if ("entry".equals(method.getSimpleName())) {
                        visited = visited.withArguments(ListUtils.map((List)visited.getArguments(), arg -> {
                            if (arg instanceof J.Literal && ((J.Literal)arg).getValue() instanceof String && oldGav.getArtifactId().equals(((J.Literal)arg).getValue())) {
                                return ChangeStringLiteral.withStringValue((J.Literal)arg, newGav.getArtifactId());
                            }
                            return arg;
                        }));
                    } else if ("dependencySet".equals(method.getSimpleName())) {
                        visited = visited.withArguments(ListUtils.map((List)visited.getArguments(), arg -> {
                            if (arg instanceof J.Literal) {
                                return ChangeStringLiteral.withStringValue((J.Literal)arg, newGav.getGroupId() + ":" + newGav.getVersion());
                            }
                            if (arg instanceof G.MapEntry) {
                                return this.updateMapEntry((G.MapEntry)arg);
                            }
                            if (arg instanceof G.MapLiteral) {
                                G.MapLiteral mapArg = (G.MapLiteral)arg;
                                return mapArg.withElements(ListUtils.map((List)mapArg.getElements(), this::updateMapEntry));
                            }
                            if (arg instanceof J.Assignment) {
                                J.Assignment ass = (J.Assignment)arg;
                                if (ass.getVariable() instanceof J.Identifier && ass.getAssignment() instanceof J.Literal) {
                                    J.Identifier identifier = (J.Identifier)ass.getVariable();
                                    J.Literal assignment = (J.Literal)ass.getAssignment();
                                    if (assignment.getValue() instanceof String) {
                                        if (SpringDependencyManagementPluginEntry.GROUP.equals(identifier.getSimpleName()) && newGav.getGroupId() != null) {
                                            return ass.withAssignment((Expression)ChangeStringLiteral.withStringValue(assignment, newGav.getGroupId()));
                                        }
                                        if (SpringDependencyManagementPluginEntry.VERSION.equals(identifier.getSimpleName()) && newGav.getVersion() != null) {
                                            return ass.withAssignment((Expression)ChangeStringLiteral.withStringValue(assignment, newGav.getVersion()));
                                        }
                                    }
                                }
                            } else if (arg instanceof J.MethodInvocation && "mapOf".equals(((J.MethodInvocation)arg).getSimpleName())) {
                                J.MethodInvocation m = (J.MethodInvocation)arg;
                                return m.withArguments(ListUtils.map((List)m.getArguments(), e -> {
                                    String name;
                                    if (!(e instanceof J.MethodInvocation)) {
                                        return e;
                                    }
                                    J.MethodInvocation methodInvocation = (J.MethodInvocation)e;
                                    if (!"to".equals(m.getSimpleName()) && !(methodInvocation.getSelect() instanceof J.Literal) && methodInvocation.getArguments().size() == 1 && methodInvocation.getArguments().get(0) instanceof J.Literal) {
                                        return e;
                                    }
                                    J.Literal identifier = (J.Literal)methodInvocation.getSelect();
                                    J.Literal value = (J.Literal)methodInvocation.getArguments().get(0);
                                    if (identifier == null || !(identifier.getValue() instanceof String) || !(value.getValue() instanceof String)) {
                                        return e;
                                    }
                                    switch (name = (String)identifier.getValue()) {
                                        case "group": {
                                            return methodInvocation.withArguments(ListUtils.map((List)methodInvocation.getArguments(), literal -> literal == null || newGav.getGroupId() == null ? literal : ChangeStringLiteral.withStringValue(literal, newGav.getGroupId())));
                                        }
                                        case "name": {
                                            return methodInvocation.withArguments(ListUtils.map((List)methodInvocation.getArguments(), literal -> literal == null ? null : ChangeStringLiteral.withStringValue(literal, newGav.getArtifactId())));
                                        }
                                        case "version": {
                                            return methodInvocation.withArguments(ListUtils.map((List)methodInvocation.getArguments(), literal -> literal == null || newGav.getVersion() == null ? literal : ChangeStringLiteral.withStringValue(literal, newGav.getVersion())));
                                        }
                                    }
                                    return e;
                                }));
                            }
                            return arg;
                        }));
                    }
                    return visited;
                }

                private // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable G.MapEntry updateMapEntry(// Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable G.MapEntry entry) {
                    if (entry != null && entry.getKey() instanceof J.Literal && entry.getValue() instanceof J.Literal) {
                        J.Literal key = (J.Literal)entry.getKey();
                        J.Literal value = (J.Literal)entry.getValue();
                        if (key.getValue() instanceof String && value.getValue() instanceof String) {
                            String keyValue = (String)key.getValue();
                            if (SpringDependencyManagementPluginEntry.GROUP.equals(keyValue) && newGav.getGroupId() != null) {
                                return entry.withValue((Expression)ChangeStringLiteral.withStringValue(value, newGav.getGroupId()));
                            }
                            if (SpringDependencyManagementPluginEntry.VERSION.equals(keyValue) && newGav.getVersion() != null) {
                                return entry.withValue((Expression)ChangeStringLiteral.withStringValue(value, newGav.getVersion()));
                            }
                        }
                    }
                    return entry;
                }
            }.visit((Tree)m, (Object)ctx));
        }

        private J.MethodInvocation updateDependency(J.MethodInvocation m, ExecutionContext ctx, GradleProject gradleProject) {
            List depArgs = m.getArguments();
            if (depArgs.get(0) instanceof J.Literal) {
                Dependency original;
                String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                if (gav != null && (original = DependencyNotation.parse((String)gav)) != null) {
                    Dependency updated = original;
                    if (!StringUtils.isBlank((String)this.newGroup) && !updated.getGroupId().equals(this.newGroup)) {
                        updated = updated.withGav(updated.getGav().withGroupId(this.newGroup));
                    }
                    if (!StringUtils.isBlank((String)this.newArtifact) && !updated.getArtifactId().equals(this.newArtifact)) {
                        updated = updated.withGav(updated.getGav().withArtifactId(this.newArtifact));
                    }
                    if (!StringUtils.isBlank((String)this.newVersion)) {
                        String resolvedVersion;
                        try {
                            resolvedVersion = new DependencyVersionSelector(this.metadataFailures, gradleProject, null).select(new GroupArtifact(updated.getGroupId(), updated.getArtifactId()), m.getSimpleName(), this.newVersion, this.versionPattern, ctx);
                        }
                        catch (MavenDownloadingException e) {
                            return (J.MethodInvocation)e.warn((Tree)m);
                        }
                        if (resolvedVersion != null && !resolvedVersion.equals(updated.getVersion())) {
                            updated = updated.withGav(updated.getGav().withVersion(resolvedVersion));
                        }
                    }
                    if (original != updated) {
                        String replacement = DependencyNotation.toStringNotation((Dependency)updated);
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> arg == null ? null : ChangeStringLiteral.withStringValue((J.Literal)arg, replacement)));
                    }
                }
                return m;
            }
            GavMap gavMap = null;
            if (m.getArguments().get(0) instanceof G.MapEntry) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForGMapEntries(depArgs);
            } else if (m.getArguments().get(0) instanceof G.MapLiteral) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForGMapEntries(((G.MapLiteral)depArgs.get(0)).getElements());
            } else if (m.getArguments().get(0) instanceof J.Assignment) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForAssignments(depArgs);
            } else if (m.getArguments().get(0) instanceof J.MethodInvocation) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForMapOfInvocation((J.MethodInvocation)m.getArguments().get(0));
            }
            if (gavMap != null && gavMap.isValid()) {
                GavMapEntry<? extends Expression> groupId = gavMap.get(SpringDependencyManagementPluginEntry.GROUP);
                GavMapEntry<? extends Expression> artifactId = gavMap.get(SpringDependencyManagementPluginEntry.ARTIFACT);
                GavMapEntry<? extends Expression> version = gavMap.get(SpringDependencyManagementPluginEntry.VERSION);
                try {
                    GroupArtifactVersion targetGav = this.calculateTargetGav(groupId, artifactId, version, m.getSimpleName(), ctx);
                    if (targetGav == null) {
                        return m;
                    }
                    if (!Objects.equals(targetGav.getGroupId(), groupId.getValue()) || !Objects.equals(targetGav.getArtifactId(), artifactId.getValue()) || targetGav.getVersion() != null && !Objects.equals(targetGav.getVersion(), version == null ? null : version.getValue())) {
                        if (m.getArguments().get(0) instanceof G.MapEntry || m.getArguments().get(0) instanceof G.MapLiteral) {
                            m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                                if (arg == groupId.getElement() && targetGav.getGroupId() != null) {
                                    return ((G.MapEntry)groupId.getElement()).withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)((G.MapEntry)groupId.getElement()).getValue(), targetGav.getGroupId()));
                                }
                                if (arg == artifactId.getElement()) {
                                    return ((G.MapEntry)artifactId.getElement()).withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)((G.MapEntry)artifactId.getElement()).getValue(), targetGav.getArtifactId()));
                                }
                                if (version != null && arg == version.getElement() && targetGav.getVersion() != null) {
                                    return ((G.MapEntry)version.getElement()).withValue((Expression)ChangeStringLiteral.withStringValue((J.Literal)((G.MapEntry)version.getElement()).getValue(), targetGav.getVersion()));
                                }
                                return arg;
                            }));
                        } else if (m.getArguments().get(0) instanceof J.Assignment) {
                            m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                                if (arg == groupId.getElement() && targetGav.getGroupId() != null) {
                                    return ((J.Assignment)groupId.getElement()).withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)((J.Assignment)groupId.getElement()).getAssignment(), targetGav.getGroupId()));
                                }
                                if (arg == artifactId.getElement()) {
                                    return ((J.Assignment)artifactId.getElement()).withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)((J.Assignment)artifactId.getElement()).getAssignment(), targetGav.getArtifactId()));
                                }
                                if (version != null && arg == version.getElement() && targetGav.getVersion() != null) {
                                    return ((J.Assignment)version.getElement()).withAssignment((Expression)ChangeStringLiteral.withStringValue((J.Literal)((J.Assignment)version.getElement()).getAssignment(), targetGav.getVersion()));
                                }
                                return arg;
                            }));
                        } else if (m.getArguments().get(0) instanceof J.MethodInvocation) {
                            m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                                if (arg instanceof J.MethodInvocation && "mapOf".equals(((J.MethodInvocation)arg).getSimpleName())) {
                                    return ((J.MethodInvocation)arg).withArguments(ListUtils.map((List)((J.MethodInvocation)arg).getArguments(), e -> {
                                        if (e == groupId.getElement() && targetGav.getGroupId() != null) {
                                            return ((J.MethodInvocation)groupId.getElement()).withArguments(ListUtils.map((List)((J.MethodInvocation)groupId.getElement()).getArguments(), literal -> literal == null ? null : ChangeStringLiteral.withStringValue(literal, targetGav.getGroupId())));
                                        }
                                        if (e == artifactId.getElement()) {
                                            return ((J.MethodInvocation)artifactId.getElement()).withArguments(ListUtils.map((List)((J.MethodInvocation)artifactId.getElement()).getArguments(), literal -> literal == null ? null : ChangeStringLiteral.withStringValue(literal, targetGav.getArtifactId())));
                                        }
                                        if (version != null && e == version.getElement() && targetGav.getVersion() != null) {
                                            return ((J.MethodInvocation)version.getElement()).withArguments(ListUtils.map((List)((J.MethodInvocation)version.getElement()).getArguments(), literal -> literal == null ? null : ChangeStringLiteral.withStringValue(literal, targetGav.getVersion())));
                                        }
                                        return e;
                                    }));
                                }
                                return arg;
                            }));
                        }
                    }
                }
                catch (MavenDownloadingException e) {
                    return (J.MethodInvocation)e.warn((Tree)m);
                }
            }
            return m;
        }

        private @Nullable GroupArtifactVersion calculateTargetGav(@Nullable GavMapEntry<?> groupId, @Nullable GavMapEntry<?> artifactId, @Nullable GavMapEntry<?> version, String configuration, ExecutionContext ctx) throws MavenDownloadingException {
            String resolvedVersion;
            String updatedVersion;
            if (groupId == null || artifactId == null) {
                return null;
            }
            if (!this.depMatcher.matches(groupId.getValue(), artifactId.getValue())) {
                return null;
            }
            String updatedGroupId = groupId.getValue();
            if (!StringUtils.isBlank((String)this.newGroup) && !updatedGroupId.equals(this.newGroup)) {
                updatedGroupId = this.newGroup;
            }
            String updatedArtifactId = artifactId.getValue();
            if (!StringUtils.isBlank((String)this.newArtifact) && !updatedArtifactId.equals(this.newArtifact)) {
                updatedArtifactId = this.newArtifact;
            }
            String string = updatedVersion = version == null ? null : version.getValue();
            if (!StringUtils.isBlank((String)this.newVersion) && (resolvedVersion = new DependencyVersionSelector(this.metadataFailures, this.gradleProject, null).select(new GroupArtifact(updatedGroupId, updatedArtifactId), configuration, this.newVersion, this.versionPattern, ctx)) != null && !resolvedVersion.equals(updatedVersion)) {
                updatedVersion = resolvedVersion;
            }
            return new GroupArtifactVersion(updatedGroupId, updatedArtifactId, updatedVersion);
        }

        @Generated
        public ChangeDependencyManagementVisitor(GradleProject gradleProject, DependencyMatcher depMatcher, MavenMetadataFailures metadataFailures, SpringDependencyManagementPluginEntry dependencyManagement, @Nullable String newGroup, @Nullable String newArtifact, @Nullable String newVersion, @Nullable String versionPattern) {
            this.gradleProject = gradleProject;
            this.depMatcher = depMatcher;
            this.metadataFailures = metadataFailures;
            this.dependencyManagement = dependencyManagement;
            this.newGroup = newGroup;
            this.newArtifact = newArtifact;
            this.newVersion = newVersion;
            this.versionPattern = versionPattern;
        }
    }

    private static final class GavMapEntry<T> {
        private final T element;
        private final String value;

        @Generated
        public GavMapEntry(T element, String value) {
            this.element = element;
            this.value = value;
        }

        @Generated
        public T getElement() {
            return this.element;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GavMapEntry)) {
                return false;
            }
            GavMapEntry other = (GavMapEntry)o;
            T this$element = this.getElement();
            T other$element = other.getElement();
            if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $element = this.getElement();
            result = result * 59 + ($element == null ? 43 : $element.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "SpringDependencyManagementPluginEntry.GavMapEntry(element=" + this.getElement() + ", value=" + this.getValue() + ")";
        }
    }

    public static class Matcher
    extends GradleTraitMatcher<SpringDependencyManagementPluginEntry> {
        private static final MethodMatcher DEPENDENCY_DSL_MATCHER = new MethodMatcher("io.spring.gradle.dependencymanagement.dsl.DependenciesHandler dependency(..)");
        private static final MethodMatcher DEPENDENCY_SET_MATCHER = new MethodMatcher("io.spring.gradle.dependencymanagement.dsl.DependenciesHandler dependencySet(..)");
        private static final MethodMatcher IMPORTS_MATCHER = new MethodMatcher("io.spring.gradle.dependencymanagement.dsl.ImportsHandler mavenBom(..)");
        protected @Nullable String groupId;
        protected @Nullable String artifactId;

        public Matcher groupId(@Nullable String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Matcher artifactId(@Nullable String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        protected @Nullable SpringDependencyManagementPluginEntry test(Cursor cursor) {
            Object object = cursor.getValue();
            if (object instanceof J.MethodInvocation) {
                J.MethodInvocation methodInvocation = (J.MethodInvocation)object;
                if (!this.withinDependenciesBlock(cursor) && !this.withinImportsBlock(cursor)) {
                    return null;
                }
                if (!this.withinDependencyManagementBlock(cursor)) {
                    return null;
                }
                HashSet<GroupArtifactVersion> dependencies = new HashSet<GroupArtifactVersion>();
                if (DEPENDENCY_DSL_MATCHER.matches(methodInvocation, true) || DEPENDENCY_SET_MATCHER.matches(methodInvocation, true)) {
                    Expression argument = (Expression)methodInvocation.getArguments().get(0);
                    if (argument instanceof J.Literal || argument instanceof G.MapEntry || argument instanceof G.MapLiteral || argument instanceof J.Assignment || argument instanceof J.MethodInvocation && "mapOf".equals(((J.MethodInvocation)argument).getSimpleName())) {
                        GroupArtifactVersion gav;
                        if (DEPENDENCY_SET_MATCHER.matches(methodInvocation, true)) {
                            dependencies.addAll(this.parseDependencySet(methodInvocation));
                        } else if (DEPENDENCY_DSL_MATCHER.matches(methodInvocation, true) && (gav = this.parseDependency(methodInvocation.getArguments())) != null) {
                            dependencies.add(gav);
                        }
                    }
                    if (dependencies.stream().anyMatch(dependency -> !StringUtils.matchesGlob((String)dependency.getGroupId(), (String)this.groupId) || !StringUtils.matchesGlob((String)dependency.getArtifactId(), (String)this.artifactId))) {
                        dependencies.clear();
                    }
                }
                GroupArtifactVersion importedBom = null;
                if (IMPORTS_MATCHER.matches(methodInvocation, true)) {
                    Expression argument = (Expression)methodInvocation.getArguments().get(0);
                    if (argument instanceof J.Literal || argument instanceof G.GString || argument instanceof G.MapEntry || argument instanceof G.MapLiteral || argument instanceof J.Assignment || argument instanceof K.StringTemplate) {
                        importedBom = this.parseDependency(methodInvocation.getArguments());
                    }
                    if (!(importedBom == null || StringUtils.matchesGlob((String)importedBom.getGroupId(), (String)this.groupId) && StringUtils.matchesGlob((String)importedBom.getArtifactId(), (String)this.artifactId))) {
                        importedBom = null;
                    }
                }
                if (dependencies.isEmpty() && importedBom == null) {
                    return null;
                }
                Optional dependencyGroupVersion = dependencies.stream().findFirst();
                Optional<Object> importedBomGroupVersion = Optional.ofNullable(importedBom);
                String group = dependencyGroupVersion.map(GroupArtifactVersion::getGroupId).orElseGet(() -> importedBomGroupVersion.map(GroupArtifactVersion::getGroupId).orElse(null));
                String version = dependencyGroupVersion.map(GroupArtifactVersion::getVersion).orElseGet(() -> importedBomGroupVersion.map(GroupArtifactVersion::getVersion).orElse(null));
                Set artifacts = dependencies.stream().map(GroupArtifactVersion::getArtifactId).collect(Collectors.toCollection(HashSet::new));
                if (importedBom != null) {
                    artifacts.add(importedBom.getArtifactId());
                }
                if (StringUtils.isBlank((String)group) || artifacts.isEmpty()) {
                    return null;
                }
                if (StringUtils.isBlank((String)version)) {
                    String versionVar;
                    if (!methodInvocation.getArguments().isEmpty() && (versionVar = SpringDependencyManagementPluginEntry.extractVersionVariable((Expression)methodInvocation.getArguments().get(0))) != null) {
                        return new SpringDependencyManagementPluginEntry(cursor, group, artifacts, "${" + versionVar + "}");
                    }
                    return null;
                }
                return new SpringDependencyManagementPluginEntry(cursor, group, artifacts, version);
            }
            return null;
        }

        private boolean withinDependencyManagementBlock(Cursor cursor) {
            return this.withinBlock(cursor, "dependencyManagement");
        }

        private boolean withinImportsBlock(Cursor cursor) {
            return this.withinBlock(cursor, "imports");
        }

        private boolean withinDependenciesBlock(Cursor cursor) {
            return this.withinBlock(cursor, "dependencies");
        }

        private List<GroupArtifactVersion> parseDependencySet(J.MethodInvocation methodInvocation) {
            ArrayList entries = new ArrayList();
            new JavaIsoVisitor<List<String>>(){

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> entries) {
                    Object value;
                    Expression argument;
                    if ("entry".equals(method.getSimpleName()) && method.getArguments().size() == 1 && (argument = (Expression)method.getArguments().get(0)) instanceof J.Literal && (value = ((J.Literal)argument).getValue()) instanceof String) {
                        entries.add((String)value);
                    }
                    return super.visitMethodInvocation(method, entries);
                }
            }.visit((Tree)methodInvocation, entries);
            ArrayList<GroupArtifactVersion> dependencies = new ArrayList<GroupArtifactVersion>();
            List arguments = methodInvocation.getArguments();
            Expression argument = (Expression)arguments.get(0);
            entries.forEach(entry -> {
                GroupArtifactVersion gav;
                GavMap gavMap = null;
                if (argument instanceof J.Literal) {
                    int versionIdx;
                    String notation = (String)((J.Literal)argument).getValue();
                    int n = versionIdx = notation == null ? -1 : notation.lastIndexOf(58);
                    if (versionIdx != -1) {
                        dependencies.add(new GroupArtifactVersion(notation.substring(0, versionIdx), entry, notation.substring(versionIdx + 1)));
                    }
                    return;
                }
                if (argument instanceof G.MapLiteral) {
                    gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForGMapEntries(((G.MapLiteral)argument).getElements());
                } else if (argument instanceof G.MapEntry) {
                    gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForGMapEntries(arguments);
                } else if (argument instanceof J.Assignment) {
                    gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForAssignments(arguments);
                } else if (argument instanceof J.MethodInvocation) {
                    gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForMapOfInvocation((J.MethodInvocation)argument);
                }
                if (gavMap != null && gavMap.isValid() && (gav = gavMap.asGav((String)entry)) != null) {
                    dependencies.add(gav);
                }
            });
            return dependencies;
        }

        private @Nullable GroupArtifactVersion parseDependency(List<Expression> arguments) {
            Expression argument = arguments.get(0);
            GavMap gavMap = null;
            if (argument instanceof J.Literal) {
                String stringNotation = (String)((J.Literal)argument).getValue();
                Dependency dependency = stringNotation == null ? null : DependencyNotation.parse((String)stringNotation);
                return dependency == null ? null : dependency.getGav();
            }
            if (argument instanceof G.GString) {
                G.GString gstring = (G.GString)argument;
                List strings = gstring.getStrings();
                if (strings.size() >= 2 && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null) {
                    Dependency dependency = DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
                    return dependency == null ? null : dependency.getGav();
                }
            } else if (argument instanceof K.StringTemplate) {
                K.StringTemplate template = (K.StringTemplate)argument;
                List strings = template.getStrings();
                if (!strings.isEmpty() && strings.get(0) instanceof J.Literal && ((J.Literal)strings.get(0)).getValue() != null) {
                    Dependency dependency = DependencyNotation.parse((String)((String)((J.Literal)strings.get(0)).getValue()));
                    return dependency == null ? null : dependency.getGav();
                }
            } else if (argument instanceof G.MapLiteral) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForGMapEntries(((G.MapLiteral)argument).getElements());
            } else if (argument instanceof G.MapEntry) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForGMapEntries(arguments);
            } else if (argument instanceof J.Assignment) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForAssignments(arguments);
            } else if (argument instanceof J.MethodInvocation) {
                gavMap = SpringDependencyManagementPluginEntry.getGAVMapEntriesForMapOfInvocation((J.MethodInvocation)argument);
            }
            if (gavMap == null || !gavMap.isValid()) {
                return null;
            }
            return gavMap.asGav();
        }
    }
}

