/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.search.FindPlugins;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.marker.SearchResult;

public final class ModuleHasPlugin
extends ScanningRecipe<Accumulator> {
    private final String displayName = "Module has plugin";
    private final String description = "Searches for Gradle Projects (modules) that have a plugin matching the specified id or implementing class. Places a `SearchResult` marker on all sources within a project with a matching plugin. This recipe is intended to be used as a precondition for other recipes. For example this could be used to limit the application of a spring boot migration to only projects that apply the spring dependency management plugin, limiting unnecessary upgrading. If the search result you want is instead just the build.gradle(.kts) file applying the plugin, use the `FindPlugins` recipe instead.";
    @Option(displayName="Plugin id", description="The unique identifier used to apply a plugin in the `plugins` block. Note that this alone is insufficient to search for plugins applied by fully qualified class name and the `buildscript` block.", example="`com.jfrog.bintray`")
    private final String pluginId;
    @Option(displayName="Plugin class", description="The fully qualified name of a class implementing a Gradle plugin. ", required=false, example="com.jfrog.bintray.gradle.BintrayPlugin")
    private final @Nullable String pluginClass;

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashSet<JavaProject>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                tree.getMarkers().findFirst(JavaProject.class).ifPresent(jp -> {
                    Tree t = new FindPlugins(ModuleHasPlugin.this.pluginId, ModuleHasPlugin.this.pluginClass).getVisitor().visit(tree, (Object)ctx);
                    if (t != tree) {
                        acc.getProjectsWithDependency().add((JavaProject)jp);
                    }
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                Optional maybeJp = tree.getMarkers().findFirst(JavaProject.class);
                if (!maybeJp.isPresent()) {
                    return tree;
                }
                JavaProject jp = (JavaProject)maybeJp.get();
                if (acc.getProjectsWithDependency().contains(jp)) {
                    return SearchResult.found((Tree)tree, (String)("Module has plugin: " + ModuleHasPlugin.this.pluginId));
                }
                return tree;
            }
        };
    }

    @Generated
    public ModuleHasPlugin(String pluginId, @Nullable String pluginClass) {
        this.pluginId = pluginId;
        this.pluginClass = pluginClass;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public @Nullable String getPluginClass() {
        return this.pluginClass;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ModuleHasPlugin(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", pluginId=" + this.getPluginId() + ", pluginClass=" + this.getPluginClass() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleHasPlugin)) {
            return false;
        }
        ModuleHasPlugin other = (ModuleHasPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$pluginClass = this.getPluginClass();
        String other$pluginClass = other.getPluginClass();
        return !(this$pluginClass == null ? other$pluginClass != null : !this$pluginClass.equals(other$pluginClass));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ModuleHasPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $pluginClass = this.getPluginClass();
        result = result * 59 + ($pluginClass == null ? 43 : $pluginClass.hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Set<JavaProject> projectsWithDependency;

        @Generated
        public Accumulator(Set<JavaProject> projectsWithDependency) {
            this.projectsWithDependency = projectsWithDependency;
        }

        @Generated
        public Set<JavaProject> getProjectsWithDependency() {
            return this.projectsWithDependency;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<JavaProject> this$projectsWithDependency = this.getProjectsWithDependency();
            Set<JavaProject> other$projectsWithDependency = other.getProjectsWithDependency();
            return !(this$projectsWithDependency == null ? other$projectsWithDependency != null : !((Object)this$projectsWithDependency).equals(other$projectsWithDependency));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<JavaProject> $projectsWithDependency = this.getProjectsWithDependency();
            result = result * 59 + ($projectsWithDependency == null ? 43 : ((Object)$projectsWithDependency).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ModuleHasPlugin.Accumulator(projectsWithDependency=" + this.getProjectsWithDependency() + ")";
        }
    }
}

