/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.groovy.GroovyPrinter;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.kotlin.tree.K;
import org.openrewrite.marker.SearchResult;

public final class FindRepository
extends Recipe {
    @Option(displayName="Type", description="The type of the artifact repository", example="maven", required=false)
    private final @Nullable String type;
    @Option(displayName="URL", description="The url of the artifact repository", example="https://repo.spring.io", required=false)
    private final @Nullable String url;
    @Option(displayName="Purpose", description="The purpose of this repository in terms of resolving project or plugin dependencies", valid={"Project", "Plugin"}, required=false)
    private final @Nullable Purpose purpose;
    private final String displayName = "Find Gradle repository";
    private final String description = "Find a Gradle repository by url.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher pluginManagementMatcher = new MethodMatcher("RewriteSettings pluginManagement(..)");
        final MethodMatcher buildscriptMatcher = new MethodMatcher("RewriteGradleProject buildscript(..)");
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                boolean isPluginBlock;
                if (FindRepository.this.purpose == null) {
                    return new RepositoryVisitor().visitMethodInvocation(method, ctx);
                }
                boolean bl = isPluginBlock = pluginManagementMatcher.matches(method, true) || buildscriptMatcher.matches(method, true);
                if (FindRepository.this.purpose == Purpose.Project && !isPluginBlock || FindRepository.this.purpose == Purpose.Plugin && isPluginBlock) {
                    return new RepositoryVisitor().visitMethodInvocation(method, ctx);
                }
                return method;
            }
        });
    }

    @Generated
    public FindRepository(@Nullable String type, @Nullable String url, @Nullable Purpose purpose) {
        this.type = type;
        this.url = url;
        this.purpose = purpose;
    }

    @Generated
    public @Nullable String getType() {
        return this.type;
    }

    @Generated
    public @Nullable String getUrl() {
        return this.url;
    }

    @Generated
    public @Nullable Purpose getPurpose() {
        return this.purpose;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindRepository(type=" + this.getType() + ", url=" + this.getUrl() + ", purpose=" + (Object)((Object)this.getPurpose()) + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindRepository)) {
            return false;
        }
        FindRepository other = (FindRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Purpose this$purpose = this.getPurpose();
        Purpose other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !((Object)((Object)this$purpose)).equals((Object)other$purpose)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindRepository;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Purpose $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : ((Object)((Object)$purpose)).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static enum Purpose {
        Project,
        Plugin;

    }

    private static class TemplateAsString
    extends JavaIsoVisitor<StringBuilder> {
        private TemplateAsString() {
        }

        private static String getValueSource(J tree) {
            return ((StringBuilder)new TemplateAsString().reduce((Tree)tree.withPrefix(Space.EMPTY), new StringBuilder())).toString();
        }

        public @Nullable J visit(@Nullable Tree tree, StringBuilder builder) {
            if (tree instanceof K.StringTemplate) {
                builder.append(((K.StringTemplate)tree).getDelimiter());
                super.visit(tree, (Object)builder);
                builder.append(((K.StringTemplate)tree).getDelimiter());
            } else if (tree instanceof K.StringTemplate.Expression) {
                builder.append("$");
                if (((K.StringTemplate.Expression)tree).isEnclosedInBraces()) {
                    builder.append("{");
                }
                super.visit(tree, (Object)builder);
                if (((K.StringTemplate.Expression)tree).isEnclosedInBraces()) {
                    builder.append("}");
                }
            } else if (tree instanceof G.GString) {
                builder.append(((G.GString)tree).getDelimiter());
                super.visit(tree, (Object)builder);
                builder.append(((G.GString)tree).getDelimiter());
            } else if (tree instanceof G.GString.Value) {
                builder.append("$");
                if (((G.GString.Value)tree).isEnclosedInBraces()) {
                    builder.append("{");
                }
                super.visit(tree, (Object)builder);
                if (((G.GString.Value)tree).isEnclosedInBraces()) {
                    builder.append("}");
                }
            } else {
                super.visit(tree, (Object)builder);
            }
            return (J)tree;
        }

        public J.Literal visitLiteral(J.Literal literal, StringBuilder builder) {
            builder.append(literal.getValue());
            return super.visitLiteral(literal, (Object)builder);
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, StringBuilder builder) {
            builder.append(identifier.getSimpleName());
            return super.visitIdentifier(identifier, (Object)builder);
        }
    }

    private class RepositoryVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher repositoryMatcher;

        private RepositoryVisitor() {
            this.repositoryMatcher = new MethodMatcher("org.gradle.api.artifacts.dsl.RepositoryHandler " + (FindRepository.this.type != null ? FindRepository.this.type : "*") + "(..)", true);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            boolean match;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if (!this.repositoryMatcher.matches(m, true)) {
                return m;
            }
            boolean bl = match = FindRepository.this.type == null || m.getSimpleName().equals(FindRepository.this.type);
            if (FindRepository.this.url != null && !this.urlMatches(m, FindRepository.this.url)) {
                match = false;
            }
            if (!match) {
                return m;
            }
            return (J.MethodInvocation)SearchResult.found((Tree)m);
        }

        private boolean urlMatches(J.MethodInvocation m, String url) {
            if (!(m.getArguments().get(0) instanceof J.Lambda)) {
                return false;
            }
            J.Lambda lambda = (J.Lambda)m.getArguments().get(0);
            if (!(lambda.getBody() instanceof J.Block)) {
                return false;
            }
            J.Block block = (J.Block)lambda.getBody();
            for (Statement statement : block.getStatements()) {
                J.MethodInvocation m1;
                if (statement instanceof J.Assignment || statement instanceof J.Return && ((J.Return)statement).getExpression() instanceof J.Assignment) {
                    J.Assignment assignment = (J.Assignment)(statement instanceof J.Return ? ((J.Return)statement).getExpression() : statement);
                    if (!(assignment.getVariable() instanceof J.Identifier) || !"url".equals(((J.Identifier)assignment.getVariable()).getSimpleName())) continue;
                    if (assignment.getAssignment() instanceof J.Literal && url.equals(((J.Literal)assignment.getAssignment()).getValue())) {
                        return true;
                    }
                    if (assignment.getAssignment() instanceof J.MethodInvocation && "uri".equals(((J.MethodInvocation)assignment.getAssignment()).getSimpleName())) {
                        if (((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0) instanceof J.Literal && url.equals(((J.Literal)((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0)).getValue())) {
                            return true;
                        }
                        if (!(((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0) instanceof K.StringTemplate)) continue;
                        String valueSource = TemplateAsString.getValueSource((J)((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0));
                        String testSource = ((K.StringTemplate)((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0)).getDelimiter() + url + ((K.StringTemplate)((J.MethodInvocation)assignment.getAssignment()).getArguments().get(0)).getDelimiter();
                        return testSource.equals(valueSource);
                    }
                    if (!(assignment.getAssignment() instanceof G.GString)) continue;
                    String valueSource = TemplateAsString.getValueSource((J)assignment.getAssignment());
                    String testSource = ((G.GString)assignment.getAssignment()).getDelimiter() + url + ((G.GString)assignment.getAssignment()).getDelimiter();
                    return testSource.equals(valueSource);
                }
                if (!(statement instanceof J.MethodInvocation) && (!(statement instanceof J.Return) || !(((J.Return)statement).getExpression() instanceof J.MethodInvocation)) || !"setUrl".equals((m1 = (J.MethodInvocation)(statement instanceof J.Return ? ((J.Return)statement).getExpression() : statement)).getSimpleName()) && !"url".equals(m1.getSimpleName())) continue;
                if (m1.getArguments().get(0) instanceof J.Literal && url.equals(((J.Literal)m1.getArguments().get(0)).getValue())) {
                    return true;
                }
                if (m1.getArguments().get(0) instanceof J.MethodInvocation && "uri".equals(((J.MethodInvocation)m1.getArguments().get(0)).getSimpleName()) && ((J.MethodInvocation)m1.getArguments().get(0)).getArguments().get(0) instanceof J.Literal && url.equals(((J.Literal)((J.MethodInvocation)m1.getArguments().get(0)).getArguments().get(0)).getValue())) {
                    return true;
                }
                if (!(m1.getArguments().get(0) instanceof G.GString)) continue;
                G.GString value = (G.GString)m1.getArguments().get(0);
                String valueSource = value.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new GroovyPrinter());
                String testSource = value.getDelimiter() + url + value.getDelimiter();
                return testSource.equals(valueSource);
            }
            return false;
        }
    }
}

