/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.util.StringJoiner;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.marker.GradleSettings;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.search.EffectiveMavenRepositoriesTable;
import org.openrewrite.maven.tree.MavenRepository;

public final class EffectiveGradlePluginRepositories
extends Recipe {
    private final String displayName = "List effective Gradle plugin repositories";
    private final String description = "Lists the Gradle plugin repositories that would be used for plugin resolution, in order of precedence. This includes Maven repositories defined in the settings.gradle pluginManagement section and build.gradle buildscript repositories as determined when the LST was produced.";
    @Option(displayName="Use markers", description="Whether to add markers for each effective Gradle plugin repository to the build or settings file. Default `false`.", required=false)
    private final @Nullable Boolean useMarkers;
    private final transient EffectiveMavenRepositoriesTable table = new EffectiveMavenRepositoriesTable((Recipe)this);

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new IsBuildGradle(), new IsSettingsGradle()}), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                this.stopAfterPreVisit();
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                StringJoiner repositories = new StringJoiner("\n");
                String path = PathUtils.separatorsToUnix((String)sourceFile.getSourcePath().toString());
                if (IsBuildGradle.matches(sourceFile.getSourcePath())) {
                    GradleProject gradleProject = sourceFile.getMarkers().findFirst(GradleProject.class).orElse(null);
                    if (gradleProject != null) {
                        for (MavenRepository repository : gradleProject.getBuildscript().getMavenRepositories()) {
                            repositories.add(repository.getUri());
                            EffectiveGradlePluginRepositories.this.table.insertRow(ctx, (Object)new EffectiveMavenRepositoriesTable.Row(path, repository.getUri()));
                        }
                    }
                } else {
                    GradleSettings gradleSettings = sourceFile.getMarkers().findFirst(GradleSettings.class).orElse(null);
                    if (gradleSettings != null) {
                        for (MavenRepository repository : gradleSettings.getBuildscript().getMavenRepositories()) {
                            repositories.add(repository.getUri());
                            EffectiveGradlePluginRepositories.this.table.insertRow(ctx, (Object)new EffectiveMavenRepositoriesTable.Row(path, repository.getUri()));
                        }
                    }
                }
                if (Boolean.TRUE.equals(EffectiveGradlePluginRepositories.this.useMarkers) && repositories.length() > 0) {
                    return SearchResult.found((Tree)sourceFile, (String)repositories.toString());
                }
                return sourceFile;
            }
        });
    }

    @Generated
    public EffectiveGradlePluginRepositories(@Nullable Boolean useMarkers) {
        this.useMarkers = useMarkers;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public @Nullable Boolean getUseMarkers() {
        return this.useMarkers;
    }

    @Generated
    public EffectiveMavenRepositoriesTable getTable() {
        return this.table;
    }

    @NonNull
    @Generated
    public String toString() {
        return "EffectiveGradlePluginRepositories(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ", useMarkers=" + this.getUseMarkers() + ", table=" + this.getTable() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EffectiveGradlePluginRepositories)) {
            return false;
        }
        EffectiveGradlePluginRepositories other = (EffectiveGradlePluginRepositories)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$useMarkers = this.getUseMarkers();
        Boolean other$useMarkers = other.getUseMarkers();
        if (this$useMarkers == null ? other$useMarkers != null : !((Object)this$useMarkers).equals(other$useMarkers)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof EffectiveGradlePluginRepositories;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $useMarkers = this.getUseMarkers();
        result = result * 59 + ($useMarkers == null ? 43 : ((Object)$useMarkers).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

