/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsSettingsGradle;
import org.openrewrite.gradle.plugins.RemovePluginVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class RemoveSettingsPlugin
extends Recipe {
    @Option(displayName="Plugin id", description="The plugin id to remove.", example="com.jfrog.bintray")
    private final String pluginId;
    private final String displayName = "Remove Gradle settings plugin";
    private final String description = "Remove plugin from Gradle settings file `plugins` block by id.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsSettingsGradle(), (TreeVisitor)new RemovePluginVisitor(this.pluginId));
    }

    @Generated
    public RemoveSettingsPlugin(String pluginId) {
        this.pluginId = pluginId;
    }

    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveSettingsPlugin(pluginId=" + this.getPluginId() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveSettingsPlugin)) {
            return false;
        }
        RemoveSettingsPlugin other = (RemoveSettingsPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveSettingsPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

