/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.plugins;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.RemoveExtension;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Statement;

public class RemoveDevelocityConfiguration
extends Recipe {
    protected static final MethodMatcher BUILD_CACHE_MATCHER = new MethodMatcher("*..* buildCache(..)");
    final String displayName = "Remove Develocity configuration";
    final String description = "Remove the Develocity Gradle plugin and associated configuration.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(BUILD_CACHE_MATCHER), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (BUILD_CACHE_MATCHER.matches((MethodCall)m) && m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Lambda) {
                    J.Lambda lambda = (J.Lambda)m.getArguments().get(0);
                    J.Block body = (J.Block)lambda.getBody();
                    List filteredStatements = ListUtils.filter((List)body.getStatements(), this::retainStatement);
                    if (filteredStatements.isEmpty()) {
                        return null;
                    }
                    return m.withArguments(Collections.singletonList(lambda.withBody((J)body.withStatements(filteredStatements))));
                }
                return m;
            }

            private boolean retainStatement(Statement stmt) {
                if (stmt instanceof J.Return && ((J.Return)stmt).getExpression() instanceof J.MethodInvocation) {
                    stmt = (J.MethodInvocation)((J.Return)stmt).getExpression();
                }
                if (!(stmt instanceof J.MethodInvocation)) {
                    return true;
                }
                J.MethodInvocation remote = (J.MethodInvocation)stmt;
                if (!"remote".equals(remote.getSimpleName())) {
                    return true;
                }
                if (remote.getArguments().isEmpty() || !(remote.getArguments().get(0) instanceof J.FieldAccess)) {
                    return true;
                }
                J.FieldAccess fieldAccess = (J.FieldAccess)remote.getArguments().get(0);
                if (!(fieldAccess.getTarget() instanceof J.Identifier)) {
                    return true;
                }
                J.Identifier target = (J.Identifier)fieldAccess.getTarget();
                return !"develocity".equals(target.getSimpleName()) && !"gradleEnterprise".equals(target.getSimpleName());
            }
        });
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new RemoveExtension("develocity"), new RemoveExtension("gradleEnterprise")});
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

