/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.internal.ChangeStringLiteral;
import org.openrewrite.gradle.marker.GradleDependencyConfiguration;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.trait.GradleDependency;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.DependencyNotation;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyClassifier
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New classifier", description="A qualification classifier for the dependency.", example="sources", required=false)
    private final @Nullable String newClassifier;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    private final @Nullable String configuration;
    private final String displayName = "Change a Gradle dependency classifier";
    private final String description = "Changes classifier of an existing dependency declared in `build.gradle` files.";

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s` to `%s`", this.groupId, this.artifactId, this.newClassifier);
    }

    public Validated<Object> validate() {
        return super.validate().and(DependencyMatcher.build((String)(this.groupId + ":" + this.artifactId)));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            GradleProject gradleProject;
            {
                this.depMatcher = Objects.requireNonNull((DependencyMatcher)DependencyMatcher.build((String)(ChangeDependencyClassifier.this.groupId + ":" + ChangeDependencyClassifier.this.artifactId)).getValue());
            }

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
                Optional maybeGp = cu.getMarkers().findFirst(GradleProject.class);
                if (!maybeGp.isPresent()) {
                    return cu;
                }
                this.gradleProject = (GradleProject)maybeGp.get();
                G.CompilationUnit g = super.visitCompilationUnit(cu, (Object)ctx);
                if (g != cu) {
                    g = g.withMarkers(g.getMarkers().setByType((Marker)this.updateGradleModel(this.gradleProject)));
                }
                return g;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                GradleDependency.Matcher gradleDependencyMatcher = new GradleDependency.Matcher().configuration(ChangeDependencyClassifier.this.configuration).groupId(ChangeDependencyClassifier.this.groupId).artifactId(ChangeDependencyClassifier.this.artifactId);
                if (!gradleDependencyMatcher.get(this.getCursor()).isPresent()) {
                    return m;
                }
                List depArgs = m.getArguments();
                if (depArgs.get(0) instanceof J.Literal) {
                    Dependency dependency;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (dependency = DependencyNotation.parse((String)gav)) != null && dependency.getVersion() != null && !Objects.equals(ChangeDependencyClassifier.this.newClassifier, dependency.getClassifier())) {
                        Dependency newDependency = dependency.withClassifier(ChangeDependencyClassifier.this.newClassifier);
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> ChangeStringLiteral.withStringValue((J.Literal)arg, DependencyNotation.toStringNotation((Dependency)newDependency))));
                    }
                } else if (depArgs.get(0) instanceof G.MapEntry) {
                    G.MapEntry classifierEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    String classifier = null;
                    String groupDelimiter = "'";
                    G.MapEntry mapEntry = null;
                    String classifierStringDelimiter = null;
                    int index = 0;
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            if (value.getValueSource() != null) {
                                groupDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            }
                        } else if ("name".equals(keyValue)) {
                            if (index > 0 && mapEntry == null) {
                                mapEntry = arg2;
                            }
                            artifactId = valueValue;
                        } else if ("version".equals(keyValue)) {
                            version = valueValue;
                        } else if ("classifier".equals(keyValue)) {
                            if (value.getValueSource() != null) {
                                classifierStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            }
                            classifierEntry = arg2;
                            classifier = valueValue;
                        }
                        ++index;
                    }
                    if (groupId == null || artifactId == null || Objects.equals(ChangeDependencyClassifier.this.newClassifier, classifier)) {
                        return m;
                    }
                    if (classifier == null) {
                        String delimiter = groupDelimiter;
                        List args = m.getArguments();
                        J.Literal keyLiteral = new J.Literal(Tree.randomId(), mapEntry == null ? Space.EMPTY : mapEntry.getKey().getPrefix(), Markers.EMPTY, (Object)"classifier", "classifier", null, JavaType.Primitive.String);
                        J.Literal valueLiteral = new J.Literal(Tree.randomId(), mapEntry == null ? Space.EMPTY : mapEntry.getValue().getPrefix(), Markers.EMPTY, (Object)ChangeDependencyClassifier.this.newClassifier, delimiter + ChangeDependencyClassifier.this.newClassifier + delimiter, null, JavaType.Primitive.String);
                        args.add(new G.MapEntry(Tree.randomId(), mapEntry == null ? Space.EMPTY : mapEntry.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)keyLiteral), (Expression)valueLiteral, null));
                        m = m.withArguments(args);
                    } else {
                        G.MapEntry finalClassifier = classifierEntry;
                        if (ChangeDependencyClassifier.this.newClassifier == null) {
                            m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> arg == finalClassifier ? null : arg));
                        } else {
                            String delimiter = classifierStringDelimiter;
                            m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                                if (arg == finalClassifier) {
                                    return finalClassifier.withValue((Expression)((J.Literal)finalClassifier.getValue()).withValue((Object)ChangeDependencyClassifier.this.newClassifier).withValueSource(delimiter + ChangeDependencyClassifier.this.newClassifier + delimiter));
                                }
                                return arg;
                            }));
                        }
                    }
                } else if (depArgs.get(0) instanceof G.MapLiteral) {
                    G.MapLiteral map = (G.MapLiteral)depArgs.get(0);
                    G.MapEntry classifierEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String classifier = null;
                    String groupDelimiter = "'";
                    G.MapEntry mapEntry = null;
                    String classifierStringDelimiter = null;
                    int index = 0;
                    for (G.MapEntry arg3 : map.getElements()) {
                        if (!(arg3.getKey() instanceof J.Literal) || !(arg3.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg3.getKey();
                        J.Literal value = (J.Literal)arg3.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            if (value.getValueSource() != null) {
                                groupDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            }
                        } else if ("name".equals(keyValue)) {
                            if (index > 0 && mapEntry == null) {
                                mapEntry = arg3;
                            }
                            artifactId = valueValue;
                        } else if ("classifier".equals(keyValue)) {
                            if (value.getValueSource() != null) {
                                classifierStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            }
                            classifierEntry = arg3;
                            classifier = valueValue;
                        }
                        ++index;
                    }
                    if (groupId == null || artifactId == null || Objects.equals(ChangeDependencyClassifier.this.newClassifier, classifier)) {
                        return m;
                    }
                    if (classifier == null) {
                        String delimiter = groupDelimiter;
                        G.MapEntry finalMapEntry = mapEntry;
                        J.Literal keyLiteral = new J.Literal(Tree.randomId(), mapEntry == null ? Space.EMPTY : mapEntry.getKey().getPrefix(), Markers.EMPTY, (Object)"classifier", "classifier", null, JavaType.Primitive.String);
                        J.Literal valueLiteral = new J.Literal(Tree.randomId(), mapEntry == null ? Space.EMPTY : mapEntry.getValue().getPrefix(), Markers.EMPTY, (Object)ChangeDependencyClassifier.this.newClassifier, delimiter + ChangeDependencyClassifier.this.newClassifier + delimiter, null, JavaType.Primitive.String);
                        m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                            G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                            return mapLiteral.withElements(ListUtils.concat((List)mapLiteral.getElements(), (Object)new G.MapEntry(Tree.randomId(), finalMapEntry == null ? Space.EMPTY : finalMapEntry.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)keyLiteral), (Expression)valueLiteral, null)));
                        }));
                    } else {
                        Iterator finalClassifier = classifierEntry;
                        if (ChangeDependencyClassifier.this.newClassifier == null) {
                            m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                                G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                                return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), e -> e == finalClassifier ? null : e));
                            }));
                        } else {
                            String delimiter = classifierStringDelimiter;
                            m = m.withArguments(ListUtils.mapFirst((List)m.getArguments(), arg -> {
                                G.MapLiteral mapLiteral = (G.MapLiteral)arg;
                                return mapLiteral.withElements(ListUtils.map((List)mapLiteral.getElements(), e -> {
                                    if (e == finalClassifier) {
                                        return finalClassifier.withValue((Expression)((J.Literal)finalClassifier.getValue()).withValue((Object)ChangeDependencyClassifier.this.newClassifier).withValueSource(delimiter + ChangeDependencyClassifier.this.newClassifier + delimiter));
                                    }
                                    return e;
                                }));
                            }));
                        }
                    }
                }
                return m;
            }

            private GradleProject updateGradleModel(GradleProject gp) {
                Map<String, GradleDependencyConfiguration> nameToConfiguration = gp.getNameToConfiguration();
                HashMap<String, GradleDependencyConfiguration> newNameToConfiguration = new HashMap<String, GradleDependencyConfiguration>(nameToConfiguration.size());
                boolean anyChanged = false;
                for (GradleDependencyConfiguration gdc : nameToConfiguration.values()) {
                    if (!StringUtils.isBlank((String)ChangeDependencyClassifier.this.configuration) && !ChangeDependencyClassifier.this.configuration.equals(gdc.getName())) {
                        newNameToConfiguration.put(gdc.getName(), gdc);
                        continue;
                    }
                    GradleDependencyConfiguration newGdc = gdc;
                    newGdc = newGdc.withRequested(ListUtils.map(gdc.getRequested(), requested -> {
                        if (this.depMatcher.matches(requested.getGroupId(), requested.getArtifactId()) && !Objects.equals(requested.getClassifier(), ChangeDependencyClassifier.this.newClassifier)) {
                            return requested.withClassifier(ChangeDependencyClassifier.this.newClassifier);
                        }
                        return requested;
                    }));
                    anyChanged |= (newGdc = newGdc.withDirectResolved(ListUtils.map(gdc.getDirectResolved(), resolved -> {
                        if (this.depMatcher.matches(resolved.getGroupId(), resolved.getArtifactId()) && !Objects.equals(resolved.getClassifier(), ChangeDependencyClassifier.this.newClassifier)) {
                            return resolved.withClassifier(ChangeDependencyClassifier.this.newClassifier);
                        }
                        return resolved;
                    }))) != gdc;
                    newNameToConfiguration.put(newGdc.getName(), newGdc);
                }
                if (anyChanged) {
                    gp = gp.withNameToConfiguration(newNameToConfiguration);
                }
                return gp;
            }
        });
    }

    @Generated
    public ChangeDependencyClassifier(String groupId, String artifactId, @Nullable String newClassifier, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newClassifier = newClassifier;
        this.configuration = configuration;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getNewClassifier() {
        return this.newClassifier;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeDependencyClassifier(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newClassifier=" + this.getNewClassifier() + ", configuration=" + this.getConfiguration() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyClassifier)) {
            return false;
        }
        ChangeDependencyClassifier other = (ChangeDependencyClassifier)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newClassifier = this.getNewClassifier();
        String other$newClassifier = other.getNewClassifier();
        if (this$newClassifier == null ? other$newClassifier != null : !this$newClassifier.equals(other$newClassifier)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeDependencyClassifier;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newClassifier = this.getNewClassifier();
        result = result * 59 + ($newClassifier == null ? 43 : $newClassifier.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

