/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.AddDependencyVisitor;
import org.openrewrite.gradle.GradleConfigurationFilter;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.gradle.search.FindJVMTestSuites;
import org.openrewrite.gradle.trait.JvmTestSuite;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.semver.Semver;

public final class AddPlatformDependency
extends ScanningRecipe<Scanned> {
    private final MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Group", description="The first part of a dependency coordinate 'com.google.guava:guava:VERSION'.", example="com.google.guava")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'com.google.guava:guava:VERSION'", example="guava")
    private final String artifactId;
    @Option(displayName="Version", description="An exact version number or node-style semver selector used to select the version number. You can also use `latest.release` for the latest available version and `latest.patch` if the current version is a valid semantic version. For more details, you can look at the documentation page of [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors).", example="29.X", required=false)
    private final @Nullable String version;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example, Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Configuration", description="A configuration to use when it is not what can be inferred from usage. Most of the time this will be left empty, but is used when adding a new, as yet unused, dependency.", example="implementation", required=false)
    private final @Nullable String configuration;
    @Option(displayName="Enforced", description="Used to determine whether the platform dependency should be enforcedPlatform.", example="true", required=false)
    private final @Nullable Boolean enforced;
    private final String displayName = "Add Gradle platform dependency";
    private final String description = "Add a gradle platform dependency to a `build.gradle` file in the correct configuration based on where it is used.";

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.groupId, this.artifactId, this.version);
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.version != null) {
            validated = validated.and(Semver.validate((String)this.version, (String)this.versionPattern));
        }
        return validated;
    }

    public Scanned getInitialValue(ExecutionContext ctx) {
        return new Scanned();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Scanned acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!(tree instanceof SourceFile)) {
                    return tree;
                }
                SourceFile sourceFile = (SourceFile)tree;
                sourceFile.getMarkers().findFirst(JavaProject.class).ifPresent(javaProject -> {
                    Set configurations = acc2.configurationsByProject.computeIfAbsent((JavaProject)javaProject, ignored -> new HashSet());
                    sourceFile.getMarkers().findFirst(JavaSourceSet.class).ifPresent(sourceSet -> configurations.add("main".equals(sourceSet.getName()) ? "implementation" : sourceSet.getName() + "Implementation"));
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Scanned acc) {
        return Preconditions.check((!acc.configurationsByProject.isEmpty() ? 1 : 0) != 0, (TreeVisitor)Preconditions.check(new IsBuildGradle(), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public @Nullable J visit(@Nullable Tree tree, ExecutionContext ctx) {
                Set<String> resolvedConfigurations;
                if (!(tree instanceof JavaSourceFile)) {
                    return (J)tree;
                }
                JavaSourceFile s = (JavaSourceFile)tree;
                Optional maybeJp = s.getMarkers().findFirst(JavaProject.class);
                Optional maybeGp = s.getMarkers().findFirst(GradleProject.class);
                if (!(maybeJp.isPresent() && acc.configurationsByProject.containsKey(maybeJp.get()) && maybeGp.isPresent())) {
                    return s;
                }
                JavaProject jp = (JavaProject)maybeJp.get();
                GradleProject gp = (GradleProject)maybeGp.get();
                Set<String> set = resolvedConfigurations = StringUtils.isBlank((String)AddPlatformDependency.this.configuration) ? (Set)acc.configurationsByProject.getOrDefault(jp, new HashSet()) : new HashSet<String>(Collections.singletonList(AddPlatformDependency.this.configuration));
                if (resolvedConfigurations.isEmpty()) {
                    resolvedConfigurations.add("implementation");
                }
                GradleConfigurationFilter gradleConfigurationFilter = new GradleConfigurationFilter(gp, resolvedConfigurations);
                gradleConfigurationFilter.removeTransitiveConfigurations();
                gradleConfigurationFilter.removeConfigurationsContainingDependency(new GroupArtifact(AddPlatformDependency.this.groupId, AddPlatformDependency.this.artifactId));
                resolvedConfigurations = gradleConfigurationFilter.getFilteredConfigurations();
                if (resolvedConfigurations.isEmpty()) {
                    return s;
                }
                Set<JvmTestSuite> jvmTestSuites = FindJVMTestSuites.jvmTestSuites((SourceFile)s);
                AddDependencyVisitor.DependencyModifier modifier = Boolean.TRUE.equals(AddPlatformDependency.this.enforced) ? AddDependencyVisitor.DependencyModifier.ENFORCED_PLATFORM : AddDependencyVisitor.DependencyModifier.PLATFORM;
                for (String resolvedConfiguration : resolvedConfigurations) {
                    JvmTestSuite jvmTestSuite = this.maybeJvmTestSuite(resolvedConfiguration, jvmTestSuites);
                    if (jvmTestSuite != null) {
                        s = (JavaSourceFile)jvmTestSuite.addDependency(resolvedConfiguration, AddPlatformDependency.this.groupId, AddPlatformDependency.this.artifactId, AddPlatformDependency.this.version, AddPlatformDependency.this.versionPattern, null, null, AddPlatformDependency.this.metadataFailures, modifier, ctx).visitNonNull((Tree)s, (Object)ctx);
                        continue;
                    }
                    s = (JavaSourceFile)new AddDependencyVisitor(AddPlatformDependency.this.groupId, AddPlatformDependency.this.artifactId, AddPlatformDependency.this.version, AddPlatformDependency.this.versionPattern, resolvedConfiguration, null, null, AddPlatformDependency.this.metadataFailures, this::isTopLevel, modifier).visitNonNull((Tree)s, ctx);
                }
                return s;
            }

            private boolean isTopLevel(Cursor cursor) {
                return cursor.getParentOrThrow().firstEnclosing(J.MethodInvocation.class) == null;
            }

            private @Nullable JvmTestSuite maybeJvmTestSuite(String configuration, Set<JvmTestSuite> jvmTestSuites) {
                for (JvmTestSuite jvmTestSuite : jvmTestSuites) {
                    if (!jvmTestSuite.isAcceptable(configuration)) continue;
                    return jvmTestSuite;
                }
                return null;
            }
        }));
    }

    @Generated
    public AddPlatformDependency(String groupId, String artifactId, @Nullable String version, @Nullable String versionPattern, @Nullable String configuration, @Nullable Boolean enforced) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.configuration = configuration;
        this.enforced = enforced;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable String getConfiguration() {
        return this.configuration;
    }

    @Generated
    public @Nullable Boolean getEnforced() {
        return this.enforced;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddPlatformDependency(metadataFailures=" + this.getMetadataFailures() + ", groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", versionPattern=" + this.getVersionPattern() + ", configuration=" + this.getConfiguration() + ", enforced=" + this.getEnforced() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPlatformDependency)) {
            return false;
        }
        AddPlatformDependency other = (AddPlatformDependency)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$enforced = this.getEnforced();
        Boolean other$enforced = other.getEnforced();
        if (this$enforced == null ? other$enforced != null : !((Object)this$enforced).equals(other$enforced)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddPlatformDependency;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enforced = this.getEnforced();
        result = result * 59 + ($enforced == null ? 43 : ((Object)$enforced).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public static class Scanned {
        Map<JavaProject, Set<String>> configurationsByProject = new HashMap<JavaProject, Set<String>>();
    }
}

