/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.gradle.util.Dependency;
import org.openrewrite.gradle.util.DependencyStringNotationConverter;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public class InsertDependencyComparator
implements Comparator<Statement> {
    private final Map<Statement, Float> positions = new LinkedHashMap<Statement, Float>();
    private Statement afterDependency;
    private Statement beforeDependency;
    private static final Comparator<Statement> dependenciesComparator = (s1, s2) -> {
        String artifactId2;
        String groupId2;
        String configuration2;
        J.MethodInvocation d1 = s1 instanceof J.Return ? (J.MethodInvocation)((J.Return)s1).getExpression() : (J.MethodInvocation)s1;
        J.MethodInvocation d2 = s2 instanceof J.Return ? (J.MethodInvocation)((J.Return)s2).getExpression() : (J.MethodInvocation)s2;
        assert (d1 != null && d2 != null);
        String configuration1 = d1.getSimpleName();
        if (!configuration1.equals(configuration2 = d2.getSimpleName())) {
            return configuration1.compareTo(configuration2);
        }
        String groupId1 = InsertDependencyComparator.getEntry("group", d1).orElse("");
        if (!groupId1.equals(groupId2 = InsertDependencyComparator.getEntry("group", d2).orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(groupId1, groupId2);
        }
        String artifactId1 = InsertDependencyComparator.getEntry("name", d1).orElse("");
        if (!artifactId1.equals(artifactId2 = InsertDependencyComparator.getEntry("name", d2).orElse(""))) {
            return InsertDependencyComparator.comparePartByPart(artifactId1, artifactId2);
        }
        String classifier1 = InsertDependencyComparator.getEntry("classifier", d1).orElse(null);
        String classifier2 = InsertDependencyComparator.getEntry("classifier", d2).orElse(null);
        if (classifier1 == null && classifier2 != null) {
            return -1;
        }
        if (classifier1 != null) {
            if (classifier2 == null) {
                return 1;
            }
            if (!classifier1.equals(classifier2)) {
                return classifier1.compareTo(classifier2);
            }
        }
        return InsertDependencyComparator.getEntry("version", d1).orElse("").compareTo(InsertDependencyComparator.getEntry("version", d2).orElse(""));
    };

    public InsertDependencyComparator(List<Statement> existingStatements, J.MethodInvocation dependencyToAdd) {
        float f;
        int len = existingStatements.size();
        for (int i = 0; i < len; ++i) {
            this.positions.put(existingStatements.get(i), Float.valueOf(i));
        }
        List ideallySortedDependencies = existingStatements.stream().filter(s -> s instanceof J.MethodInvocation || s instanceof J.Return && ((J.Return)s).getExpression() instanceof J.MethodInvocation).collect(Collectors.toList());
        ideallySortedDependencies.add(dependencyToAdd);
        ideallySortedDependencies.sort(dependenciesComparator);
        int len2 = ideallySortedDependencies.size();
        for (int i = 0; i < len2; ++i) {
            Statement d = (Statement)ideallySortedDependencies.get(i);
            if (dependencyToAdd != d) continue;
            if (i > 0) {
                this.afterDependency = (Statement)ideallySortedDependencies.get(i - 1);
            }
            if (i + 1 >= ideallySortedDependencies.size()) break;
            this.beforeDependency = (Statement)ideallySortedDependencies.get(i + 1);
            break;
        }
        float insertPos = this.afterDependency == null ? -0.5f : 0.5f;
        ArrayList<Statement> statements = new ArrayList<Statement>(this.positions.keySet());
        float f2 = f = this.afterDependency == null ? 0.0f : this.positions.get(this.afterDependency).floatValue();
        while (f < (float)statements.size()) {
            Statement s2 = (Statement)statements.get((int)f);
            if (s2 instanceof J.MethodInvocation || s2 instanceof J.Return && ((J.Return)s2).getExpression() instanceof J.MethodInvocation) {
                this.positions.put((Statement)dependencyToAdd, Float.valueOf(this.positions.get(statements.get((int)f)).floatValue() + insertPos));
                break;
            }
            f += 1.0f;
        }
    }

    @Override
    public int compare(Statement o1, Statement o2) {
        return this.positions.get(o1).compareTo(this.positions.get(o2));
    }

    private static Optional<String> getEntry(String entry, J.MethodInvocation invocation) {
        if (invocation.getArguments().get(0) instanceof J.Literal) {
            Object value = ((J.Literal)invocation.getArguments().get(0)).getValue();
            if (value == null) {
                return Optional.empty();
            }
            Dependency dependency = DependencyStringNotationConverter.parse((String)value);
            if (dependency == null) {
                return Optional.empty();
            }
            switch (entry) {
                case "group": {
                    return Optional.ofNullable(dependency.getGroupId());
                }
                case "name": {
                    return Optional.ofNullable(dependency.getArtifactId());
                }
                case "version": {
                    return Optional.ofNullable(dependency.getVersion());
                }
                case "classifier": {
                    return Optional.ofNullable(dependency.getClassifier());
                }
            }
        } else if (invocation.getArguments().get(0) instanceof G.MapEntry) {
            for (Expression e : invocation.getArguments()) {
                G.MapEntry mapEntry;
                if (!(e instanceof G.MapEntry) || !((mapEntry = (G.MapEntry)e).getKey() instanceof J.Literal) || !(mapEntry.getValue() instanceof J.Literal) || !entry.equals(((J.Literal)mapEntry.getKey()).getValue())) continue;
                return Optional.ofNullable((String)((J.Literal)mapEntry.getValue()).getValue());
            }
        }
        return Optional.empty();
    }

    private static int comparePartByPart(String d1, String d2) {
        String[] d1Parts = d1.split("[.-]");
        String[] d2Parts = d2.split("[.-]");
        for (int i = 0; i < Math.min(d1Parts.length, d2Parts.length); ++i) {
            if (d1Parts[i].equals(d2Parts[i])) continue;
            return d1Parts[i].compareTo(d2Parts[i]);
        }
        return d1Parts.length - d2Parts.length;
    }

    @Generated
    public Statement getAfterDependency() {
        return this.afterDependency;
    }

    @Generated
    public Statement getBeforeDependency() {
        return this.beforeDependency;
    }
}

