/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.truth;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public class TruthCustomSubjectsToAssertJ
extends Recipe {
    private static final MethodMatcher ASSERT_ABOUT = new MethodMatcher("com.google.common.truth.Truth assertAbout(..)");
    final String displayName = "Migrate Truth custom subjects to AssertJ";
    final String description = "Marks Google Truth's `assertAbout()` usage for manual review as AssertJ handles custom assertions differently.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_ABOUT), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_ABOUT.matches((MethodCall)mi)) {
                    return (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"Truth's assertAbout() with custom subjects requires manual migration to AssertJ custom assertions");
                }
                return mi;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

