/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.testng;

import java.util.List;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class TestNgAssertNotEqualsToAssertThat
extends Recipe {
    final String displayName = "TestNG `assertNotEquals` to AssertJ";
    final String description = "Convert TestNG-style `assertNotEquals()` to AssertJ's `assertThat().isNotEqualTo()`.";
    private static final MethodMatcher TESTNG_ASSERT_METHOD = new MethodMatcher("org.testng.Assert assertNotEquals(..)");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(TESTNG_ASSERT_METHOD), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (!TESTNG_ASSERT_METHOD.matches((MethodCall)method)) {
                    return method;
                }
                List args = method.getArguments();
                Expression expected = (Expression)args.get(1);
                Expression actual = (Expression)args.get(0);
                if (args.size() == 2) {
                    method = (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).isNotEqualTo(#{any()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, expected});
                } else if (args.size() == 3 && !this.isFloatingPointType((Expression)args.get(2))) {
                    Expression message = (Expression)args.get(2);
                    method = (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).as(#{any(String)}).isNotEqualTo(#{any()});").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, message, expected});
                } else if (args.size() == 3) {
                    method = (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).isNotCloseTo(#{any()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, expected, args.get(2)});
                    this.maybeAddImport("org.assertj.core.api.Assertions", "within", false);
                } else {
                    Expression message = (Expression)args.get(3);
                    method = (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any()}).as(#{any(String)}).isNotCloseTo(#{any()}, within(#{any()}));").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat", "org.assertj.core.api.Assertions.within"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3"})).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{actual, message, expected, args.get(2)});
                    this.maybeAddImport("org.assertj.core.api.Assertions", "within", false);
                }
                this.maybeRemoveImport("org.testng.Assert");
                this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat", false);
                return method;
            }

            private boolean isFloatingPointType(Expression expression) {
                JavaType.FullyQualified fullyQualified = TypeUtils.asFullyQualified((JavaType)expression.getType());
                if (fullyQualified != null) {
                    String typeName = fullyQualified.getFullyQualifiedName();
                    return "java.lang.Double".equals(typeName) || "java.lang.Float".equals(typeName);
                }
                JavaType.Primitive parameterType = TypeUtils.asPrimitive((JavaType)expression.getType());
                return parameterType == JavaType.Primitive.Double || parameterType == JavaType.Primitive.Float;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

